<?php
// admin/store_categories_edit.php
declare(strict_types=1);

$CFG_PATH = __DIR__ . '/config.php';
$INC_DIR  = __DIR__ . '/inc';
require_once $CFG_PATH;
require_once $INC_DIR . '/auth.php';
require_login();

/* CSRF */
if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }

/* Helpers */
if (!function_exists('e')) { function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }
function to_en_digits(string $s): string {
  $ar=['٠','١','٢','٣','٤','٥','٦','٧','٨','٩']; $fa=['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹']; $en=['0','1','2','3','4','5','6','7','8','9'];
  return str_replace($fa,$en,str_replace($ar,$en,$s));
}
function to_int($v): int { $v=to_en_digits(trim((string)$v)); if($v==='')return 0; $v=preg_replace('/[^0-9\-]/','',$v); return (int)$v; }
function make_slug(string $s, string $fallback=''): string {
  $s = to_en_digits($s); $s = strtolower($s);
  $s = preg_replace('/\s+/', '-', $s);
  $s = preg_replace('/[^a-z0-9_-]/', '', $s);
  $s = trim($s, '-_');
  if ($s==='') {
    $fallback = strtolower($fallback);
    $fallback = preg_replace('/\s+/', '-', $fallback);
    $fallback = preg_replace('/[^a-z0-9_-]/', '', $fallback);
    $fallback = trim($fallback, '-_');
    $s = $fallback !== '' ? $fallback : ('cat-'.time());
  }
  return $s;
}

$pdo = db();
$msg=null; $err=null; $dbg=isset($_GET['dbg']);

$id=(int)($_GET['id'] ?? 0);
$editing = $id>0;

$fields = [
  'name'       => '',
  'slug'       => '',
  'is_active'  => '1',
  'sort_order' => '0',
  'meta_json'  => '',
];

if ($editing) {
  $st=$pdo->prepare("SELECT * FROM store_categories WHERE id=? LIMIT 1");
  $st->execute([$id]);
  $row=$st->fetch(PDO::FETCH_ASSOC);
  if ($row) foreach($fields as $k=>$_){ $fields[$k]=(string)($row[$k]??$fields[$k]); } else { $editing=false; $id=0; }
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err='رمز الأمان غير صالح.';
  } else {
    foreach($fields as $k=>$_){ $fields[$k]=trim((string)($_POST[$k]??$fields[$k])); }
    $fields['is_active']  = isset($_POST['is_active']) ? '1' : '0';
    $fields['sort_order'] = (string)to_int($fields['sort_order']);
    $fields['slug'] = make_slug($fields['slug'], $fields['name']);

    // تحقق JSON اختياري (الحقل TEXT، لكن نتحقق شكليًا)
    if ($fields['meta_json']!=='') {
      json_decode($fields['meta_json'], true);
      if (json_last_error()!==JSON_ERROR_NONE) {
        $err='حقل meta_json ليس JSON صالحًا: '.json_last_error_msg();
      }
    }

    if (!$err) {
      try {
        if ($editing) {
          $sql="UPDATE store_categories SET name=?, slug=?, is_active=?, sort_order=?, meta_json=? WHERE id=? LIMIT 1";
          $pdo->prepare($sql)->execute([
            $fields['name'], $fields['slug'], (int)$fields['is_active'], (int)$fields['sort_order'], $fields['meta_json'], $id
          ]);
          $msg='تم حفظ التعديلات.';
        } else {
          $sql="INSERT INTO store_categories (name, slug, is_active, sort_order, meta_json, created_at)
                VALUES (?,?,?,?,?,NOW())";
          $pdo->prepare($sql)->execute([
            $fields['name'], $fields['slug'], (int)$fields['is_active'], (int)$fields['sort_order'], $fields['meta_json']
          ]);
          $newId=(int)$pdo->lastInsertId();
          header('Location: store_categories_edit.php?id='.$newId.'&created=1'); exit;
        }
      } catch (Throwable $e) {
        $msgText='تعذّر الحفظ.';
        $em=$e->getMessage();
        if (stripos($em,'Duplicate entry')!==false && stripos($em,"for key 'slug'")!==false) {
          $msgText='تعذّر الحفظ: قيمة SLUG مستخدمة مسبقًا.';
        }
        $err=$msgText . ($dbg ? ' ('.$em.')' : '');
      }
    }
  }
}

$PAGE_TITLE = $editing ? "تعديل صنف #$id" : "إضافة صنف";
require $INC_DIR.'/header.php';
require $INC_DIR.'/sidebar.php';
?>
<style>
.form .row{display:flex;gap:12px;flex-wrap:wrap}
.form .row .input{flex:1;min-width:240px}
</style>

<div class="card">
  <?php if (isset($_GET['created'])): ?><div class="alert" style="border-color:#22c55e;">تمت إضافة الصنف. يمكنك متابعة التعديل هنا.</div><?php endif; ?>
  <?php if ($msg): ?><div class="alert" style="border-color:#22c55e;"><?= e($msg) ?></div><?php endif; ?>
  <?php if ($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>

  <form class="form" method="post">
    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">

    <div class="row">
      <div class="input">
        <label>الاسم</label>
        <input type="text" name="name" required value="<?= e($fields['name']) ?>">
      </div>
      <div class="input">
        <label>SLUG (فريد)</label>
        <input type="text" name="slug" required value="<?= e($fields['slug']) ?>" placeholder="english-letters-numbers">
      </div>
      <label class="input" style="align-self:flex-end;display:flex;gap:8px">
        <input type="checkbox" name="is_active" value="1"<?= $fields['is_active']==='1'?' checked':''; ?>> مفعل
      </label>
      <div class="input">
        <label>الترتيب</label>
        <input type="number" name="sort_order" step="1" value="<?= e($fields['sort_order']) ?>">
      </div>
    </div>

    <div class="input">
      <label>Meta JSON (اختياري)</label>
      <textarea name="meta_json" rows="6" placeholder='{"icon":"🎖️","color":"#FFD700"}'><?= e($fields['meta_json']) ?></textarea>
    </div>

    <div style="display:flex;gap:8px;margin-top:12px">
      <button class="btn" type="submit"><?= $editing ? 'حفظ التعديلات' : 'إضافة' ?></button>
      <a class="btn secondary" href="store_categories.php">رجوع إلى القائمة</a>
    </div>
  </form>
</div>

<?php require $INC_DIR.'/footer.php'; ?>
