<?php
// wesalchat/admin/store/orders.php
declare(strict_types=1);

$CFG_PATH = __DIR__ . '/config.php';
$INC_DIR  = __DIR__ . '/inc';
require_once $CFG_PATH;
require_once $INC_DIR . '/auth.php';
require_login();

if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }
if (!function_exists('e')) { function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }
function fmt_dt(?string $s): string { if(!$s)return''; $t=strtotime($s); return $t>0?date('Y-m-d H:i',$t):e($s); }
function fmt_money($v): string { return number_format((float)$v, 2); }

$pdo = db(); $err=null;

/* Filters */
$userId   = (int)($_GET['user_id'] ?? 0);
$toUserId = (int)($_GET['to_user_id'] ?? 0);
$itemId   = (int)($_GET['item_id'] ?? 0);
$action   = trim($_GET['action'] ?? '');   // مثال: buy / gift
$page     = max(1, (int)($_GET['page'] ?? 1));
$perPage  = 50; $offset=($page-1)*$perPage;

$where="1=1"; $params=[];
if($userId>0){ $where.=" AND o.user_id=?"; $params[]=$userId; }
if($toUserId>0){ $where.=" AND o.to_user_id=?"; $params[]=$toUserId; }
if($itemId>0){ $where.=" AND o.item_id=?"; $params[]=$itemId; }
if($action!==''){ $where.=" AND o.action=?"; $params[]=$action; }

$total=0;
try{
  $st=$pdo->prepare("SELECT COUNT(*) FROM store_orders o WHERE $where");
  $st->execute($params); $total=(int)$st->fetchColumn();
}catch(Throwable $e){ $err='تعذّر حساب الإجمالي.'; }

$pages=max(1,(int)ceil($total/$perPage));

$rows=[];
try{
  $sql="SELECT o.*, si.name AS item_name, u1.username AS user_name, u2.username AS to_user_name
        FROM store_orders o
        LEFT JOIN store_items si ON si.id=o.item_id
        LEFT JOIN users u1 ON u1.id=o.user_id
        LEFT JOIN users u2 ON u2.id=o.to_user_id
        WHERE $where
        ORDER BY o.id DESC
        LIMIT $perPage OFFSET $offset";
  $st=$pdo->prepare($sql); $st->execute($params);
  $rows=$st->fetchAll(PDO::FETCH_ASSOC) ?: [];
}catch(Throwable $e){ $err='تعذّر جلب البيانات.' . (isset($_GET['dbg']) ? ' ('.$e->getMessage().')' : ''); }

$PAGE_TITLE="أوامر المتجر";
require $INC_DIR.'/header.php';
require $INC_DIR.'/sidebar.php';
?>
<style>
.orders-page .table{width:100%;border-collapse:separate;border-spacing:0;background:var(--panel);border:1px solid var(--border);border-radius:12px;overflow:hidden;table-layout:fixed}
.orders-page .table td,.orders-page .table th{padding:10px 12px;border-bottom:1px solid var(--border);vertical-align:middle;text-align:start}
.orders-page .table thead th{background:#0b1220;color:var(--text);font-weight:700;position:sticky;top:0;z-index:3;box-shadow:inset 0 -1px 0 var(--border)}
.orders-page .table tbody tr:nth-child(even) td{background:rgba(255,255,255,.015)}
.orders-page .table tbody tr:hover td{background:rgba(59,130,246,.08)}
.orders-page .table-wrap{max-height:70vh;overflow:auto;position:relative}
.orders-page .td-center{text-align:center}
.orders-page .ellipsis{max-width:280px;display:inline-block;overflow:hidden;white-space:nowrap;text-overflow:ellipsis}
.orders-page .badge{display:inline-block;padding:2px 8px;border-radius:999px;border:1px solid var(--border);font-size:12px}
.orders-page .col-id{width:70px}.orders-page .col-user{width:220px}.orders-page .col-to{width:220px}.orders-page .col-item{width:260px}.orders-page .col-price{width:120px}.orders-page .col-action{width:120px}.orders-page .col-created{width:170px}
</style>

<div class="orders-page">
  <div class="card" style="margin-bottom:16px;">
    <form method="get" class="form" style="display:flex; gap:12px; align-items:flex-end; flex-wrap:wrap;">
      <div class="input"><label>User ID</label><input type="number" name="user_id" min="1" value="<?= $userId?:'' ?>"></div>
      <div class="input"><label>To User ID</label><input type="number" name="to_user_id" min="1" value="<?= $toUserId?:'' ?>"></div>
      <div class="input"><label>Item ID</label><input type="number" name="item_id" min="1" value="<?= $itemId?:'' ?>"></div>
      <div class="input">
        <label>العملية</label>
        <input type="text" name="action" value="<?= e($action) ?>" placeholder="مثال: buy / gift">
      </div>
      <button class="btn sm" type="submit">بحث</button>
      <?php if ($userId||$toUserId||$itemId||$action!==''): ?>
        <a class="btn sm secondary" href="orders.php">مسح الفلاتر</a>
      <?php endif; ?>
      <div style="margin-inline-start:auto;opacity:.9;">إجمالي: <b><?= $total ?></b></div>
    </form>
    <?php if ($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>
  </div>

  <div class="card">
    <div class="table-wrap">
      <table class="table">
        <colgroup>
          <col class="col-id"><col class="col-user"><col class="col-to"><col class="col-item"><col class="col-price"><col class="col-action"><col class="col-created">
        </colgroup>
        <thead>
          <tr>
            <th class="td-center">#</th>
            <th>المرسل (User)</th>
            <th>إلى (To User)</th>
            <th>العنصر</th>
            <th>السعر</th>
            <th>العملية</th>
            <th>أُنشيء</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $r): ?>
          <tr>
            <td class="td-center"><?= (int)$r['id'] ?></td>
            <td><?php if(!empty($r['user_name'])): ?><span class="ellipsis" title="<?= e('ID: '.$r['user_id']) ?>"><?= e($r['user_name']) ?></span><?php else: ?>ID: <?= (int)$r['user_id'] ?><?php endif; ?></td>
            <td><?php if(!empty($r['to_user_name'])): ?><span class="ellipsis" title="<?= e('ID: '.$r['to_user_id']) ?>"><?= e($r['to_user_name']) ?></span><?php else: ?><?= $r['to_user_id']?('ID: '.(int)$r['to_user_id']):'—' ?><?php endif; ?></td>
            <td><span class="ellipsis" title="<?= e((string)$r['item_name']) ?>"><?= e((string)($r['item_name'] ?: 'ID: '.$r['item_id'])) ?></span></td>
            <td><?= fmt_money($r['price']) ?></td>
            <td><span class="badge"><?= e((string)$r['action']) ?></span></td>
            <td><?= fmt_dt($r['created_at'] ?? '') ?></td>
          </tr>
          <?php endforeach; ?>
          <?php if(!$rows): ?><tr><td colspan="7" style="text-align:center;opacity:.8;">لا توجد بيانات</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>

    <?php if($pages>1): ?>
      <div style="display:flex;gap:8px;margin-top:12px;flex-wrap:wrap;">
        <?php for($p=1;$p<=$pages;$p++):
          $url='orders.php?page='.$p
              .($userId? '&user_id='.$userId:'')
              .($toUserId? '&to_user_id='.$toUserId:'')
              .($itemId? '&item_id='.$itemId:'')
              .($action!==''? '&action='.urlencode($action):'');
          $is=$p===$page; ?>
          <a href="<?= e($url) ?>" class="btn sm <?= $is?'':'secondary' ?>"<?= $is?' style="pointer-events:none;opacity:.8;"':''; ?>><?= $p ?></a>
        <?php endfor; ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<?php require $INC_DIR.'/footer.php'; ?>
