<?php
// admin/moment_categories.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

/* ---------- CSRF ---------- */
if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }

/* ---------- Helpers ---------- */
if (!function_exists('e')) {
  function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}

/* ---------- DB ---------- */
$pdo = db();
$msg = null; $err = null;

/* ---------- Actions ---------- */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.';
  } else {
    $action = $_POST['action'] ?? '';
    try {
      if ($action === 'create') {
        $name_ar   = trim((string)($_POST['name_ar'] ?? ''));
        $name_en   = trim((string)($_POST['name_en'] ?? ''));
        $sort      = (int)($_POST['sort_order'] ?? 0);
        if ($name_ar === '' && $name_en === '') {
          $err = 'أدخل اسمًا عربيًا أو إنجليزيًا.';
        } else {
          if ($sort <= 0) {
            $next = (int)($pdo->query("SELECT IFNULL(MAX(sort_order),0)+1 FROM moment_categories")->fetchColumn());
            $sort = max(1, $next);
          }
          $st = $pdo->prepare("INSERT INTO moment_categories(name_ar,name_en,sort_order) VALUES (?,?,?)");
          $st->execute([$name_ar!==''?$name_ar:null, $name_en!==''?$name_en:null, $sort]);
          $msg = 'تم إنشاء الفئة.';
        }
      } elseif ($action === 'update') {
        $id      = (int)($_POST['id'] ?? 0);
        $name_ar = trim((string)($_POST['name_ar'] ?? ''));
        $name_en = trim((string)($_POST['name_en'] ?? ''));
        $sort    = (int)($_POST['sort_order'] ?? 0);
        if ($id<=0) $err='مُعرّف غير صالح.';
        else {
          $st = $pdo->prepare("UPDATE moment_categories SET name_ar=?, name_en=?, sort_order=? WHERE id=? LIMIT 1");
          $st->execute([$name_ar!==''?$name_ar:null, $name_en!==''?$name_en:null, $sort>0?$sort:1, $id]);
          $msg = 'تم حفظ التعديلات.';
        }
      } elseif ($action === 'delete') {
        $id = (int)($_POST['id'] ?? 0);
        if ($id<=0) $err='مُعرّف غير صالح.';
        else {
          $pdo->prepare("DELETE FROM moment_categories WHERE id=? LIMIT 1")->execute([$id]);
          $msg = 'تم حذف الفئة.';
        }
      }
    } catch (Throwable $e) {
      $err = 'حدث خطأ أثناء التنفيذ.';
    }
  }
}

/* ---------- Search / Paging ---------- */
$q       = trim($_GET['q'] ?? '');
$page    = max(1, (int)($_GET['page'] ?? 1));
$perPage = 50;
$offset  = ($page - 1) * $perPage;

$where = "1=1"; $params = [];
if ($q !== '') {
  $where .= " AND (name_ar LIKE ? OR name_en LIKE ?)";
  $kw = "%$q%"; array_push($params, $kw, $kw);
}

$st = $pdo->prepare("SELECT COUNT(*) FROM moment_categories WHERE $where");
$st->execute($params);
$total = (int)$st->fetchColumn();
$pages = max(1, (int)ceil($total/$perPage));

$sql = "SELECT id, name_ar, name_en, sort_order
        FROM moment_categories
        WHERE $where
        ORDER BY sort_order ASC, id ASC
        LIMIT $perPage OFFSET $offset";
$st = $pdo->prepare($sql); $st->execute($params);
$rows = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];

/* ---------- Render ---------- */
$PAGE_TITLE = "الفئات";
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';
?>
<style>
.cat-page .table{width:100%;border-collapse:separate;border-spacing:0;background:var(--panel);border:1px solid var(--border);border-radius:12px;overflow:hidden;table-layout:fixed}
.cat-page .table td,.cat-page .table th{padding:10px 12px;border-bottom:1px solid var(--border);vertical-align:middle;text-align:start}
.cat-page .table thead th{background:#0b1220;color:var(--text);font-weight:700;position:sticky;top:0;z-index:3;box-shadow:inset 0 -1px 0 var(--border)}
.cat-page .table tbody tr:nth-child(even) td{background:rgba(255,255,255,.015)}
.cat-page .table tbody tr:hover td{background:rgba(59,130,246,.08)}
.cat-page .table-wrap{max-height:70vh;overflow:auto;position:relative}
.cat-page .td-center{text-align:center}
.cat-page .col-id{width:70px}.cat-page .col-ar{width:260px}.cat-page .col-en{width:260px}.cat-page .col-sort{width:120px}.cat-page .col-actions{width:220px}
.cat-page .btn.sm{padding:6px 10px;font-size:14px}
</style>

<div class="cat-page">
  <!-- إنشاء فئة -->
  <div class="card" style="margin-bottom:16px;">
    <h2 style="margin-bottom:10px;">إضافة فئة</h2>
    <?php if ($msg): ?><div class="alert" style="border-color:#22c55e;"><?= e($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>

    <form method="post" class="form" style="display:flex;gap:10px;flex-wrap:wrap;align-items:flex-end;">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="create">
      <div class="input" style="min-width:220px;flex:1;">
        <label>الاسم (عربي)</label>
        <input name="name_ar" placeholder="مثال: يوميات">
      </div>
      <div class="input" style="min-width:220px;flex:1;">
        <label>الاسم (إنجليزي)</label>
        <input name="name_en" placeholder="Daily">
      </div>
      <div class="input" style="width:140px;">
        <label>الترتيب</label>
        <input type="number" name="sort_order" min="1" value="">
      </div>
      <button class="btn sm" type="submit">إضافة</button>

      <div class="input" style="margin-inline-start:auto;min-width:260px;">
        <label>بحث بالاسم</label>
        <form method="get" style="display:flex;gap:8px;">
          <input type="text" name="q" value="<?= e($q) ?>" placeholder="ابحث في الفئات">
        </form>
      </div>
    </form>
  </div>

  <!-- الجدول -->
  <div class="card">
    <div class="table-wrap">
      <table class="table">
        <colgroup>
          <col class="col-id"><col class="col-ar"><col class="col-en"><col class="col-sort"><col class="col-actions">
        </colgroup>
        <thead>
          <tr>
            <th class="td-center">#</th>
            <th>الاسم (عربي)</th>
            <th>الاسم (إنجليزي)</th>
            <th>الترتيب</th>
            <th>إجراءات</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $r): ?>
            <tr>
              <td class="td-center"><?= (int)$r['id'] ?></td>
              <td>
                <form method="post" style="display:flex;gap:8px;align-items:center;">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="action" value="update">
                  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                  <input name="name_ar" value="<?= e($r['name_ar'] ?? '') ?>" style="width:100%;padding:6px 8px;border-radius:10px;border:1px solid var(--border);background:#0b1220;color:var(--text);">
              </td>
              <td>
                  <input name="name_en" value="<?= e($r['name_en'] ?? '') ?>" style="width:100%;padding:6px 8px;border-radius:10px;border:1px solid var(--border);background:#0b1220;color:var(--text);">
              </td>
              <td>
                  <input type="number" name="sort_order" min="1" value="<?= (int)$r['sort_order'] ?>" style="width:100%;padding:6px 8px;border-radius:10px;border:1px solid var(--border);background:#0b1220;color:var(--text);">
              </td>
              <td style="display:flex;gap:8px;align-items:center;flex-wrap:wrap;">
                  <button class="btn sm" type="submit">حفظ</button>
                </form>

                <form method="post" onsubmit="return confirm('حذف هذه الفئة؟');" style="display:inline;">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="action" value="delete">
                  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                  <button class="btn sm" type="submit" style="background:var(--danger);">حذف</button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if (!$rows): ?>
            <tr><td colspan="5" style="text-align:center;opacity:.7;">لا توجد بيانات</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <?php if ($pages > 1): ?>
      <div style="display:flex;gap:8px;margin-top:12px;flex-wrap:wrap;">
        <?php for($p=1;$p<=$pages;$p++):
          $url = 'moment_categories.php?page='.$p.($q!==''?'&q='.urlencode($q):'');
          $is = $p===$page; ?>
          <a class="btn sm <?= $is?'':'secondary' ?>" href="<?= e($url) ?>"<?= $is?' style="pointer-events:none;opacity:.8;"':''; ?>><?= $p ?></a>
        <?php endfor; ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<?php require __DIR__ . '/inc/footer.php'; ?>
