<?php
// admin/comments_edit.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }
if (!function_exists('e')) { function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }

$pdo = db();
$id  = (int)($_GET['id'] ?? 0);
if ($id <= 0) redirect('comments.php');

$msg=null; $err=null;

/* جلب التعليق */
$st = $pdo->prepare("SELECT * FROM `moment_comments` WHERE `id`=? LIMIT 1");
$st->execute([$id]);
$cmt = $st->fetch();
if (!$cmt) redirect('comments.php');

/* حفظ */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.';
  } else {
    // ملاحظة: عمود النص اسمه text
    $content = trim($_POST['text'] ?? '');
    $post_id = (int)($_POST['post_id'] ?? 0);
    $user_id = (int)($_POST['user_id'] ?? 0);

    try {
      $sql = "UPDATE `moment_comments` SET `text`=?, `post_id`=?, `user_id`=? WHERE `id`=? LIMIT 1";
      $pdo->prepare($sql)->execute([$content,$post_id,$user_id,$id]);

      $msg = 'تم الحفظ بنجاح.';
      $st = $pdo->prepare("SELECT * FROM `moment_comments` WHERE `id`=? LIMIT 1");
      $st->execute([$id]);
      $cmt = $st->fetch();
    } catch (Throwable $e) {
      $err = 'حدث خطأ أثناء الحفظ.';
    }
  }
}

$PAGE_TITLE = "تعديل تعليق #{$id}";
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';
?>
  <div class="card" style="max-width:900px;">
    <h1>تعديل تعليق #<?= (int)$cmt['id'] ?></h1>
    <?php if ($msg): ?><div class="alert" style="border-color:#22c55e;"><?= e($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>

    <form class="form" method="post">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">

      <div class="grid cols-2">
        <div class="input" style="grid-column:1 / -1;">
          <label>نص التعليق</label>
          <input name="text" value="<?= e($cmt['text'] ?? '') ?>" required>
        </div>
        <div class="input">
          <label>ID المنشور (post_id)</label>
          <input type="number" name="post_id" min="1" value="<?= (int)($cmt['post_id'] ?? 0) ?>">
        </div>
        <div class="input">
          <label>ID المستخدم (user_id)</label>
          <input type="number" name="user_id" min="1" value="<?= (int)($cmt['user_id'] ?? 0) ?>">
        </div>
      </div>

      <div style="display:flex; gap:8px; margin-top:8px;">
        <button class="btn" type="submit">حفظ</button>
        <a class="btn secondary" href="comments.php">رجوع للقائمة</a>
      </div>
    </form>
  </div>
<?php require __DIR__ . '/inc/footer.php'; ?>
