<?php
// admin/agents_edit.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }
if (!function_exists('e')) { function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES|ENT_SUBSTITUTE, 'UTF-8'); } }
function fmt_date(?string $s): string {
  if (!$s) return '';
  $t = strtotime($s); if ($t<=0) return e($s);
  return date('Y-m-d H:i', $t);
}
function fmt_ip(?string $bin): string {
  if ($bin===null || $bin==='') return '';
  $ip = @inet_ntop($bin);
  return $ip ?: '';
}

$pdo = db();
$id  = (int)($_GET['id'] ?? 0);
$row = ['id'=>0,'username'=>'','display_name'=>'','status'=>'active','created_at'=>null,'last_login_at'=>null,'last_login_ip'=>null];

if ($id>0) {
  $st=$pdo->prepare("SELECT * FROM agents WHERE id=? LIMIT 1");
  $st->execute([$id]);
  $row = $st->fetch() ?: $row;
}

$msg=null; $err=null;

if ($_SERVER['REQUEST_METHOD']==='POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) { $err='رمز الأمان غير صالح.'; }
  else {
    $username = trim((string)($_POST['username'] ?? ''));
    $display  = trim((string)($_POST['display_name'] ?? ''));
    $status   = in_array(($_POST['status'] ?? 'active'), ['active','suspended'], true) ? $_POST['status'] : 'active';
    $pass     = (string)($_POST['password'] ?? '');

    if ($username==='' || $display==='') $err='الرجاء إدخال اسم المستخدم والاسم الظاهر.';
    else {
      try {
        if ($id>0) {
          if ($pass!=='') {
            $st=$pdo->prepare("UPDATE agents SET username=?, display_name=?, status=?, password_hash=? WHERE id=? LIMIT 1");
            $st->execute([$username, $display, $status, password_hash($pass, PASSWORD_DEFAULT), $id]);
          } else {
            $st=$pdo->prepare("UPDATE agents SET username=?, display_name=?, status=? WHERE id=? LIMIT 1");
            $st->execute([$username, $display, $status, $id]);
          }
        } else {
          if ($pass==='') $err='كلمة المرور مطلوبة عند إنشاء وكيل جديد.';
          else {
            $st=$pdo->prepare("INSERT INTO agents (username, display_name, status, password_hash) VALUES (?,?,?,?)");
            $st->execute([$username, $display, $status, password_hash($pass, PASSWORD_DEFAULT)]);
            $id = (int)$pdo->lastInsertId();
          }
        }
        if (!$err) {
          $msg='تم الحفظ بنجاح.';
          // إعادة تحميل السطر بعد التعديلات
          $st=$pdo->prepare("SELECT * FROM agents WHERE id=? LIMIT 1");
          $st->execute([$id]);
          $row = $st->fetch() ?: $row;
        }
      } catch (Throwable $e) {
        $err='خطأ بقاعدة البيانات (قد يكون الاسم مستخدمًا).';
      }
    }
  }
}

$PAGE_TITLE = $row['id']? ('تعديل وكيل #'.(int)$row['id']) : 'إضافة وكيل';
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';
?>
<style>
.agent-edit .grid{display:grid;grid-template-columns: 1fr 1fr; gap:16px}
@media (max-width: 900px){ .agent-edit .grid{grid-template-columns: 1fr} }
.agent-edit .info{font-size:13px;opacity:.9}
</style>

<div class="agent-edit">
  <div class="card" style="margin-bottom:16px;">
    <?php if ($msg): ?><div class="alert" style="border-color:#22c55e;"><?= e($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>

    <form method="post" class="form">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">

      <div class="grid">
        <div class="input">
          <label>اسم المستخدم</label>
          <input name="username" value="<?= e($row['username']) ?>" required>
        </div>

        <div class="input">
          <label>الاسم الظاهر</label>
          <input name="display_name" value="<?= e($row['display_name']) ?>" required>
        </div>

        <div class="input">
          <label>الحالة</label>
          <select name="status">
            <option value="active"   <?= $row['status']==='active'?'selected':'' ?>>نشط</option>
            <option value="suspended"<?= $row['status']==='suspended'?'selected':'' ?>>موقوف</option>
          </select>
        </div>

        <div class="input">
          <label>كلمة المرور <?= $row['id']? '(أتركها فارغة للإبقاء عليها)':'' ?></label>
          <input name="password" type="password" <?= $row['id']? '' : 'required' ?>>
        </div>
      </div>

      <div style="margin-top:12px; display:flex; gap:8px; align-items:center;">
        <button class="btn" type="submit">حفظ</button>
        <a class="btn secondary" href="agents.php">رجوع</a>
      </div>
    </form>
  </div>

  <?php if ($row['id']): ?>
    <div class="card">
      <div class="info">
        <div>أُنشيء: <b><?= fmt_date($row['created_at'] ?? '') ?></b></div>
        <div>آخر دخول: <b><?= fmt_date($row['last_login_at'] ?? '') ?></b></div>
        <?php $ip = fmt_ip($row['last_login_ip'] ?? null); if ($ip): ?>
          <div>IP آخر دخول: <span style="font-family:monospace;"><?= e($ip) ?></span></div>
        <?php endif; ?>
        <div>الرصيد الحالي: <b><?= (int)$row['main_balance'] ?></b> كوين</div>
        <div style="margin-top:8px;">
          <a class="btn sm" href="agents_credit.php?id=<?= (int)$row['id'] ?>">شحن/خصم لهذا الوكيل</a>
        </div>
      </div>
    </div>
  <?php endif; ?>
</div>

<?php require __DIR__ . '/inc/footer.php'; ?>
