<?php
declare(strict_types=1);

require __DIR__ . '/../config.php';
require_once __DIR__ . '/../vendor/autoload.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Authorization, Content-Type');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }

function json_fail($e,$c=400){ http_response_code($c); echo json_encode(['ok'=>false,'error'=>$e], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }
function json_ok($d=[]){ echo json_encode(['ok'=>true] + $d, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }
function bearer(): ?string {
  $h = $_SERVER['HTTP_AUTHORIZATION'] ?? $_SERVER['Authorization'] ?? $_SERVER['REDIRECT_HTTP_AUTHORIZATION'] ?? '';
  if (!$h && function_exists('getallheaders')) {
    foreach (getallheaders() as $k => $v) { if (strcasecmp($k,'Authorization')===0){ $h=$v; break; } }
  }
  return stripos($h, 'Bearer ') === 0 ? trim(substr($h, 7)) : null;
}
function input_all(): array {
  $ct = $_SERVER['CONTENT_TYPE'] ?? $_SERVER['HTTP_CONTENT_TYPE'] ?? '';
  if (stripos($ct,'application/json')!==false) {
    $raw = file_get_contents('php://input') ?: '';
    $j = json_decode($raw, true);
    if (is_array($j)) return $j + $_POST + $_GET;
  }
  return $_POST + $_GET;
}
function auth_user_id(PDO $pdo, object $payload): int {
  $id = 0;
  foreach (['id','user_id','uid'] as $k) {
    if (isset($payload->$k) && is_numeric($payload->$k)) { $id = (int)$payload->$k; break; }
  }
  if ($id > 0) return $id;
  $fuid = (string)($payload->firebase_uid ?? '');
  if ($fuid !== '') {
    $st = $pdo->prepare("SELECT id FROM users WHERE uid = ? LIMIT 1");
    $st->execute([$fuid]);
    $id = (int)$st->fetchColumn();
  }
  return $id;
}

$jwt = bearer(); if (!$jwt) json_fail('missing authorization bearer token', 401);
try {
  $payload = JWT::decode($jwt, new Key($JWT_SECRET, 'HS256'));
} catch (Throwable $e) {
  json_fail('invalid token: '.$e->getMessage(), 401);
}

$pdo = db();
$uid = auth_user_id($pdo, $payload);
if ($uid <= 0) json_fail('user_not_found', 401);

$in       = input_all();
$threadId = (int)($in['thread_id'] ?? 0);
$afterId  = (int)($in['after_id'] ?? 0);
$limit    = max(1, min(500, (int)($in['limit'] ?? 200)));

// ✅ شات واحد لكل مستخدم: استخرج محادثته أو أنشئ واحدة إذا لا توجد
if ($threadId <= 0) {
  $st = $pdo->prepare("SELECT id, subject, status, updated_at FROM support_threads WHERE user_id=? ORDER BY updated_at DESC, id DESC LIMIT 1");
  $st->execute([$uid]);
  $row = $st->fetch(PDO::FETCH_ASSOC);
  if ($row) {
    $threadId = (int)$row['id'];
    $thread = $row;
  } else {
    $pdo->prepare("INSERT INTO support_threads (user_id, subject, status, created_at, updated_at) VALUES (?, 'محادثة دعم', 'open', NOW(), NOW())")
        ->execute([$uid]);
    $threadId = (int)$pdo->lastInsertId();
    $thread = ['id'=>$threadId,'subject'=>'محادثة دعم','status'=>'open','updated_at'=>date('Y-m-d H:i:s')];
  }
} else {
  // أمان: تأكد أنها للمستخدم نفسه
  $st = $pdo->prepare("SELECT id, subject, status, updated_at FROM support_threads WHERE id=? AND user_id=? LIMIT 1");
  $st->execute([$threadId, $uid]);
  $thread = $st->fetch(PDO::FETCH_ASSOC);
  if (!$thread) json_fail('thread_not_found', 404);
}

// جلب الرسائل
if ($afterId > 0) {
  $st = $pdo->prepare("SELECT id, thread_id, sender_type, user_id, staff_name, message_text, attachment_url, created_at FROM support_messages WHERE thread_id=? AND id>? ORDER BY id ASC LIMIT $limit");
  $st->execute([$threadId, $afterId]);
} else {
  $st = $pdo->prepare("SELECT id, thread_id, sender_type, user_id, staff_name, message_text, attachment_url, created_at FROM support_messages WHERE thread_id=? ORDER BY id ASC LIMIT $limit");
  $st->execute([$threadId]);
}
$messages = $st->fetchAll(PDO::FETCH_ASSOC);

// علّم رسائل الطاقم كمقروءة لدى المستخدم
$pdo->prepare("UPDATE support_messages SET read_by_user=1 WHERE thread_id=? AND sender_type='staff' AND read_by_user=0")
    ->execute([$threadId]);

json_ok([
  'thread_id' => $threadId,
  'thread'    => [
    'id'      => (int)$thread['id'],
    'subject' => (string)($thread['subject'] ?? 'محادثة دعم'),
    'status'  => (string)($thread['status'] ?? 'open'),
    'updated_at' => (string)($thread['updated_at'] ?? ''),
  ],
  'messages'  => $messages,
]);
