<?php
// voicechat/api/rooms_update.php
require __DIR__ . '/config.php'; // يتكفّل بـ CORS + json_out() + db() + require_user()

/* ========== أدوات مساعدة ========== */
function logx($m){ @file_put_contents(__DIR__.'/rooms_update.log','['.date('Y-m-d H:i:s').'] '.$m."\n",FILE_APPEND); }

function table_exists(PDO $pdo, string $name): bool {
  $st = $pdo->prepare("SHOW TABLES LIKE ?"); $st->execute([$name]);
  return (bool)$st->fetchColumn();
}
function col_exists(PDO $pdo, string $table, string $col): bool {
  $st = $pdo->prepare("SHOW COLUMNS FROM `$table` LIKE ?"); $st->execute([$col]);
  return (bool)$st->fetchColumn();
}
function get_user_uid(PDO $pdo, int $userId): ?string {
  $st = $pdo->prepare("SELECT uid FROM users WHERE id=? LIMIT 1");
  $st->execute([$userId]);
  $u = $st->fetchColumn();
  return $u ? (string)$u : null;
}

/** تحقّق إن كان المستخدم مالكًا أو أدمنًا (تدعم owner_uid/owner_user_id وأي تركيبة في room_admins) */
function can_edit_room(PDO $pdo, array $room, int $userId): bool {
  // 1) مالك بالغرفة؟
  // أ) لو عندك owner_user_id
  if (isset($room['owner_user_id']) && (int)$room['owner_user_id'] === $userId) {
    return true;
  }
  // ب) لو عندك owner_uid نقارن بـ uid الخاص بالمستخدم
  if (isset($room['owner_uid']) && $room['owner_uid'] !== null && $room['owner_uid'] !== '') {
    $myUid = get_user_uid($pdo, $userId);
    if ($myUid && $room['owner_uid'] === $myUid) return true;
  }

  // 2) أدمن؟ (جدول room_admins اختياري)
  if (!table_exists($pdo, 'room_admins')) return false;

  $hasRoomId   = col_exists($pdo, 'room_admins', 'room_id');
  $hasRoomUid  = col_exists($pdo, 'room_admins', 'room_uid');
  $hasUserId   = col_exists($pdo, 'room_admins', 'user_id');
  $hasUserUid  = col_exists($pdo, 'room_admins', 'user_uid');

  if (!$hasRoomId && !$hasRoomUid)  return false; // لا نعرف نربط الغرفة
  if (!$hasUserId && !$hasUserUid)  return false; // لا نعرف نربط المستخدم

  $ok = false;

  // نبني كل التركيبات الممكنة بدون استعلام على عمود غير موجود
  $roomKeys = [];
  if ($hasRoomId   && isset($room['id']))   $roomKeys[]  = ['col'=>'room_id',  'val'=>(int)$room['id']];
  if ($hasRoomUid  && isset($room['uid']))  $roomKeys[]  = ['col'=>'room_uid', 'val'=>$room['uid']];

  $userKeys = [];
  if ($hasUserId)  $userKeys[] = ['col'=>'user_id',  'val'=>$userId];
  if ($hasUserUid){ $myUid = get_user_uid($pdo, $userId); if ($myUid) $userKeys[] = ['col'=>'user_uid','val'=>$myUid]; }

  foreach ($roomKeys as $rk) {
    foreach ($userKeys as $uk) {
      $sql = "SELECT 1 FROM room_admins WHERE `{$rk['col']}`=? AND `{$uk['col']}`=? LIMIT 1";
      $st  = $pdo->prepare($sql);
      $st->execute([$rk['val'], $uk['val']]);
      if ($st->fetchColumn()) { $ok = true; break 2; }
    }
  }
  return $ok;
}

/* ========== المعالجة الرئيسية ========== */
try {
  // 1) توثيق إلزامي: يرجع users.id
  $userId = require_user();
  $pdo    = db();

  // 2) دمج JSON مع POST لراحة الاستهلاك
  $raw = file_get_contents('php://input');
  if ($raw) {
    $j = json_decode($raw, true);
    if (is_array($j)) foreach ($j as $k=>$v) if (!isset($_POST[$k])) $_POST[$k] = $v;
  }
  if (isset($_GET['ping'])) { json_out(['ok'=>true]); }

  // 3) فحص جدول rooms
  $table = 'rooms';
  if (!table_exists($pdo, $table)) {
    json_out(['ok'=>false,'error'=>'server_error','msg'=>"table `$table` not found"], 500);
  }

  // 4) قراءة المعطيات
  $id        = (int)($_POST['id'] ?? $_POST['room_id'] ?? 0);
  $uidText   = trim((string)($_POST['uid'] ?? $_POST['room_uid'] ?? $_POST['roomUid'] ?? ''));

  $title       = trim((string)($_POST['title'] ?? $_POST['name'] ?? $_POST['room_name'] ?? ''));
  $description = trim((string)($_POST['description'] ?? $_POST['desc'] ?? ''));
  $imageUrl    = trim((string)($_POST['image_url'] ?? $_POST['cover_url'] ?? $_POST['imageUrl'] ?? ''));
  $background  = trim((string)($_POST['background_url'] ?? ''));
  $maxSeatsReq = isset($_POST['max_seats']) ? (int)$_POST['max_seats'] : null;

  if ($id === 0 && $uidText === '') {
    json_out(['ok'=>false,'error'=>'missing_id_or_uid'], 400);
  }

  // 5) اكتشاف الأعمدة الموجودة في rooms
  $hasUid     = col_exists($pdo,$table,'uid');
  $hasOwnerId = col_exists($pdo,$table,'owner_user_id');
  $hasOwnerUid= col_exists($pdo,$table,'owner_uid');

  $hasTitle   = col_exists($pdo,$table,'title');
  $hasName    = col_exists($pdo,$table,'name');
  $colTitle   = $hasTitle ? 'title' : ($hasName ? 'name' : null);

  $colDesc    = col_exists($pdo,$table,'description') ? 'description' : null;

  $hasCover   = col_exists($pdo,$table,'cover_url');
  $hasImage   = col_exists($pdo,$table,'image_url');
  $colImage   = $hasCover ? 'cover_url' : ($hasImage ? 'image_url' : null);

  $colBg      = col_exists($pdo,$table,'background_url') ? 'background_url' : null;
  $colMax     = col_exists($pdo,$table,'max_users') ? 'max_users' : (col_exists($pdo,$table,'max_seats') ? 'max_seats' : null);

  $hasAgora   = col_exists($pdo,$table,'agora_channel');
  $hasStatus  = col_exists($pdo,$table,'status');

  // WHERE
  if ($id > 0) { $where = 'id=?';  $whereVal = [$id]; }
  else {
    if (!$hasUid) json_out(['ok'=>false,'error'=>'uid_column_missing'], 400);
    $where = 'uid=?'; $whereVal = [$uidText];
  }

  // 6) اقرأ الغرفة أولًا للتحقق من الصلاحيات
  $selBase = [
    'id',
    $hasUid ? 'uid' : "'' AS uid",
    $hasOwnerId ? 'owner_user_id' : 'NULL AS owner_user_id',
    $hasOwnerUid? 'owner_uid' : "NULL AS owner_uid",
    $hasTitle ? 'title' : ($hasName ? 'name AS title' : "'' AS title"),
    $hasName  ? 'name'  : ($hasTitle ? 'title AS name' : "'' AS name"),
    $colDesc ? 'description' : "'' AS description",
    $hasCover ? 'cover_url' : ($hasImage ? 'image_url AS cover_url' : 'NULL AS cover_url'),
    $hasImage ? 'image_url' : ($hasCover ? 'cover_url AS image_url' : 'NULL AS image_url'),
    $colBg ? "$colBg AS background_url" : 'NULL AS background_url',
    $hasAgora ? 'agora_channel' : 'NULL AS agora_channel',
    $hasStatus? 'status' : 'NULL AS status',
    $colMax ? "$colMax AS max_users" : 'NULL AS max_users',
  ];
  $q = $pdo->prepare("SELECT ".implode(',', $selBase)." FROM `$table` WHERE $where LIMIT 1");
  $q->execute($whereVal);
  $room = $q->fetch(PDO::FETCH_ASSOC);
  if (!$room) json_out(['ok'=>false,'error'=>'room_not_found'], 404);

  // صلاحيات التعديل (مالك/أدمن)
  if (!can_edit_room($pdo, $room, $userId)) {
    json_out(['ok'=>false,'error'=>'forbidden'], 403);
  }

  // 7) لا تعديلات؟ أعِد الغرفة كما هي
  $noUpdates =
    ($title === '') &&
    ($description === '') &&
    ($imageUrl === '') &&
    ($background === '') &&
    ($maxSeatsReq === null);

  if ($noUpdates) {
    json_out(['ok'=>true,'room'=>$room]);
  }

  // 8) UPDATE
  $sets = []; $vals = [];

  if ($title !== '') {
    if ($hasTitle) { $sets[] = "`title`=?"; $vals[] = $title; }
    if ($hasName)  { $sets[] = "`name`=?";  $vals[] = $title; }
    if (!$hasTitle && !$hasName && $colTitle) { $sets[] = "`$colTitle`=?"; $vals[] = $title; }
  }

  if ($description !== '' && $colDesc) { $sets[] = "`$colDesc`=?"; $vals[] = $description; }

  if ($imageUrl !== '') {
    if ($hasCover) { $sets[] = "`cover_url`=?"; $vals[] = $imageUrl; }
    if ($hasImage) { $sets[] = "`image_url`=?"; $vals[] = $imageUrl; }
    if (!$hasCover && !$hasImage && $colImage) { $sets[] = "`$colImage`=?"; $vals[] = $imageUrl; }
  }

  if ($background !== '' && $colBg) { $sets[] = "`$colBg`=?"; $vals[] = $background; }

  if ($maxSeatsReq !== null && $colMax) {
    $maxSeats = max(1, min(64, (int)$maxSeatsReq)); // حدود منطقية
    $sets[] = "`$colMax`=?"; $vals[] = $maxSeats;
  }

  if ($sets) {
    $sql = "UPDATE `$table` SET ".implode(', ', $sets)." WHERE $where LIMIT 1";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(array_merge($vals, $whereVal));
  }

  // 9) رجّع الغرفة بعد التحديث
  $q = $pdo->prepare("SELECT ".implode(',', $selBase)." FROM `$table` WHERE $where LIMIT 1");
  $q->execute($whereVal);
  $room = $q->fetch(PDO::FETCH_ASSOC);

  json_out(['ok'=>true,'room'=>$room]);

} catch (Throwable $e) {
  logx('ERR: '.$e->getMessage());
  json_out(['ok'=>false,'error'=>'server_error','msg'=>$e->getMessage()], 500);
}
