<?php
// backend/api/rooms_list.php
declare(strict_types=1);

require __DIR__ . '/config.php';

// ===== CORS & JSON =====
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Authorization, Content-Type');
header('Access-Control-Allow-Methods: GET, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

// ===== Helpers =====
function json_fail($err, $code = 400) {
  http_response_code($code);
  echo json_encode(['ok'=>false, 'error'=>$err], JSON_UNESCAPED_UNICODE);
  exit;
}
function json_ok($data = []) {
  echo json_encode(['ok'=>true] + $data, JSON_UNESCAPED_UNICODE);
  exit;
}

try {
  $pdo = db();

  // نرجع الغرف المفتوحة فقط، مع description و image_url (بدون NULL)
  $sql = "
    SELECT
      uid,
      owner_uid,
      name,
      COALESCE(image_url, '')      AS image_url,
      COALESCE(description, '')    AS description,
      agora_channel,
      status,
      max_seats,
      created_at
    FROM rooms
    WHERE status = 'open'
    ORDER BY id DESC
    LIMIT 100
  ";
  $stmt  = $pdo->query($sql);
  $rooms = $stmt->fetchAll(PDO::FETCH_ASSOC);

  json_ok(['rooms' => $rooms]);
} catch (Throwable $e) {
  json_fail('db_error: '.$e->getMessage(), 500);
}
