<?php
// voicechat/api/room_lock.php
declare(strict_types=1);
require __DIR__.'/config.php';

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Authorization, Content-Type');
header('Access-Control-Allow-Methods: POST, OPTIONS');
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }

function ok($d = []) { echo json_encode(['ok'=>true] + $d, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }
function bad($m, $code=400){ http_response_code($code); echo json_encode(['ok'=>false,'error'=>$m], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  $auth = function_exists('require_auth') ? require_auth() : null;
  if (!$auth) bad('Unauthorized', 401);
  $user_uid = (string)($auth['uid'] ?? '');

  $raw = file_get_contents('php://input');
  $data = json_decode($raw, true);
  if (!is_array($data) || $data === []) {
    // fallback لو بترسل form-data
    $data = $_POST;
  }

  $room_uid = trim((string)($data['room_uid'] ?? ''));
  $enable   = $data['enable'] ?? null;
  $pin      = isset($data['pin']) ? trim((string)$data['pin']) : null;

  if ($room_uid === '') bad('room_uid required');
  if (!is_bool($enable)) {
    // نقبل "true"/"false" أو 0/1
    if ($enable === 'true' || $enable === '1' || $enable === 1) $enable = true;
    elseif ($enable === 'false' || $enable === '0' || $enable === 0) $enable = false;
    else bad('enable must be boolean true/false');
  }

  if ($enable) {
    if ($pin === null || !preg_match('/^\d{4}$/', $pin)) bad('pin must be 4 digits');
  }

  $pdo = db();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->beginTransaction();

  // تأكيد الملكية
  $st = $pdo->prepare("SELECT id, owner_uid FROM rooms WHERE uid = ? LIMIT 1");
  $st->execute([$room_uid]);
  $room = $st->fetch(PDO::FETCH_ASSOC);
  if (!$room) { $pdo->rollBack(); bad('Room not found', 404); }
  if ((string)$room['owner_uid'] !== $user_uid) { $pdo->rollBack(); bad('Forbidden', 403); }

  if ($enable) {
    $hash = password_hash($pin, PASSWORD_DEFAULT);
    $st = $pdo->prepare("UPDATE rooms SET lock_enabled = 1, lock_pin_hash = ? WHERE uid = ?");
    $st->execute([$hash, $room_uid]);
  } else {
    $st = $pdo->prepare("UPDATE rooms SET lock_enabled = 0, lock_pin_hash = NULL WHERE uid = ?");
    $st->execute([$room_uid]);
  }

  $pdo->commit();
  ok(['enabled' => (bool)$enable]);
} catch (Throwable $e) {
  error_log('[room_lock] '.$e->getMessage());
  bad('Internal error', 500); // يرجّع 500 لكن برسالة JSON واضحة
}
