<?php
// backend/api/room_create.php
require __DIR__ . '/config.php';

header('Content-Type: application/json; charset=utf-8');

$auth = require_auth();
$uid  = $auth['uid'] ?? null;

// === اقرأ المدخلات: JSON أو POST ===
$raw   = file_get_contents('php://input');
$input = json_decode($raw, true);
if (!is_array($input)) {
  // fallback إلى POST (عند الإرسال بصيغة x-www-form-urlencoded من Flutter)
  $input = $_POST ?? [];
}

// حقول الطلب
$name        = trim($input['name'] ?? $input['title'] ?? '');
$image_url   = trim($input['image_url'] ?? $input['cover_url'] ?? '');
$description = trim($input['description'] ?? $input['desc'] ?? '');  // <-- مهم
$max_seats   = (int)($input['max_seats'] ?? 8);

// ضبط الحدود
if ($max_seats < 2 || $max_seats > 16) $max_seats = 8;

// تحقق من الاسم
if ($name === '') {
  json_out(['error' => 'missing_name'], 422);
}

// حسب طلبك: نجعل UID الغرفة = UID المستخدم المنشئ
$room_uid = $uid;

// إذا كانت الغرفة موجودة ومفتوحة بالفعل، أعدها (بما في ذلك الوصف)
$stmt = db()->prepare("
  SELECT uid, owner_uid, name, description, image_url, agora_channel, status, max_seats
  FROM rooms
  WHERE uid=? AND status='open'
  LIMIT 1
");
$stmt->execute([$room_uid]);
$exists = $stmt->fetch();
if ($exists) {
  json_out(['ok' => true, 'room' => $exists]);
}

// أنشئ قناة أجورا (يمكن تغيير المنطق لاحقًا)
$agora_channel = $room_uid;

// إدراج مع الوصف
$stmt = db()->prepare("
  INSERT INTO rooms (uid, owner_uid, name, description, image_url, agora_channel, max_seats)
  VALUES (?,?,?,?,?,?,?)
");
$stmt->execute([
  $room_uid,
  $uid,
  $name,
  ($description !== '' ? $description : null),
  ($image_url !== '' ? $image_url : null),
  $agora_channel,
  $max_seats
]);

// أعِد بيانات الغرفة المُنشأة
json_out([
  'ok'   => true,
  'room' => [
    'uid'           => $room_uid,
    'owner_uid'     => $uid,
    'name'          => $name,
    'description'   => ($description !== '' ? $description : null),
    'image_url'     => ($image_url !== '' ? $image_url : null),
    'agora_channel' => $agora_channel,
    'status'        => 'open',
    'max_seats'     => $max_seats,
  ],
]);
