<?php
// voicechat/api/room_backgrounds_list.php
require __DIR__ . '/config.php';
header('Content-Type: application/json; charset=utf-8');

$dir = __DIR__ . '/files/room/background';
$base = 'https://battle-party.com/voicechat/api/files/room/background';
$allowed = ['jpg','jpeg','png','webp']; // استبعدنا avif إلا إذا تستخدم مكتبة له

$files = [];
foreach ($allowed as $ext) {
  foreach (glob($dir . '/*.' . $ext) as $p) {
    $files[] = basename($p);
  }
}

// رتّب طبيعيًا (1,2,3..10)
natsort($files);
$files = array_values($files);

// لو حاب ترجع روابط كاملة:
$urls = array_map(fn($f) => "$base/$f", $files);

echo json_encode(['ok'=>true, 'files'=>$files, 'urls'=>$urls], JSON_UNESCAPED_UNICODE);
