<?php
// voicechat/api/room_admins_add.php
declare(strict_types=1);
require_once __DIR__ . '/config.php';

if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') {
  json_out(['ok'=>false,'error'=>'method_not_allowed'], 405);
}

$pdo = db();
$me  = require_user();
$j   = json_in();

$roomUid   = trim((string)($j['room_uid'] ?? ''));
$targetUid = trim((string)($j['target_uid'] ?? ''));

if ($roomUid === '' || $targetUid === '') {
  json_out(['ok'=>false,'error'=>'missing_params'], 400);
}

$pdo->beginTransaction();
try {
  // تحقق أني المالك
  $st = $pdo->prepare("SELECT owner_uid FROM rooms WHERE uid=? LIMIT 1");
  $st->execute([$roomUid]);
  $row = $st->fetch(PDO::FETCH_ASSOC);
  if (!$row || $row['owner_uid'] !== $me) {
    $pdo->rollBack();
    json_out(['ok'=>false,'error'=>'forbidden'], 403);
  }

  // منع تعيين المالك نفسه أو تعيين تكراري
  if ($targetUid === $me) {
    $pdo->rollBack();
    json_out(['ok'=>false,'error'=>'owner_cannot_be_admin'], 400);
  }

  // حد أقصى 12 أدمن
  $count = (int)$pdo->query("SELECT COUNT(*) FROM room_admins WHERE room_uid=".$pdo->quote($roomUid))->fetchColumn();
  if ($count >= 12) {
    $pdo->rollBack();
    json_out(['ok'=>false,'error'=>'admins_limit_reached','limit'=>12], 400);
  }

  // إدراج
  $st = $pdo->prepare("INSERT IGNORE INTO room_admins (room_uid, admin_uid) VALUES (?, ?)");
  $st->execute([$roomUid, $targetUid]);

  $pdo->commit();
  json_out(['ok'=>true]);
} catch (Throwable $e) {
  $pdo->rollBack();
  json_out(['ok'=>false,'error'=>'server_error','details'=>$e->getMessage()], 500);
}
