<?php
// voicechat/api/notefirebase/fcm_register.php
declare(strict_types=1);

require __DIR__ . '/../config.php'; // config.php داخل voicechat/api

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Authorization, Content-Type');
header('Access-Control-Allow-Methods: POST, OPTIONS');

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }

function out($arr, int $code=200){ http_response_code($code); echo json_encode($arr, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

// مصادقة بالـ Bearer (نفس أسلوب مشروعك)
$auth = function_exists('require_auth') ? require_auth() : null;
if (!$auth || !($auth['uid'] ?? '')) out(['ok'=>false,'error'=>'unauthorized'], 401);
$user_uid = (string)$auth['uid'];

$raw = json_decode(file_get_contents('php://input'), true) ?: [];
$token    = trim((string)($raw['token']    ?? ''));
$platform = strtolower(trim((string)($raw['platform'] ?? 'android'))); // android | ios | web
$device   = trim((string)($raw['device_id']?? ''));
$app_ver  = trim((string)($raw['app_ver']  ?? ''));

if ($token === '') out(['ok'=>false,'error'=>'missing_token'], 400);
if (!in_array($platform, ['android','ios','web'], true)) $platform = 'android';

$pdo = db();

// تأكد أن fcm_tokens.token عليه UNIQUE
$st = $pdo->prepare("
  INSERT INTO fcm_tokens (user_uid, token, platform, device_id, app_ver)
  VALUES (?,?,?,?,?)
  ON DUPLICATE KEY UPDATE
    user_uid=VALUES(user_uid),
    platform=VALUES(platform),
    device_id=VALUES(device_id),
    app_ver=VALUES(app_ver),
    last_seen=CURRENT_TIMESTAMP
");
$st->execute([$user_uid, $token, $platform, $device, $app_ver]);

out(['ok'=>true, 'user_uid'=>$user_uid]);
