<?php
// voicechat/api/moment/report_post.php
declare(strict_types=1);
require __DIR__ . '/../config.php'; // يحمّل db(), json_in(), json_out(), require_user()

try {
  $uid = require_user(); // يتحقق من التوكن ويعيد id المستخدم

  $in = json_in();
  $post_id      = (int)($in['post_id'] ?? 0);
  $post_user_id = (int)($in['post_user_id'] ?? 0); // احتياطي من العميل
  $reason_code  = trim((string)($in['reason_code'] ?? ''));
  $reason_text  = trim((string)($in['reason_text'] ?? ''));
  $details      = trim((string)($in['details'] ?? ''));

  if ($post_id <= 0) json_out(['ok'=>false,'error'=>'missing_post_id'], 400);
  if ($reason_text === '') json_out(['ok'=>false,'error'=>'missing_reason'], 400);

  $pdo = db();

  // تأكيد مالك المنشور من قاعدة البيانات لتفادي التلاعب
  $st = $pdo->prepare("SELECT user_id FROM moment_posts WHERE id=? LIMIT 1");
  $st->execute([$post_id]);
  $row = $st->fetch();
  if (!$row) json_out(['ok'=>false,'error'=>'post_not_found'], 404);
  $owner_id_db = (int)$row['user_id'];
  if ($owner_id_db > 0) $post_user_id = $owner_id_db;

  // معلومات تقنية اختيارية
  $ip = $_SERVER['REMOTE_ADDR'] ?? '';
  $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';

  // ادراج — مع منع تكرار تبليغ نفس المستخدم على نفس المنشور
  $st = $pdo->prepare("INSERT INTO post_reports
      (post_id, post_user_id, reporter_user_id, reason_code, reason_text, details, ip, user_agent)
      VALUES (?,?,?,?,?,?,?,?)
      ON DUPLICATE KEY UPDATE
        reason_code=VALUES(reason_code),
        reason_text=VALUES(reason_text),
        details=VALUES(details),
        updated_at = CURRENT_TIMESTAMP");

  $st->execute([
    $post_id,
    $post_user_id,
    $uid,
    ($reason_code !== '' ? $reason_code : null),
    $reason_text,
    ($details !== '' ? $details : null),
    $ip,
    $ua,
  ]);

  json_out(['ok'=>true]);
} catch (Throwable $e) {
  json_out(['ok'=>false,'error'=>$e->getMessage()], 500);
}
