<?php
require_once __DIR__ . '/../config.php';

try {
  $pdo = db();

  // المستخدم الحالي (0 إذا لم يرسل Authorization)
  $uid = bearer_user_id();

  // معاملات التصفح والتصفية
  $category_id = (int)($_GET['category_id'] ?? 0);   // 0 = الكل
  $page        = max(1, (int)($_GET['page'] ?? 1));
  $perPage     = max(1, min(100, (int)($_GET['per_page'] ?? 20)));
  $offset      = ($page - 1) * $perPage;

  // تصفية التصنيف
  $where = [];
  $params = [];

  if ($category_id > 0) {
    $where[] = 'p.category_id = :cat';
    $params[':cat'] = $category_id;
  }

  $whereSql = '';
  if (!empty($where)) {
    $whereSql = 'WHERE ' . implode(' AND ', $where);
  }

  // liked_by_me: لو فيه uid نعمل LEFT JOIN على إعجاب المستخدم
  if ($uid > 0) {
    $likedJoin   = 'LEFT JOIN moment_post_likes me ON me.post_id = p.id AND me.user_id = :uid';
    $likedSelect = '(me.user_id IS NOT NULL) AS liked_by_me';
    $params[':uid'] = $uid;
  } else {
    $likedJoin   = '';
    $likedSelect = '0 AS liked_by_me';
  }

  // الاستعلام الرئيسي
  $sql = "
    SELECT
      p.id,
      p.user_id,
      p.category_id,
      p.content_text,
      p.image_url,
      p.created_at,
      u.username,
      COALESCE(u.avatar_url,'') AS avatar_url,
      (SELECT COUNT(*) FROM moment_post_likes l WHERE l.post_id = p.id) AS likes_count,
      (SELECT COUNT(*) FROM moment_comments   c WHERE c.post_id = p.id) AS comments_count,
      $likedSelect
    FROM moment_posts p
    JOIN users u ON u.id = p.user_id
    $likedJoin
    $whereSql
    ORDER BY p.id DESC
    LIMIT $perPage OFFSET $offset
  ";

  $st = $pdo->prepare($sql);
  $st->execute($params);
  $rows = $st->fetchAll();

  respond(['ok' => 1, 'posts' => $rows], 200);

} catch (Throwable $e) {
  respond(['ok' => 0, 'error' => $e->getMessage()], 500);
}
