<?php
require_once __DIR__ . '/../config.php';

try {
  // يتطلب JWT صالح (Authorization: Bearer <token> أو ?token= للاختبار)
  $uid = require_user();
  $pdo = db();

  // إدخال
  $category_id  = (int)($_POST['category_id'] ?? 0);
  $content_text = trim((string)($_POST['content_text'] ?? ''));

  if ($category_id <= 0) respond(['ok'=>0,'error'=>'category_required'], 422);
  if ($content_text === '' && empty($_FILES['image'])) {
    respond(['ok'=>0,'error'=>'empty_post'], 422);
  }

  // تأكيد وجود التصنيف
  $chk = $pdo->prepare('SELECT 1 FROM moment_categories WHERE id=?');
  $chk->execute([$category_id]);
  if (!$chk->fetch()) respond(['ok'=>0,'error'=>'category_not_found'], 422);

  // حفظ الصورة (اختياري)
  $image_url = null;
  if (!empty($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
    // مسارات رفع اللحظات من config.php
    global $FILES_MOMENT_BASE_DIR, $FILES_MOMENT_BASE_URL;

    // إنشاء المجلدات: /files/moment/YYYY/MM
    @mkdir($FILES_MOMENT_BASE_DIR, 0775, true);
    $ym  = date('Y/m');
    $dir = rtrim($FILES_MOMENT_BASE_DIR, '/')."/$ym";
    if (!is_dir($dir)) @mkdir($dir, 0775, true);
    if (!is_dir($dir) || !is_writable($dir)) {
      respond(['ok'=>0,'error'=>'upload_dir_not_writable'], 500);
    }

    // امتداد آمن
    $orig = $_FILES['image']['name'];
    $ext  = strtolower(pathinfo($orig, PATHINFO_EXTENSION) ?: 'jpg');
    // قيود بسيطة على الامتداد
    $allowed = ['jpg','jpeg','png','gif','webp'];
    if (!in_array($ext, $allowed, true)) $ext = 'jpg';

    $name = uniqid('p', true) . '.' . $ext;
    $dest = "$dir/$name";

    if (!move_uploaded_file($_FILES['image']['tmp_name'], $dest)) {
      respond(['ok'=>0,'error'=>'upload_failed'], 500);
    }

    $image_url = rtrim($FILES_MOMENT_BASE_URL, '/')."/$ym/$name";
  }

  // إنشاء المنشور
  $st = $pdo->prepare(
    'INSERT INTO moment_posts (user_id, category_id, content_text, image_url) VALUES (?,?,?,?)'
  );
  $st->execute([$uid, $category_id, $content_text, $image_url]);
  $id = (int)$pdo->lastInsertId();

  // جلب المنشور للرد مع الحقول المحسوبة
  $p = $pdo->prepare(
    'SELECT
       p.id, p.user_id, p.category_id, p.content_text, p.image_url, p.created_at,
       u.username, COALESCE(u.avatar_url,"") AS avatar_url,
       (SELECT COUNT(*) FROM moment_post_likes l WHERE l.post_id=p.id) AS likes_count,
       (SELECT COUNT(*) FROM moment_comments   c WHERE c.post_id=p.id) AS comments_count,
       (SELECT COUNT(*) FROM moment_post_likes l2 WHERE l2.post_id=p.id AND l2.user_id=?) > 0 AS liked_by_me
     FROM moment_posts p
     JOIN users u ON u.id = p.user_id
     WHERE p.id=?'
  );
  $p->execute([$uid, $id]);
  $post = $p->fetch();

  respond(['ok'=>1,'post'=>$post], 200);

} catch (Throwable $e) {
  respond(['ok'=>0,'error'=>$e->getMessage()], 500);
}
