<?php
require_once __DIR__ . '/../config.php';

try {
  $pdo = db();

  // يمكنك فرض اللغة عبر ?lang=ar|en، وإلا نستنتج من Accept-Language
  $forceLang = strtolower(trim((string)($_GET['lang'] ?? '')));
  if ($forceLang === 'ar') {
    $isAr = true;
  } elseif ($forceLang === 'en') {
    $isAr = false;
  } else {
    $al   = strtolower($_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? '');
    $isAr = (substr($al, 0, 2) === 'ar');
  }

  $primary   = $isAr ? 'name_ar' : 'name_ar';
  $secondary = $isAr ? 'name_en' : 'name_ar';

  $sql = "
    SELECT
      id,
      COALESCE(NULLIF($primary, ''), NULLIF($secondary, ''), CONCAT('cat-', id)) AS name,
      COALESCE(name_ar,'') AS name_ar,
      COALESCE(name_en,'') AS name_en,
      COALESCE(sort_order,0) AS sort_order
    FROM moment_categories
    ORDER BY sort_order ASC, id ASC
  ";

  $rows = $pdo->query($sql)->fetchAll();

  // أضف تصنيف افتراضي "الكل" في البداية (id=0) — غير مخزّن في الجدول
  array_unshift($rows, [
    'id'         => 0,
    'name'       => $isAr ? 'الكل' : 'All',
    'name_ar'    => 'الكل',
    'name_en'    => 'All',
    'sort_order' => -1,
  ]);

  respond(['ok' => 1, 'categories' => $rows], 200);

} catch (Throwable $e) {
  respond(['ok' => 0, 'error' => $e->getMessage()], 500);
}
