<?php
// voicechat/api/emoji_feed.php
declare(strict_types=1);

require __DIR__ . '/config.php';   // يوفر db() و json_out() والهيدرز و CORS

// لو حاب تحمّي الـ feed لاحقاً، تقدر تفعل هذا السطر:
// $payload = require_auth();  // حالياً معطّل عمداً

// ===== قراءة البارامترات =====
$in = $_GET;
$roomUid   = trim((string)($in['room_uid'] ?? $in['roomUid'] ?? ''));
$since     = (int)($in['since']  ?? 0);                 // Unix seconds (اختياري)
$windowSec = max(1, (int)($in['window'] ?? 5));         // نافذة زمنية افتراضي 5 ثواني

if ($roomUid === '') {
  json_out(['ok'=>false, 'error'=>'missing room_uid'], 400);
}

try {
  $pdo = db();
} catch (Throwable $e) {
  json_out(['ok'=>false, 'error'=>'db_connect_failed'], 500);
}

// helper لعمل رابط كامل للصورة
if (!function_exists('full_url')) {
  function full_url(?string $p): ?string {
    if (!$p) return null;
    if (preg_match('~^https?://~i', $p)) return $p;
    $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    return $scheme.'://'.$host.(str_starts_with($p,'/') ? $p : '/'.$p);
  }
}

// ===== الاستعلام =====
if ($since > 0) {
  // اجلب كل الأحداث من وقت since وحتى الآن
  $sql = "SELECT e.id, e.room_uid, e.user_uid, e.emoji_id, e.created_at, m.image_url
          FROM room_emoji_events e
          JOIN emojis m ON m.id = e.emoji_id
          WHERE e.room_uid = :room AND e.created_at >= FROM_UNIXTIME(:since)
          ORDER BY e.id DESC
          LIMIT 200";
  $st = $pdo->prepare($sql);
  $st->bindValue(':room',  $roomUid, PDO::PARAM_STR);
  $st->bindValue(':since', $since,   PDO::PARAM_INT);
  $st->execute();
} else {
  // اجلب أحدث الأحداث خلال نافذة زمنية قصيرة
  $sql = "SELECT e.id, e.room_uid, e.user_uid, e.emoji_id, e.created_at, m.image_url
          FROM room_emoji_events e
          JOIN emojis m ON m.id = e.emoji_id
          WHERE e.room_uid = :room AND e.created_at >= (NOW() - INTERVAL :win SECOND)
          ORDER BY e.id DESC
          LIMIT 200";
  $st = $pdo->prepare($sql);
  $st->bindValue(':room', $roomUid, PDO::PARAM_STR);
  $st->bindValue(':win',  $windowSec, PDO::PARAM_INT);
  $st->execute();
}

$rows = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];

// حوّل image_url إلى رابط كامل
foreach ($rows as &$r) {
  $r['image_url'] = full_url($r['image_url'] ?? '');
}

json_out(['ok'=>true, 'data'=>$rows, 'now'=>time()]);
