<?php
// /voicechat/api/billing/google/skus_get.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

// فعّل الأخطاء عند تمرير ?dbg=1
$DBG = isset($_GET['dbg']);
if ($DBG) { ini_set('display_errors','1'); error_reporting(E_ALL); }

// جرّب عدّة مسارات للـ config.php
$ROOT = realpath(__DIR__ . '/../../..');           // -> /voicechat
$paths = [
  $ROOT . '/wesaladmin/config.php',                // الأكثر احتمالاً
  $ROOT . '/config.php',                           // لو عندك كونفيج عام في الجذر
];

$found = false;
foreach ($paths as $p) {
  if (is_file($p)) { require_once $p; $found = true; break; }
}
if (!$found) {
  http_response_code(500);
  echo json_encode(['ok'=>false, 'message'=>'config.php not found', 'pathsTried'=>$paths]);
  exit;
}

if (!function_exists('db')) {
  http_response_code(500);
  echo json_encode(['ok'=>false, 'message'=>'db() function not found in config.php']);
  exit;
}

try {
  $pdo = db();

  // رجّع كل المنتجات المفعّلة
  $sql = "SELECT sku, coins
          FROM billing_google_products
          WHERE enabled = 1
          ORDER BY coins ASC, sku ASC";
  $rows = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC) ?: [];

  $items = [];
  foreach ($rows as $r) {
    $items[] = ['sku' => (string)$r['sku'], 'coins' => (int)$r['coins']];
  }

  echo json_encode(['ok'=>true, 'items'=>$items], JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'ok'=>false,
    'message'=>'DB error',
    'debug'=>$DBG ? $e->getMessage() : null
  ], JSON_UNESCAPED_UNICODE);
}
