<?php
// voicechat/api/banners_list.php
declare(strict_types=1);
require __DIR__ . '/config.php';

function app_origin(): string {
  if (defined('BASE_URL') && BASE_URL) return rtrim((string)BASE_URL, '/');
  return 'https://battle-party.com';
}

function abs_url(string $u): string {
  $u = trim($u);
  if ($u === '') return $u;
  if (preg_match('#^https?://#i', $u)) return $u;
  if ($u[0] !== '/') $u = '/'.$u;
  return rtrim(app_origin(), '/') . $u;
}

try {
  $pdo = db();

  // استخدم NOW() من MySQL لتفادي فروقات التوقيت
  $sql = "
    SELECT id, image_url, page_url
    FROM banners
    WHERE is_active = 1
      AND (starts_at IS NULL OR starts_at <= NOW())
      AND (ends_at   IS NULL OR ends_at   >= NOW())
    ORDER BY sort_order ASC, id ASC
  ";
  $rows = $pdo->query($sql)->fetchAll();

  $items = [];
  foreach ($rows as $r) {
    $img = abs_url((string)$r['image_url']);
    if ($img === '') continue;
    $items[] = [
      'id'        => (int)$r['id'],
      'image_url' => $img,
      'page_url'  => (isset($r['page_url']) && trim((string)$r['page_url']) !== '')
                    ? (string)$r['page_url'] : null,
    ];
  }

  json_out(['ok' => true, 'items' => $items]);
} catch (Throwable $e) {
  // سترى رسالة الخطأ JSON بدلاً من صفحة 500 عامة
  json_out(['ok' => false, 'error' => $e->getMessage()], 500);
}
