<?php
// backend/api/auth_register.php
require __DIR__ . '/config.php';

// ===== UUID v4 آمن على أي سيرفر =====
function uuidv4(): string {
  $data = random_bytes(16);
  $data[6] = chr((ord($data[6]) & 0x0f) | 0x40); // version 4
  $data[8] = chr((ord($data[8]) & 0x3f) | 0x80); // variant
  return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}

try {
  $input = json_decode(file_get_contents('php://input'), true) ?? [];
  $email    = trim($input['email']    ?? '');
  $username = trim($input['username'] ?? '');
  $password = (string)($input['password'] ?? '');

  if ($email === '' || $username === '' || $password === '') {
    json_out(['error' => 'missing_fields'], 422);
  }

  // UID ثابت لكل مستخدم
  $uid = uuidv4();

  $stmt = db()->prepare("INSERT INTO users (uid,email,username,password_hash) VALUES (?,?,?,?)");
  $stmt->execute([$uid, $email, $username, password_hash($password, PASSWORD_BCRYPT)]);

  $token = jwt_encode(['uid'=>$uid,'username'=>$username,'iat'=>time()]);

  json_out(['ok'=>true,'uid'=>$uid,'username'=>$username,'token'=>$token]);
} catch (PDOException $e) {
  // إيميل مكرر أو خطأ قواعد بيانات
  if (str_contains(strtolower($e->getMessage()), 'duplicate') || $e->getCode() === '23000') {
    json_out(['error'=>'email_exists'], 409);
  }
  json_out(['error'=>'db_error'], 500);
} catch (Throwable $e) {
  json_out(['error'=>'server_error'], 500);
}
