<?php
// /public_html/voicechat/agents/web/dashboard.php
declare(strict_types=1);
require_once __DIR__ . '/_web_common.php';

/* ---------- AJAX: lookup by userid ---------- */
if (($_GET['ajax'] ?? '') === 'lookup_user') {
  header('Content-Type: application/json; charset=utf-8');

  if (!agent_get_token()) { http_response_code(401); echo json_encode(['ok'=>false,'error'=>'unauthorized']); exit; }

  $userid = trim((string)($_GET['userid'] ?? ''));
  if ($userid === '') { echo json_encode(['ok'=>false,'error'=>'empty']); exit; }

  try {
    $pdo = db();
    $st = $pdo->prepare("
      SELECT id, uid, userid, username, avatar_url
      FROM users
      WHERE CAST(userid AS CHAR) = ? OR userid = ?
      LIMIT 1
    ");
    $st->execute([$userid, $userid]);
    $u = $st->fetch();

    if ($u) {
      echo json_encode([
        'ok'   => true,
        'user' => [
          'id'       => (int)$u['id'],
          'uid'      => (string)$u['uid'],
          'userid'   => (string)$u['userid'],
          'username' => (string)($u['username'] ?? ''),
          'avatar'   => (string)($u['avatar_url'] ?? ''),
        ]
      ], JSON_UNESCAPED_UNICODE);
    } else {
      echo json_encode(['ok'=>false,'error'=>'not_found']);
    }
  } catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>'server_error']);
  }
  exit;
}

/* ---------- صفحة اللوحة ---------- */
$auth  = require_agent_or_redirect();
$token = $auth['token'];
$agent = $auth['agent'];

$msg = null; $err = null; $result = null;

if ($_SERVER['REQUEST_METHOD']==='POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err='رمز الأمان غير صالح.';
  } else {
    $user_uid = trim((string)($_POST['user_uid'] ?? ''));
    $coins    = (int)($_POST['coins'] ?? 0);

    if ($user_uid === '' || $coins <= 0) {
      $err='من فضلك أدخل UserID صحيح والمبلغ.';
    } else {
      $res = api_call('charge_user.php', 'POST', [
        'user_uid' => $user_uid,
        'coins'    => $coins,
      ], $token);

      if (($res['ok'] ?? false)) {
        $msg = 'تم شحن ' . (int)$coins . ' كوين للمستخدم.';
        $result = $res['charged'] ?? null;
        // تحديث الملف الشخصي لعرض الرصيد بعد العملية
        $p = api_call('profile.php','GET',null,$token);
        if (($p['ok'] ?? false)) $agent = $p['agent'];
      } else {
        $code = $res['error'] ?? 'فشل الشحن';
        $err  = 'تعذّر الشحن: ' . e((string)$code);
      }
    }
  }
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1">
  <title>لوحة الوكيل</title>
  <style>
    :root{
      --bg:#0b1220;--panel:#0f172a;--text:#e5e7eb;--sub:#94a3b8;
      --border:#243047;--primary:#3b82f6;--danger:#ef4444;--ok:#22c55e
    }
    *{box-sizing:border-box}
    body{margin:0;background:var(--bg);color:var(--text);font-family:system-ui,-apple-system,Segoe UI,Roboto}
    a{color:#93c5fd;text-decoration:none}
    header{
      position:sticky;top:0;z-index:10;
      display:flex;gap:12px;align-items:center;justify-content:space-between;
      padding:12px 16px;border-bottom:1px solid var(--border);background:#0c1426;
      flex-wrap:wrap;
    }
    .brand{font-weight:700;font-size:18px;display:flex;gap:8px;align-items:center;flex-wrap:wrap}
    .chip{
      display:inline-flex;align-items:center;gap:8px;
      border:1px solid #2b3753;background:linear-gradient(180deg,#0f1a33,#0d1529);
      padding:8px 12px;border-radius:999px;font-weight:700;white-space:nowrap
    }
    .chip.usd{border-color:#2e7d32}
    .chip .coin{font-size:18px;line-height:1}
    .chip .num{font-variant-numeric:tabular-nums}
    .btn{
      display:inline-block;padding:8px 12px;border-radius:10px;border:1px solid var(--border);
      background:#1a2336;color:var(--text);cursor:pointer
    }
    .btn.pri{background:var(--primary);color:#fff}
    .btn.dan{background:var(--danger);color:#fff}
    .btn[disabled]{opacity:.5;pointer-events:none}
    .wrap{max-width:960px;margin:0 auto;padding:16px}
    .cards{display:grid;gap:16px;grid-template-columns:1fr 1fr}
    @media (max-width: 860px){ .cards{grid-template-columns:1fr} }
    .card{background:var(--panel);border:1px solid var(--border);border-radius:14px;padding:16px}
    h2{margin:0 0 12px}
    .form{display:grid;gap:12px}
    .input label{display:block;font-size:13px;margin-bottom:6px;color:var(--sub)}
    .input input{
      width:100%;padding:12px;border-radius:12px;border:1px solid var(--border);
      background:#0c1426;color:var(--text);font-size:15px
    }
    .row{display:flex;gap:8px;flex-wrap:wrap}
    .row .btn{min-width:120px}
    .alert{
      border:1px solid var(--danger);padding:10px 12px;border-radius:12px;background:rgba(239,68,68,.08);margin-bottom:8px
    }
    .alert.ok{border-color:var(--ok);background:rgba(34,197,94,.08)}
    .mono{font-family:ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,"Liberation Mono","Courier New",monospace}
    .muted{color:var(--sub)}
    .found{display:flex;align-items:center;gap:10px;margin-top:6px}
    .pill{display:inline-block;border:1px solid var(--border);border-radius:999px;padding:2px 8px;font-size:12px}
    .pill.ok{border-color:var(--ok)}
    .pill.bad{border-color:#ef4444}
    .avatar{width:36px;height:36px;border-radius:999px;object-fit:cover;border:1px solid var(--border);background:#0c1426}
    /* تحسينات للجوال */
    @media (max-width:520px){
      .brand{font-size:16px}
      .btn, .input input{font-size:16px}
      .row{flex-direction:column}
      .row .btn{width:100%}
    }
  </style>
</head>
<body>
<header>
  <div class="brand">
    <span>لوحة وكيل:</span>
    <b><?= e($agent['display_name'] ?? $agent['username'] ?? '') ?></b>
  </div>

  <!-- شارات الرصيد العلوية -->
  <div class="row" style="align-items:center">
    <div class="chip" title="رصيد الكوين">
      <span class="coin">🪙</span>
      <span class="num" id="balanceTopCoins"><?= (int)($agent['main_balance'] ?? 0) ?></span>
      <span class="muted" style="font-weight:600">كوين</span>
    </div>
    <div class="chip usd" title="رصيد الدولار">
      <span class="coin">💵</span>
      <span class="num" id="balanceTopUsd">
        <?php
          $usd_cents = (int)($agent['usd_balance_cents'] ?? 0);
          // fallback لو API ترجع usd_balance كنص جاهز:
          $usd_display = $usd_cents ? number_format($usd_cents / 100, 2, '.', '') : (string)($agent['usd_balance'] ?? '0.00');
          echo $usd_display === '' ? '0.00' : e($usd_display);
        ?>
      </span>
      <span class="muted" style="font-weight:600">$</span>
    </div>
  </div>

  <div class="row">
    <a class="btn" href="charges.php">سجل الشحن</a>
    <a class="btn" href="javascript:location.reload()">تحديث</a>
    <a class="btn dan" href="logout.php">خروج</a>
  </div>
</header>

<div class="wrap">
  <?php if ($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>
  <?php if ($msg): ?><div class="alert ok"><?= e($msg) ?></div><?php endif; ?>

  <div class="cards">
    <div class="card">
      <h2>بيانات الوكيل</h2>
      <div>المعرف: <span class="mono"><?= e((string)($agent['id'] ?? '')) ?></span></div>
      <div>اسم المستخدم: <span class="mono"><?= e((string)($agent['username'] ?? '')) ?></span></div>
      <div>الحالة: <b><?= e((string)($agent['status'] ?? '')) ?></b></div>
      <div>الرصيد الحالي: <b class="mono" id="balanceCardCoins"><?= (int)($agent['main_balance'] ?? 0) ?></b> كوين</div>
      <div>الدولار: <b class="mono" id="balanceCardUsd">
        <?php
          echo $usd_display === '' ? '0.00' : e($usd_display);
        ?>
      </b> $</div>
      <?php if (!empty($agent['last_login_at'])): ?>
        <div class="muted" style="margin-top:6px">آخر دخول: <?= e((string)$agent['last_login_at']) ?></div>
      <?php endif; ?>
    </div>

    <div class="card">
      <h2>شحن كوين لمستخدم</h2>
      <form method="post" class="form" id="chargeForm" autocomplete="off">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="user_uid" id="user_uid">

        <div class="input">
          <label>UserID المستخدم</label>
          <input name="userid" id="userid" required placeholder="اكتب UserID هنا">
          <div id="lookupBox" class="found muted" style="display:none">
            <img id="uAvatar" class="avatar" src="" alt="">
            <div>
              <div>الاسم: <b id="uName"></b></div>
              <div class="mono" style="font-size:12px">UID: <span id="uUid"></span></div>
            </div>
            <span id="uStatus" class="pill">—</span>
          </div>
        </div>

        <div class="input">
          <label>المبلغ (كوين)</label>
          <input name="coins" id="coins" type="number" min="1" step="1" required>
        </div>

        <div class="row">
          <button class="btn pri" id="submitBtn" type="submit" disabled>تنفيذ الشحن</button>
        </div>
      </form>

      <?php if ($result): ?>
        <div class="muted" style="margin-top:8px">
          تم الشحن — الرصيد بعد العملية: <b class="mono"><?= (int)($result['agent_balance_after'] ?? 0) ?></b>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>

<script>
(function(){
  // بحث المستخدم بالـ userid
  const userid   = document.getElementById('userid');
  const box      = document.getElementById('lookupBox');
  const nameEl   = document.getElementById('uName');
  const uidEl    = document.getElementById('uUid');
  const avatarEl = document.getElementById('uAvatar');
  const statusEl = document.getElementById('uStatus');
  const uidInput = document.getElementById('user_uid');
  const submit   = document.getElementById('submitBtn');

  let timer = null, last = '';

  function setState(found, data){
    box.style.display = 'flex';
    if (found) {
      nameEl.textContent   = data.username || '(بدون اسم)';
      uidEl.textContent    = data.uid || '';
      avatarEl.src         = data.avatar || '';
      statusEl.textContent = 'صحيح';
      statusEl.className   = 'pill ok';
      uidInput.value       = data.uid || '';
      submit.disabled      = false;
    } else {
      nameEl.textContent   = '';
      uidEl.textContent    = '';
      avatarEl.src         = '';
      statusEl.textContent = 'غير موجود';
      statusEl.className   = 'pill bad';
      uidInput.value       = '';
      submit.disabled      = true;
    }
  }

  async function lookup(v){
    if (!v) { box.style.display='none'; uidInput.value=''; submit.disabled=true; return; }
    try{
      const res = await fetch('dashboard.php?ajax=lookup_user&userid=' + encodeURIComponent(v), {cache:'no-store'});
      const j   = await res.json();
      if (j && j.ok && j.user) setState(true, j.user);
      else setState(false, null);
    }catch(e){
      setState(false, null);
    }
  }

  userid.addEventListener('input', function(){
    const v = userid.value.trim();
    if (v === last) return;
    last = v;
    if (timer) clearTimeout(timer);
    timer = setTimeout(()=>lookup(v), 350);
  });

  // مزامنة شارات الرصيد من بطاقة البيانات
  const bc = document.getElementById('balanceCardCoins');
  const bu = document.getElementById('balanceCardUsd');
  const tc = document.getElementById('balanceTopCoins');
  const tu = document.getElementById('balanceTopUsd');
  if (bc && tc) tc.textContent = bc.textContent;
  if (bu && tu) tu.textContent = bu.textContent;
})();
</script>
</body>
</html>
