<?php
// admin/users_edit.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(string $t=null): bool { return $t && hash_equals($_SESSION['csrf'], $t); }

$pdo = db();
$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) redirect('users.php');

$msg = null; $err = null;

// جلب المستخدم
$st = $pdo->prepare("SELECT * FROM users WHERE id=? LIMIT 1");
$st->execute([$id]);
$user = $st->fetch();
if (!$user) redirect('users.php');

// حفظ
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $tok = $_POST['csrf'] ?? '';
  if (!csrf_ok($tok)) {
    $err = 'رمز الأمان غير صالح.';
  } else {
    $username = trim($_POST['username'] ?? '');
    $email    = trim($_POST['email'] ?? '');
    $userid   = trim($_POST['userid'] ?? '');        // ← جديد: userID
    $gender   = trim($_POST['gender'] ?? '');
    $country  = trim($_POST['country'] ?? '');
    $ccode    = trim($_POST['country_code'] ?? '');
    $bdate    = trim($_POST['birth_date'] ?? '');
    $coins    = (int)($_POST['coins'] ?? 0);
    $avatar   = trim($_POST['avatar_url'] ?? '');
    $cover    = trim($_POST['cover_url'] ?? '');

    // تحويل القيم الفارغة إلى NULL
    $email   = $email   !== '' ? $email   : null;
    $userid  = $userid  !== '' ? $userid  : null;    // ← userID إلى NULL عند الفراغ
    $gender  = $gender  !== '' ? $gender  : null;
    $country = $country !== '' ? $country : null;
    $ccode   = $ccode   !== '' ? $ccode   : null;
    $bdate   = $bdate   !== '' ? $bdate   : null;
    $avatar  = $avatar  !== '' ? $avatar  : null;
    $cover   = $cover   !== '' ? $cover   : null;

    try {
      $sql = "UPDATE users
              SET username=?, email=?, userid=?, gender=?, country=?, country_code=?, birth_date=?,
                  coins=?, avatar_url=?, cover_url=?
              WHERE id=? LIMIT 1";
      $pdo->prepare($sql)->execute([
        $username, $email, $userid, $gender, $country, $ccode, $bdate,
        $coins, $avatar, $cover, $id
      ]);
      $msg = 'تم الحفظ بنجاح.';
      // تحديث بيانات المعروض
      $st = $pdo->prepare("SELECT * FROM users WHERE id=? LIMIT 1");
      $st->execute([$id]);
      $user = $st->fetch();
    } catch (Throwable $e) {
      $err = 'حدث خطأ أثناء الحفظ.';
    }
  }
}

$PAGE_TITLE = "تعديل مستخدم #{$id}";
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';
?>
  <div class="card" style="max-width:760px;">
    <h1>تعديل مستخدم #<?= (int)$user['id'] ?></h1>
    <?php if ($msg): ?><div class="alert" style="border-color:#22c55e;"><?= e($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>

    <form method="post" class="form">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <div class="grid cols-2">
        <div class="input">
          <label>اسم المستخدم</label>
          <input name="username" value="<?= e($user['username'] ?? '') ?>" required>
        </div>
        <div class="input">
          <label>الإيميل</label>
          <input name="email" type="email" value="<?= e($user['email'] ?? '') ?>">
        </div>

        <div class="input">
          <label>UserID</label>
          <input name="userid" value="<?= e((string)($user['userid'] ?? '')) ?>" placeholder="مثال: 30145215">
        </div>
        <div class="input">
          <label>الجنس</label>
          <input name="gender" placeholder="male / female / other" value="<?= e($user['gender'] ?? '') ?>">
        </div>

        <div class="input">
          <label>الدولة (بالاسم)</label>
          <input name="country" value="<?= e($user['country'] ?? '') ?>">
        </div>
        <div class="input">
          <label>كود الدولة</label>
          <input name="country_code" placeholder="EG / SA / AE ..." value="<?= e($user['country_code'] ?? '') ?>">
        </div>

        <div class="input">
          <label>تاريخ الميلاد</label>
          <input name="birth_date" type="date" value="<?= e($user['birth_date'] ?? '') ?>">
        </div>
        <div class="input">
          <label>الكوينز</label>
          <input name="coins" type="number" step="1" value="<?= (int)($user['coins'] ?? 0) ?>">
        </div>

        <div class="input">
          <label>الصورة الشخصية (URL)</label>
          <input name="avatar_url" value="<?= e($user['avatar_url'] ?? '') ?>">
        </div>
        <div class="input" style="grid-column: 1 / -1;">
          <label>صورة الغلاف (URL)</label>
          <input name="cover_url" value="<?= e($user['cover_url'] ?? '') ?>">
        </div>
      </div>

      <div style="display:flex; gap:8px; margin-top:8px;">
        <button class="btn" type="submit">حفظ</button>
        <a class="btn secondary" href="users.php">رجوع للقائمة</a>
      </div>
    </form>
  </div>
<?php require __DIR__ . '/inc/footer.php'; ?>
