<?php
// wesalchat/admin/store/user_items.php
declare(strict_types=1);

$CFG_PATH = __DIR__ . '/config.php';
$INC_DIR  = __DIR__ . '/inc';
require_once $CFG_PATH;
require_once $INC_DIR . '/auth.php';
require_login();

/* CSRF */
if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }

if (!function_exists('e')) { function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }
function fmt_dt(?string $s): string { if(!$s)return''; $t=strtotime($s); return $t>0?date('Y-m-d H:i',$t):e($s); }

$pdo = db();
$msg=null; $err=null;

/* --------- POST: grant / delete -------- */
if ($_SERVER['REQUEST_METHOD']==='POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.';
  } else {
    $act = $_POST['action'] ?? '';
    try {
      if ($act==='grant') {
        $userId  = (int)($_POST['user_id'] ?? 0);
        $itemId  = (int)($_POST['item_id'] ?? 0);
        $source  = trim((string)($_POST['source'] ?? 'admin'));
        $expires = trim((string)($_POST['expires_at'] ?? ''));  // YYYY-mm-dd HH:ii
        if ($userId<=0 || $itemId<=0) throw new Exception('قيَم غير صالحة.');

        if ($expires === '') {
          // إن لم تُحدّد تاريخ نهاية: لو للعنصر days>0 اجعلها الآن + الأيام
          $st = $pdo->prepare("SELECT days FROM store_items WHERE id=?");
          $st->execute([$itemId]); $days = (int)($st->fetchColumn() ?: 0);
          if ($days>0) {
            $pdo->prepare("INSERT INTO user_store_items (user_id,item_id,expires_at,source,created_at)
                           VALUES (?,?,DATE_ADD(NOW(), INTERVAL ? DAY),?,NOW())")
                ->execute([$userId,$itemId,$days,$source]);
          } else {
            $pdo->prepare("INSERT INTO user_store_items (user_id,item_id,expires_at,source,created_at)
                           VALUES (?,?,NULL,?,NOW())")
                ->execute([$userId,$itemId,$source]);
          }
        } else {
          $pdo->prepare("INSERT INTO user_store_items (user_id,item_id,expires_at,source,created_at)
                         VALUES (?,?,?,?,NOW())")
              ->execute([$userId,$itemId,$expires,$source]);
        }
        $msg = 'تم منح العنصر للمستخدم.';
      } elseif ($act==='delete' ) {
        $id = (int)($_POST['id'] ?? 0);
        if ($id>0) {
          $pdo->prepare("DELETE FROM user_store_items WHERE id=? LIMIT 1")->execute([$id]);
          $msg = 'تم حذف / سحب العنصر من المستخدم.';
        }
      }
    } catch (Throwable $e) {
      $err = 'تعذّر تنفيذ العملية.' . (isset($_GET['dbg']) ? ' ('.$e->getMessage().')' : '');
    }
  }
}

/* ---------------- Filters ---------------- */
$userId = (int)($_GET['user_id'] ?? 0);
$itemId = (int)($_GET['item_id'] ?? 0);
$source = trim($_GET['source'] ?? '');
$page   = max(1, (int)($_GET['page'] ?? 1));
$perPage= 50; $offset = ($page-1)*$perPage;

$where="1=1"; $params=[];
if($userId>0){ $where.=" AND ui.user_id=?"; $params[]=$userId; }
if($itemId>0){ $where.=" AND ui.item_id=?"; $params[]=$itemId; }
if($source!==''){ $where.=" AND ui.source=?"; $params[]=$source; }

$total=0;
try{
  $st=$pdo->prepare("SELECT COUNT(*) FROM user_store_items ui WHERE $where");
  $st->execute($params); $total=(int)$st->fetchColumn();
}catch(Throwable $e){ $err='تعذّر حساب الإجمالي.'; }

$pages=max(1,(int)ceil($total/$perPage));

$rows=[];
try{
  $sql="SELECT ui.*, u.username AS user_name, si.name AS item_name
        FROM user_store_items ui
        LEFT JOIN users u  ON u.id  = ui.user_id
        LEFT JOIN store_items si ON si.id = ui.item_id
        WHERE $where
        ORDER BY ui.id DESC
        LIMIT $perPage OFFSET $offset";
  $st=$pdo->prepare($sql); $st->execute($params);
  $rows=$st->fetchAll(PDO::FETCH_ASSOC) ?: [];
}catch(Throwable $e){ $err='تعذّر جلب البيانات.' . (isset($_GET['dbg']) ? ' ('.$e->getMessage().')' : ''); }

$PAGE_TITLE="عناصر المستخدمين";
require $INC_DIR.'/header.php';
require $INC_DIR.'/sidebar.php';
?>
<style>
.user-items-page .table{width:100%;border-collapse:separate;border-spacing:0;background:var(--panel);border:1px solid var(--border);border-radius:12px;overflow:hidden;table-layout:fixed}
.user-items-page .table td,.user-items-page .table th{padding:10px 12px;border-bottom:1px solid var(--border)}
.user-items-page .table thead th{background:#0b1220;color:var(--text);font-weight:700;position:sticky;top:0;z-index:3;box-shadow:inset 0 -1px 0 var(--border)}
.user-items-page .table tbody tr:nth-child(even) td{background:rgba(255,255,255,.015)}
.user-items-page .table tbody tr:hover td{background:rgba(59,130,246,.08)}
.user-items-page .table-wrap{max-height:70vh;overflow:auto;position:relative}
.user-items-page .badge{display:inline-block;padding:2px 8px;border-radius:999px;border:1px solid var(--border);font-size:12px}
.user-items-page .td-center{text-align:center}
.user-items-page .col-id{width:70px}.user-items-page .col-user{width:220px}.user-items-page .col-item{width:260px}.user-items-page .col-source{width:140px}.user-items-page .col-exp{width:180px}.user-items-page .col-created{width:170px}.user-items-page .col-actions{width:150px}
</style>

<div class="user-items-page">
  <div class="card" style="margin-bottom:16px;">
    <form method="get" class="form" style="display:flex; gap:12px; align-items:flex-end; flex-wrap:wrap;">
      <div class="input"><label>User ID</label><input type="number" name="user_id" min="1" value="<?= $userId?:'' ?>"></div>
      <div class="input"><label>Item ID</label><input type="number" name="item_id" min="1" value="<?= $itemId?:'' ?>"></div>
      <div class="input"><label>المصدر</label><input type="text" name="source" value="<?= e($source) ?>" placeholder="admin / order / promo"></div>
      <button class="btn sm" type="submit">بحث</button>
      <?php if($userId||$itemId||$source!==''): ?><a class="btn sm secondary" href="user_items.php">مسح الفلاتر</a><?php endif; ?>
      <div style="margin-inline-start:auto;opacity:.9;">إجمالي: <b><?= $total ?></b></div>
    </form>

    <?php if ($msg): ?><div class="alert" style="margin-top:12px;border-color:#22c55e;"><?= e($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert" style="margin-top:12px;"><?= e($err) ?></div><?php endif; ?>
  </div>

  <!-- نموذج منح عنصر -->
  <div class="card" style="margin-bottom:16px;">
    <form method="post" class="form" style="display:flex;gap:12px;align-items:flex-end;flex-wrap:wrap;">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="grant">
      <div class="input"><label>User ID</label><input type="number" name="user_id" min="1" required></div>
      <div class="input"><label>Item ID</label><input type="number" name="item_id" min="1" required></div>
      <div class="input"><label>Expires At (اختياري)</label><input type="datetime-local" name="expires_at"></div>
      <div class="input"><label>المصدر</label><input type="text" name="source" value="admin"></div>
      <button class="btn sm" type="submit">+ منح عنصر</button>
      <div style="opacity:.8">إذا تُركت مدة الانتهاء فارغة سيتم استخدام <b>days</b> من جدول العنصر (إن وجدت).</div>
    </form>
  </div>

  <div class="card">
    <div class="table-wrap">
      <table class="table">
        <colgroup>
          <col class="col-id"><col class="col-user"><col class="col-item"><col class="col-source"><col class="col-exp"><col class="col-created"><col class="col-actions">
        </colgroup>
        <thead>
          <tr>
            <th class="td-center">#</th>
            <th>المستخدم</th>
            <th>العنصر</th>
            <th>المصدر</th>
            <th>ينتهي في</th>
            <th>أُنشيء</th>
            <th>إجراءات</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $r): ?>
          <tr>
            <td class="td-center"><?= (int)$r['id'] ?></td>
            <td><?php if(!empty($r['user_name'])): ?><?= e($r['user_name']) ?> (ID: <?= (int)$r['user_id'] ?>)<?php else: ?>ID: <?= (int)$r['user_id'] ?><?php endif; ?></td>
            <td><span class="ellipsis" title="<?= e((string)$r['item_name']) ?>"><?= e((string)($r['item_name'] ?: 'ID: '.$r['item_id'])) ?></span></td>
            <td><span class="badge"><?= e((string)$r['source']) ?></span></td>
            <td><?= $r['expires_at'] ? fmt_dt($r['expires_at']) : '—' ?></td>
            <td><?= fmt_dt($r['created_at'] ?? '') ?></td>
            <td>
              <form method="post" onsubmit="return confirm('سحب هذا العنصر من المستخدم؟');" style="display:inline-block">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <button class="btn sm" type="submit" style="background:var(--danger);">حذف</button>
              </form>
            </td>
          </tr>
          <?php endforeach; ?>
          <?php if(!$rows): ?><tr><td colspan="7" style="text-align:center;opacity:.8;">لا توجد بيانات</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>

    <?php if($pages>1): ?>
      <div style="display:flex;gap:8px;margin-top:12px;flex-wrap:wrap;">
        <?php for($p=1;$p<=$pages;$p++):
          $url='user_items.php?page='.$p
            .($userId? '&user_id='.$userId:'')
            .($itemId? '&item_id='.$itemId:'')
            .($source!==''? '&source='.urlencode($source):'');
          $is=$p===$page; ?>
          <a href="<?= e($url) ?>" class="btn sm <?= $is?'':'secondary' ?>"<?= $is?' style="pointer-events:none;opacity:.8;"':''; ?>><?= $p ?></a>
        <?php endfor; ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<?php require $INC_DIR.'/footer.php'; ?>
