<?php
// admin/staff_add.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }
if (!function_exists('e')) { function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }

$pdo = db();
$msg=null; $err=null;

if ($_SERVER['REQUEST_METHOD']==='POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err='رمز الأمان غير صالح.';
  } else {
    $username  = trim($_POST['username'] ?? '');
    $email     = trim($_POST['email'] ?? '');
    $full_name = trim($_POST['full_name'] ?? '');
    $role      = trim($_POST['role'] ?? 'admin');
    $password  = (string)($_POST['password'] ?? '');
    $password2 = (string)($_POST['password2'] ?? '');
    $active    = (int)($_POST['is_active'] ?? 1);

    if ($username==='' || $email==='' || $password==='') {
      $err='يرجى تعبئة الحقول المطلوبة.';
    } elseif ($password !== $password2) {
      $err='تأكيد كلمة المرور غير مطابق.';
    } else {
      // فحص تكرار
      $exists = (int)$pdo->prepare("SELECT COUNT(*) FROM `admincp` WHERE username=?")
                         ->execute([$username]) || false;
      $st = $pdo->prepare("SELECT COUNT(*) FROM `admincp` WHERE username=? OR email=?");
      $st->execute([$username,$email]); $dup=(int)$st->fetchColumn();
      if ($dup>0) $err='اسم المستخدم أو البريد مستخدم مسبقًا.';
    }

    if (!$err) {
      try {
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $pdo->prepare("INSERT INTO `admincp`(username,email,full_name,password_hash,role,is_active,created_at,updated_at)
                       VALUES (?,?,?,?,?,?,NOW(),NOW())")
            ->execute([$username,$email,($full_name!==''?$full_name:null),$hash,$role,$active]);
        $msg='تم إضافة الموظف بنجاح.';
      } catch (Throwable $e) {
        $err='تعذّر الإضافة.';
      }
    }
  }
}

$PAGE_TITLE = "إضافة موظف";
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';
?>
<div class="card" style="max-width:900px;">
  <h1>إضافة موظف</h1>
  <?php if($msg):?><div class="alert" style="border-color:#22c55e;"><?=e($msg)?></div><?php endif;?>
  <?php if($err):?><div class="alert"><?=e($err)?></div><?php endif;?>

  <form class="form" method="post">
    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
    <div class="grid cols-2">
      <div class="input"><label>اسم المستخدم *</label><input name="username" required></div>
      <div class="input"><label>الإيميل *</label><input type="email" name="email" required></div>
      <div class="input" style="grid-column:1 / -1;"><label>الاسم الكامل</label><input name="full_name"></div>

      <div class="input"><label>كلمة المرور *</label><input type="password" name="password" required></div>
      <div class="input"><label>تأكيد كلمة المرور *</label><input type="password" name="password2" required></div>

      <div class="input">
        <label>الصلاحية</label>
        <select name="role" style="padding:10px 12px;border-radius:10px;border:1px solid var(--border);background:#0b1220;color:var(--text);">
          <option value="superadmin">مدير عام</option>
          <option value="admin">مدير</option>
          <option value="editor">محرر</option>
          <option value="viewer">مشاهِد</option>
        </select>
      </div>
      <div class="input">
        <label>الحالة</label>
        <select name="is_active" style="padding:10px 12px;border-radius:10px;border:1px solid var(--border);background:#0b1220;color:var(--text);">
          <option value="1">مفعل</option>
          <option value="0">معطل</option>
        </select>
      </div>
    </div>

    <div style="display:flex;gap:8px;margin-top:8px;">
      <button class="btn" type="submit">حفظ</button>
      <a class="btn secondary" href="staff.php">رجوع</a>
    </div>
  </form>
</div>
<?php require __DIR__ . '/inc/footer.php'; ?>
