<?php
// wesaladmin/billing/receipts.php
declare(strict_types=1);

/* ===== detect location & bootstrap ===== */
if (isset($_GET['dbg'])) { ini_set('display_errors','1'); error_reporting(E_ALL); }

$IN_BILLING_DIR = (basename(__DIR__) === 'billing');
$CFG_PATH       = $IN_BILLING_DIR ? __DIR__ . '/config.php' : __DIR__ . '/config.php';
$INC_DIR        = $IN_BILLING_DIR ? __DIR__ . '/inc'        : __DIR__ . '/inc';
$LINK_PREFIX    = $IN_BILLING_DIR ? '../'                       : '';

require_once $CFG_PATH;
require_once $INC_DIR . '/auth.php';
require_login();
/* ======================================= */

/* ---------------- CSRF ---------------- */
if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }

/* -------------- Helpers --------------- */
if (!function_exists('e')) {
  function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}
function fmt_dt(?string $s): string {
  if (!$s) return '';
  $t = strtotime($s); if ($t<=0) return e($s);
  return date('Y-m-d H:i', $t);
}

$pdo = db();
$msg = null; $err = null;

/* ---- (اختياري) تغيير حالة الإيصال فقط للعرض — لا تغيّر رصيد المستخدم هنا ---- */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action = $_POST['action'] ?? '';
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.';
  } elseif ($action === 'mark_status') {
    try {
      $id = (int)($_POST['id'] ?? 0);
      $status = $_POST['status'] ?? '';
      if ($id <= 0 || !in_array($status, ['pending','credited','rejected'], true)) {
        throw new Exception('بيانات غير صالحة.');
      }
      $st = $pdo->prepare("UPDATE billing_google_receipts SET status=? WHERE id=?");
      $st->execute([$status, $id]);
      $msg = 'تم تحديث الحالة.';
    } catch (Throwable $e) {
      $err = 'تعذّر التحديث.';
    }
  }
}

/* -------------- Filters / Paging -------------- */
$q         = trim($_GET['q'] ?? '');     // بحث عام في sku/order_id/token
$userId    = (int)($_GET['user_id'] ?? 0);
$statusF   = $_GET['status'] ?? '';      // '', pending, credited, rejected
$skuF      = trim($_GET['sku'] ?? '');
$from      = trim($_GET['from'] ?? '');  // 2025-09-01
$to        = trim($_GET['to']   ?? '');  // 2025-09-30
$page      = max(1, (int)($_GET['page'] ?? 1));
$perPage   = 50;
$offset    = ($page - 1) * $perPage;

$where = "1=1"; $params = [];
if ($q !== '') {
  $where .= " AND (sku LIKE ? OR order_id LIKE ? OR purchase_token LIKE ?)";
  $kw = "%$q%"; array_push($params,$kw,$kw,$kw);
}
if ($userId > 0) { $where .= " AND user_id=?"; $params[] = $userId; }
if ($statusF !== '' && in_array($statusF, ['pending','credited','rejected'], true)) { $where .= " AND status=?"; $params[] = $statusF; }
if ($skuF !== '') { $where .= " AND sku=?"; $params[] = $skuF; }
if ($from !== '') { $where .= " AND created_at >= ?"; $params[] = $from.' 00:00:00'; }
if ($to   !== '') { $where .= " AND created_at <= ?"; $params[] = $to.' 23:59:59'; }

$total = 0;
$stc = $pdo->prepare("SELECT COUNT(*) FROM billing_google_receipts WHERE $where");
$stc->execute($params);
$total = (int)$stc->fetchColumn();
$pages = max(1, (int)ceil($total / $perPage));

$rows = [];
$sql = "SELECT * FROM billing_google_receipts WHERE $where ORDER BY id DESC LIMIT $perPage OFFSET $offset";
$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];

/* -------------- Render ------------------ */
$PAGE_TITLE = "Google Play — إيصالات الشراء";
require $INC_DIR . '/header.php';
require $INC_DIR . '/sidebar.php';
?>
<style>
:root{
  --bg:#0b1220; --panel:#0f172a; --text:#e5e7eb; --muted:#9ca3af;
  --border:#1f2937; --brand:#3b82f6; --danger:#ef4444; --success:#22c55e;
}
*{box-sizing:border-box}
html{direction:rtl}
body{background:var(--bg);color:var(--text);font:16px/1.6 system-ui,-apple-system,"Segoe UI",Roboto,"Tajawal","Cairo",Arial}
a{color:#93c5fd;text-decoration:none}
a:hover{text-decoration:underline}
.card{background:var(--panel);border:1px solid var(--border);border-radius:12px;padding:12px}
.btn{display:inline-flex;align-items:center;gap:8px;padding:10px 14px;border-radius:10px;background:var(--brand);color:#fff;border:1px solid transparent;cursor:pointer}
.btn:hover{opacity:.95}
.btn.secondary{background:transparent;color:var(--text);border-color:var(--border)}
.btn.sm{padding:6px 10px;font-size:14px}
.badge{display:inline-block;padding:2px 8px;border-radius:999px;border:1px solid var(--border);font-size:12px}
.table{width:100%;border-collapse:separate;border-spacing:0;background:var(--panel);border:1px solid var(--border);border-radius:12px;overflow:hidden;table-layout:fixed}
.table td,.table th{padding:10px 12px;border-bottom:1px solid var(--border);vertical-align:middle;text-align:start}
.table thead th{background:#0b1220;color:var(--text);font-weight:700;position:sticky;top:0;z-index:3}
.table-wrap{max-height:70vh;overflow:auto;position:relative}
.form .input{display:flex;flex-direction:column;gap:6px}
.form input,.form select{background:#0b132a;border:1px solid var(--border);color:#fff;border-radius:10px;padding:10px 12px}
.receipts-page .col-id{width:70px}
.receipts-page .col-user{width:160px}
.receipts-page .col-sku{width:200px}
.receipts-page .col-coins{width:110px}
.receipts-page .col-status{width:140px}
.receipts-page .col-order{width:220px}
.receipts-page .col-created{width:170px}
.receipts-page .col-actions{width:220px}
.ellipsis{max-width:100%;display:inline-block;overflow:hidden;white-space:nowrap;text-overflow:ellipsis}
</style>

<div class="receipts-page">
  <div class="card" style="margin-bottom:16px;">
    <form method="get" class="form" style="display:flex;gap:12px;align-items:flex-end;flex-wrap:wrap">
      <div class="input" style="min-width:220px;">
        <label>بحث عام (SKU / Order / Token)</label>
        <input type="text" name="q" value="<?= e($q) ?>" placeholder="أدخل جزء من القيمة">
      </div>
      <div class="input"><label>ID المستخدم</label><input type="number" min="1" name="user_id" value="<?= $userId>0?(int)$userId:'' ?>"></div>
      <div class="input">
        <label>الحالة</label>
        <select name="status">
          <option value=""<?= $statusF===''?' selected':''; ?>>الكل</option>
          <option value="pending"<?= $statusF==='pending'?' selected':''; ?>>Pending</option>
          <option value="credited"<?= $statusF==='credited'?' selected':''; ?>>Credited</option>
          <option value="rejected"<?= $statusF==='rejected'?' selected':''; ?>>Rejected</option>
        </select>
      </div>
      <div class="input"><label>SKU</label><input type="text" name="sku" value="<?= e($skuF) ?>" placeholder="coins_100"></div>
      <div class="input"><label>من</label><input type="date" name="from" value="<?= e($from) ?>"></div>
      <div class="input"><label>إلى</label><input type="date" name="to" value="<?= e($to) ?>"></div>
      <button class="btn sm" type="submit">بحث</button>
      <?php if ($q!=='' || $userId>0 || $statusF!=='' || $skuF!=='' || $from!=='' || $to!==''): ?>
        <a class="btn sm secondary" href="receipts.php">مسح الفلاتر</a>
      <?php endif; ?>
      <div style="margin-inline-start:auto; opacity:.9;">إجمالي: <b><?= $total ?></b></div>
    </form>

    <?php if ($msg): ?><div class="badge" style="border-color:var(--success); display:block; margin-top:12px;"><?= e($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="badge" style="border-color:var(--danger); display:block; margin-top:12px;"><?= e($err) ?></div><?php endif; ?>
  </div>

  <div class="card">
    <div class="table-wrap">
      <table class="table">
        <colgroup>
          <col class="col-id"><col class="col-user"><col class="col-sku"><col class="col-coins"><col class="col-status"><col class="col-order"><col class="col-created"><col class="col-actions">
        </colgroup>
        <thead>
          <tr>
            <th>#</th>
            <th>المستخدم</th>
            <th>SKU</th>
            <th>Coins</th>
            <th>الحالة</th>
            <th>Order / Token</th>
            <th>تاريخ</th>
            <th>إجراءات</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $r): ?>
            <tr>
              <td><?= (int)$r['id'] ?></td>
              <td>
                <a href="<?= $LINK_PREFIX ?>users_edit.php?id=<?= (int)$r['user_id'] ?>" style="text-decoration:underline;">ID: <?= (int)$r['user_id'] ?></a>
              </td>
              <td><?= e($r['sku'] ?? '') ?></td>
              <td><?= (int)$r['coins'] ?></td>
              <td>
                <?php
                  $color = 'var(--border)';
                  if ($r['status']==='credited') $color='var(--success)';
                  elseif ($r['status']==='rejected') $color='var(--danger)';
                ?>
                <span class="badge" style="border-color:<?= $color ?>"><?= e($r['status'] ?? '') ?></span>
              </td>
              <td>
                <div class="ellipsis" title="<?= e($r['order_id'] ?? '') ?>"><?= e($r['order_id'] ?? '') ?></div>
                <div class="ellipsis" title="<?= e($r['purchase_token'] ?? '') ?>" style="opacity:.7;"><?= e($r['purchase_token'] ?? '') ?></div>
              </td>
              <td><?= fmt_dt($r['created_at'] ?? '') ?></td>
              <td style="display:flex; gap:8px; flex-wrap:nowrap;">
                <form method="post">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                  <input type="hidden" name="action" value="mark_status">
                  <select name="status" style="background:#0b132a;border:1px solid var(--border);color:#fff;border-radius:10px;padding:6px 8px;">
                    <option value="pending"  <?= ($r['status']==='pending')?'selected':''; ?>>Pending</option>
                    <option value="credited" <?= ($r['status']==='credited')?'selected':''; ?>>Credited</option>
                    <option value="rejected" <?= ($r['status']==='rejected')?'selected':''; ?>>Rejected</option>
                  </select>
                  <button class="btn sm" type="submit">حفظ</button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if (!$rows): ?>
            <tr><td colspan="8" style="text-align:center; opacity:.8;">لا توجد إيصالات</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <?php if ($pages > 1): ?>
      <div style="display:flex; gap:8px; margin-top:12px; flex-wrap:wrap;">
        <?php for($p=1;$p<=$pages;$p++):
          $url = 'receipts.php?page='.$p
               .($q!=='' ? '&q='.urlencode($q) : '')
               .($userId>0 ? '&user_id='.$userId : '')
               .($statusF!=='' ? '&status='.$statusF : '')
               .($skuF!=='' ? '&sku='.urlencode($skuF) : '')
               .($from!=='' ? '&from='.$from : '')
               .($to!=='' ? '&to='.$to : '');
          $is = $p===$page; ?>
          <a href="<?= e($url) ?>" class="btn sm <?= $is ? '' : 'secondary' ?>"<?= $is?' style="pointer-events:none; opacity:.8;"':''; ?>><?= $p ?></a>
        <?php endfor; ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<?php require $INC_DIR . '/footer.php'; ?>
