<?php
// wesaladmin/billing/products_edit.php
declare(strict_types=1);

/* ===== detect location & bootstrap ===== */
if (isset($_GET['dbg'])) { ini_set('display_errors','1'); error_reporting(E_ALL); }

$IN_BILLING_DIR = (basename(__DIR__) === 'billing');
$CFG_PATH       = $IN_BILLING_DIR ? __DIR__ . '/config.php' : __DIR__ . '/config.php';
$INC_DIR        = $IN_BILLING_DIR ? __DIR__ . '/inc'        : __DIR__ . '/inc';
$LINK_PREFIX    = $IN_BILLING_DIR ? '../'                       : '';

require_once $CFG_PATH;
require_once $INC_DIR . '/auth.php';
require_login();
/* ======================================= */

/* ---------------- CSRF ---------------- */
if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }

/* -------------- Helpers --------------- */
if (!function_exists('e')) {
  function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}
function fmt_dt(?string $s): string {
  if (!$s) return '';
  $t = strtotime($s); if ($t<=0) return e($s);
  return date('Y-m-d H:i', $t);
}

$pdo = db();
$msg = null; $err = null;

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) { header("Location: products.php"); exit; }

$row = $pdo->prepare("SELECT * FROM billing_google_products WHERE id=?");
$row->execute([$id]);
$item = $row->fetch(PDO::FETCH_ASSOC);
if (!$item) { header("Location: products.php"); exit; }

/* -------------- Update --------------- */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.';
  } else try {
    $sku    = trim($_POST['sku']   ?? '');
    $coins  = (int)($_POST['coins'] ?? 0);
    $enabled = isset($_POST['enabled']) ? 1 : 0;

    if ($sku === '' || $coins <= 0) throw new Exception('الرجاء إدخال SKU وقيمة كوين صحيحة.');

    $st = $pdo->prepare("UPDATE billing_google_products SET sku=?, coins=?, enabled=? WHERE id=?");
    $st->execute([$sku, $coins, $enabled, $id]);

    $msg = 'تم حفظ التعديلات.';
    // إعادة جلب
    $row = $pdo->prepare("SELECT * FROM billing_google_products WHERE id=?");
    $row->execute([$id]);
    $item = $row->fetch(PDO::FETCH_ASSOC);
  } catch (Throwable $e) {
    $err = $e->getMessage();
  }
}

/* -------------- Render ------------------ */
$PAGE_TITLE = "تعديل باقة — #".$id;
require $INC_DIR . '/header.php';
require $INC_DIR . '/sidebar.php';
?>
<style>
:root{
  --bg:#0b1220; --panel:#0f172a; --text:#e5e7eb; --muted:#9ca3af;
  --border:#1f2937; --brand:#3b82f6; --danger:#ef4444; --success:#22c55e;
}
*{box-sizing:border-box}
html{direction:rtl}
body{background:var(--bg);color:var(--text);font:16px/1.6 system-ui,-apple-system,"Segoe UI",Roboto,"Tajawal","Cairo",Arial}
a{color:#93c5fd;text-decoration:none}
a:hover{text-decoration:underline}
.card{background:var(--panel);border:1px solid var(--border);border-radius:12px;padding:12px;max-width:680px}
.btn{display:inline-flex;align-items:center;gap:8px;padding:10px 14px;border-radius:10px;background:var(--brand);color:#fff;border:1px solid transparent;cursor:pointer}
.btn:hover{opacity:.95}
.btn.secondary{background:transparent;color:var(--text);border-color:var(--border)}
.form .input{display:flex;flex-direction:column;gap:6px}
.form input,.form select{background:#0b132a;border:1px solid var(--border);color:#fff;border-radius:10px;padding:10px 12px}
</style>

<div class="card">
  <a href="products.php" class="btn secondary" style="margin-bottom:10px;">← الرجوع للباقات</a>

  <?php if ($msg): ?><div class="badge" style="border:1px solid var(--success);display:block;margin-bottom:12px;"><?= e($msg) ?></div><?php endif; ?>
  <?php if ($err): ?><div class="badge" style="border:1px solid var(--danger);display:block;margin-bottom:12px;"><?= e($err) ?></div><?php endif; ?>

  <form method="post" class="form" style="display:flex; gap:12px; flex-direction:column;">
    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
    <div class="input"><label>SKU</label><input type="text" name="sku" value="<?= e($item['sku'] ?? '') ?>" required></div>
    <div class="input"><label>Coins</label><input type="number" min="1" name="coins" value="<?= (int)($item['coins'] ?? 0) ?>" required></div>
    <div class="input"><label>الحالة</label><label style="display:flex;align-items:center;gap:6px;"><input type="checkbox" name="enabled" value="1" <?= !empty($item['enabled'])?'checked':''; ?>> <span>مفعّل</span></label></div>
    <div>أضيفت: <?= fmt_dt($item['created_at'] ?? '') ?></div>
    <div style="display:flex; gap:8px;">
      <button class="btn" type="submit">حفظ</button>
      <a href="products.php" class="btn secondary">إلغاء</a>
    </div>
  </form>
</div>

<?php require $INC_DIR . '/footer.php'; ?>
