<?php
// wesaladmin/billing/products.php
declare(strict_types=1);

/* ===== detect location & bootstrap ===== */
if (isset($_GET['dbg'])) { ini_set('display_errors','1'); error_reporting(E_ALL); }

$IN_BILLING_DIR = (basename(__DIR__) === 'billing'); // true لو الملف داخل wesaladmin/billing/
$CFG_PATH       = $IN_BILLING_DIR ? __DIR__ . '/config.php' : __DIR__ . '/config.php';
$INC_DIR        = $IN_BILLING_DIR ? __DIR__ . '/inc'        : __DIR__ . '/inc';
$LINK_PREFIX    = $IN_BILLING_DIR ? '../'                       : ''; // للروابط إلى ملفات بالجذر

require_once $CFG_PATH;
require_once $INC_DIR . '/auth.php';
require_login();
/* ======================================= */

/* ---------------- CSRF ---------------- */
if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }

/* -------------- Helpers --------------- */
if (!function_exists('e')) {
  function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}
function fmt_dt(?string $s): string {
  if (!$s) return '';
  $t = strtotime($s); if ($t<=0) return e($s);
  return date('Y-m-d H:i', $t);
}

$pdo = db();
$msg = null; $err = null;

/* ---------------- Actions -------------- */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action = $_POST['action'] ?? '';
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.';
  } else try {
    if ($action === 'create') {
      $sku    = trim($_POST['sku']   ?? '');
      $coins  = (int)($_POST['coins'] ?? 0);
      $enabled = isset($_POST['enabled']) ? 1 : 0;

      if ($sku === '' || $coins <= 0) throw new Exception('الرجاء إدخال SKU وقيمة كوين صحيحة.');
      $st = $pdo->prepare("INSERT INTO billing_google_products (sku, coins, enabled) VALUES (?, ?, ?)");
      $st->execute([$sku, $coins, $enabled]);
      $msg = 'تم إضافة الباقة.';
    }
    elseif ($action === 'toggle') {
      $id = (int)($_POST['id'] ?? 0);
      if ($id <= 0) throw new Exception('مُعرّف غير صالح.');
      $cur = (int)$pdo->query("SELECT enabled FROM billing_google_products WHERE id=".(int)$id)->fetchColumn();
      $new = $cur ? 0 : 1;
      $st = $pdo->prepare("UPDATE billing_google_products SET enabled=? WHERE id=?");
      $st->execute([$new, $id]);
      $msg = $new ? 'تم تفعيل الباقة.' : 'تم تعطيل الباقة.';
    }
    elseif ($action === 'delete') {
      $id = (int)($_POST['id'] ?? 0);
      if ($id <= 0) throw new Exception('مُعرّف غير صالح.');
      // امنع حذف باقة لها إيصالات
      $sku = $pdo->query("SELECT sku FROM billing_google_products WHERE id=".(int)$id)->fetchColumn();
      if (!$sku) throw new Exception('العنصر غير موجود.');
      $cnt = (int)$pdo->prepare("SELECT COUNT(*) FROM billing_google_receipts WHERE sku=?")->execute([$sku]) ?: 0;
      $st2 = $pdo->prepare("SELECT COUNT(*) FROM billing_google_receipts WHERE sku=?");
      $st2->execute([$sku]);
      $has = (int)$st2->fetchColumn();
      if ($has > 0) throw new Exception('لا يمكن حذف باقة لديها مشتريات مسجلة.');
      $pdo->prepare("DELETE FROM billing_google_products WHERE id=? LIMIT 1")->execute([$id]);
      $msg = 'تم حذف الباقة.';
    }
  } catch (Throwable $e) {
    $err = $e->getMessage();
  }
}

/* -------------- Filters / Paging -------------- */
$q        = trim($_GET['q'] ?? '');       // بحث في sku
$enabledF = $_GET['enabled'] ?? '';       // '', '0', '1'
$minCoins = (int)($_GET['min_coins'] ?? 0);
$maxCoins = (int)($_GET['max_coins'] ?? 0);
$page     = max(1, (int)($_GET['page'] ?? 1));
$perPage  = 50;
$offset   = ($page - 1) * $perPage;

$where = "1=1"; $params = [];
if ($q !== '') { $where .= " AND sku LIKE ?"; $params[] = "%$q%"; }
if ($enabledF === '0' || $enabledF === '1') { $where .= " AND enabled=?"; $params[] = (int)$enabledF; }
if ($minCoins > 0) { $where .= " AND coins >= ?"; $params[] = $minCoins; }
if ($maxCoins > 0 && $maxCoins >= $minCoins) { $where .= " AND coins <= ?"; $params[] = $maxCoins; }

$total = 0;
$stc = $pdo->prepare("SELECT COUNT(*) FROM billing_google_products WHERE $where");
$stc->execute($params);
$total = (int)$stc->fetchColumn();
$pages = max(1, (int)ceil($total / $perPage));

$rows = [];
$sql = "SELECT * FROM billing_google_products WHERE $where ORDER BY id DESC LIMIT $perPage OFFSET $offset";
$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];

/* -------------- Render ------------------ */
$PAGE_TITLE = "Google Play — الباقات";
require $INC_DIR . '/header.php';
require $INC_DIR . '/sidebar.php';
?>
<style>
:root{
  --bg:#0b1220; --panel:#0f172a; --text:#e5e7eb; --muted:#9ca3af;
  --border:#1f2937; --brand:#3b82f6; --danger:#ef4444; --success:#22c55e;
}
*{box-sizing:border-box}
html{direction:rtl}
body{background:var(--bg);color:var(--text);font:16px/1.6 system-ui,-apple-system,"Segoe UI",Roboto,"Tajawal","Cairo",Arial}
a{color:#93c5fd;text-decoration:none}
a:hover{text-decoration:underline}
.card{background:var(--panel);border:1px solid var(--border);border-radius:12px;padding:12px}
.btn{display:inline-flex;align-items:center;gap:8px;padding:10px 14px;border-radius:10px;background:var(--brand);color:#fff;border:1px solid transparent;cursor:pointer}
.btn:hover{opacity:.95}
.btn.secondary{background:transparent;color:var(--text);border-color:var(--border)}
.btn.sm{padding:6px 10px;font-size:14px}
.badge{display:inline-block;padding:2px 8px;border-radius:999px;border:1px solid var(--border);font-size:12px}
.table{width:100%;border-collapse:separate;border-spacing:0;background:var(--panel);border:1px solid var(--border);border-radius:12px;overflow:hidden;table-layout:fixed}
.table td,.table th{padding:10px 12px;border-bottom:1px solid var(--border);vertical-align:middle;text-align:start}
.table thead th{background:#0b1220;color:var(--text);font-weight:700;position:sticky;top:0;z-index:3}
.table-wrap{max-height:70vh;overflow:auto;position:relative}
.form .input{display:flex;flex-direction:column;gap:6px}
.form input,.form select{background:#0b132a;border:1px solid var(--border);color:#fff;border-radius:10px;padding:10px 12px}
.products-page .col-id{width:70px}
.products-page .col-sku{width:320px}
.products-page .col-coins{width:120px}
.products-page .col-enabled{width:120px}
.products-page .col-created{width:180px}
.products-page .col-actions{width:240px}
</style>

<div class="products-page">
  <div class="card" style="margin-bottom:16px;">
    <form method="get" class="form" style="display:flex;gap:12px;align-items:flex-end;flex-wrap:wrap">
      <div class="input" style="min-width:220px;">
        <label>بحث في SKU</label>
        <input type="text" name="q" value="<?= e($q) ?>" placeholder="مثال: coins_100">
      </div>
      <div class="input">
        <label>الحالة</label>
        <select name="enabled">
          <option value=""<?= $enabledF===''?' selected':''; ?>>الكل</option>
          <option value="1"<?= $enabledF==='1'?' selected':''; ?>>مفعّل</option>
          <option value="0"<?= $enabledF==='0'?' selected':''; ?>>معطّل</option>
        </select>
      </div>
      <div class="input">
        <label>أدنى كوين</label>
        <input type="number" min="0" name="min_coins" value="<?= $minCoins>0?(int)$minCoins:'' ?>">
      </div>
      <div class="input">
        <label>أقصى كوين</label>
        <input type="number" min="0" name="max_coins" value="<?= $maxCoins>0?(int)$maxCoins:'' ?>">
      </div>
      <button class="btn sm" type="submit">بحث</button>
      <?php if ($q!=='' || $enabledF!=='' || $minCoins>0 || $maxCoins>0): ?>
        <a class="btn sm secondary" href="products.php">مسح الفلاتر</a>
      <?php endif; ?>
      <div style="margin-inline-start:auto; opacity:.9;">إجمالي: <b><?= $total ?></b></div>
    </form>

    <?php if ($msg): ?><div class="badge" style="border-color:var(--success); display:block; margin-top:12px;"><?= e($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="badge" style="border-color:var(--danger); display:block; margin-top:12px;"><?= e($err) ?></div><?php endif; ?>
  </div>

  <div class="card" style="margin-bottom:16px;">
    <h3 style="margin:0 0 10px 0;">إضافة باقة جديدة</h3>
    <form method="post" class="form" style="display:flex; gap:12px; align-items:end; flex-wrap:wrap;">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="create">
      <div class="input"><label>SKU</label><input type="text" name="sku" required placeholder="مثال: coins_100"></div>
      <div class="input"><label>Coins</label><input type="number" name="coins" min="1" required></div>
      <div class="input"><label>مفعّل؟</label><label style="display:flex;align-items:center;gap:6px;"><input type="checkbox" name="enabled" value="1" checked> <span>نعم</span></label></div>
      <button class="btn sm" type="submit">إضافة</button>
    </form>
  </div>

  <div class="card">
    <div class="table-wrap">
      <table class="table">
        <colgroup>
          <col class="col-id"><col class="col-sku"><col class="col-coins"><col class="col-enabled"><col class="col-created"><col class="col-actions">
        </colgroup>
        <thead>
          <tr>
            <th>#</th>
            <th>SKU</th>
            <th>Coins</th>
            <th>الحالة</th>
            <th>أضيفت</th>
            <th>إجراءات</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $r): ?>
            <tr>
              <td><?= (int)$r['id'] ?></td>
              <td><a href="products_edit.php?id=<?= (int)$r['id'] ?>" style="text-decoration:underline;"><?= e($r['sku']) ?></a></td>
              <td><?= (int)$r['coins'] ?></td>
              <td>
                <span class="badge" style="border-color:<?= (int)$r['enabled']? 'var(--success)':'var(--danger)' ?>">
                  <?= (int)$r['enabled'] ? 'مفعّل' : 'معطّل' ?>
                </span>
              </td>
              <td><?= fmt_dt($r['created_at'] ?? '') ?></td>
              <td style="display:flex; gap:8px; flex-wrap:nowrap;">
                <a class="btn sm secondary" href="products_edit.php?id=<?= (int)$r['id'] ?>">تعديل</a>
                <form method="post">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                  <input type="hidden" name="action" value="toggle">
                  <button class="btn sm" type="submit"><?= (int)$r['enabled'] ? 'تعطيل' : 'تفعيل' ?></button>
                </form>
                <form method="post" onsubmit="return confirm('هل تريد حذف هذه الباقة؟ سيتم الرفض إذا وُجدت مشتريات لها.');">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                  <input type="hidden" name="action" value="delete">
                  <button class="btn sm" type="submit" style="background:var(--danger);">حذف</button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if (!$rows): ?>
            <tr><td colspan="6" style="text-align:center; opacity:.8;">لا توجد باقات</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <?php if ($pages > 1): ?>
      <div style="display:flex; gap:8px; margin-top:12px; flex-wrap:wrap;">
        <?php for($p=1;$p<=$pages;$p++):
          $url = 'products.php?page='.$p
               .($q!=='' ? '&q='.urlencode($q) : '')
               .($enabledF!=='' ? '&enabled='.$enabledF : '')
               .($minCoins>0 ? '&min_coins='.$minCoins : '')
               .($maxCoins>0 ? '&max_coins='.$maxCoins : '');
          $is = $p===$page; ?>
          <a href="<?= e($url) ?>" class="btn sm <?= $is ? '' : 'secondary' ?>"<?= $is?' style="pointer-events:none; opacity:.8;"':''; ?>><?= $p ?></a>
        <?php endfor; ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<?php require $INC_DIR . '/footer.php'; ?>
