<?php
// admin/moments_edit.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }
if (!function_exists('e')) { function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }

$pdo = db();
$id  = (int)($_GET['id'] ?? 0);
if ($id <= 0) redirect('moments.php');

$msg=null; $err=null;

/* جلب المنشور */
$st = $pdo->prepare("SELECT * FROM `moment_posts` WHERE `id`=? LIMIT 1");
$st->execute([$id]);
$post = $st->fetch();
if (!$post) redirect('moments.php');

/* جلب التصنيفات */
$catOptions = [];
try {
  $catsRaw = $pdo->query("SELECT * FROM `moment_categories` ORDER BY `id` ASC")->fetchAll();
  foreach ($catsRaw as $c) {
    $catOptions[(int)$c['id']] = (string)($c['name'] ?? ($c['title'] ?? ('#'.$c['id'])));
  }
} catch (Throwable $e) {}

/* حفظ */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.';
  } else {
    $content = trim($_POST['content_text'] ?? '');
    $image   = trim($_POST['image_url'] ?? '');
    $user_id = (int)($_POST['user_id'] ?? 0);
    $cat_id  = (int)($_POST['category_id'] ?? 0);
    $deleted = (int)($_POST['is_deleted'] ?? 0) === 1 ? 1 : 0;

    $image = $image !== '' ? $image : null;

    try {
      $sql = "UPDATE `moment_posts`
              SET `content_text`=?, `image_url`=?, `user_id`=?, `category_id`=?, `is_deleted`=?
              WHERE `id`=? LIMIT 1";
      $pdo->prepare($sql)->execute([$content,$image,$user_id,$cat_id,$deleted,$id]);

      $msg = 'تم الحفظ بنجاح.';
      $st = $pdo->prepare("SELECT * FROM `moment_posts` WHERE `id`=? LIMIT 1");
      $st->execute([$id]);
      $post = $st->fetch();
    } catch (Throwable $e) {
      $err = 'حدث خطأ أثناء الحفظ.';
    }
  }
}

$PAGE_TITLE = "تعديل منشور #{$id}";
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';
?>
  <div class="card" style="max-width:900px;">
    <h1>تعديل منشور #<?= (int)$post['id'] ?></h1>
    <?php if ($msg): ?><div class="alert" style="border-color:#22c55e;"><?= e($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>

    <form class="form" method="post">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">

      <div class="grid cols-2">
        <div class="input" style="grid-column:1 / -1;">
          <label>نص المنشور</label>
          <input name="content_text" value="<?= e($post['content_text'] ?? '') ?>" required>
        </div>

        <div class="input">
          <label>صاحب المنشور (user_id)</label>
          <input type="number" name="user_id" value="<?= (int)($post['user_id'] ?? 0) ?>">
        </div>

        <div class="input">
          <label>التصنيف</label>
          <select name="category_id" style="padding:10px 12px;border-radius:10px;border:1px solid var(--border);background:#0b1220;color:var(--text);">
            <option value="0" <?= ((int)($post['category_id'] ?? 0)===0)?'selected':'' ?>>بدون</option>
            <?php foreach ($catOptions as $cid=>$cname): ?>
              <option value="<?= (int)$cid ?>" <?= ((int)($post['category_id'] ?? 0)===$cid)?'selected':'' ?>><?= e($cname) ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="input">
          <label>حالة الحذف</label>
          <select name="is_deleted" style="padding:10px 12px;border-radius:10px;border:1px solid var(--border);background:#0b1220;color:var(--text);">
            <option value="0" <?= ((int)($post['is_deleted'] ?? 0)===0)?'selected':'' ?>>نشط</option>
            <option value="1" <?= ((int)($post['is_deleted'] ?? 0)===1)?'selected':'' ?>>محذوف</option>
          </select>
        </div>

        <div class="input" style="grid-column:1 / -1;">
          <label>صورة المنشور (URL)</label>
          <input name="image_url" value="<?= e($post['image_url'] ?? '') ?>">
        </div>
      </div>

      <div style="display:flex;gap:8px;margin-top:8px;">
        <button class="btn" type="submit">حفظ</button>
        <a class="btn secondary" href="moments.php">رجوع للقائمة</a>
      </div>
    </form>
  </div>
<?php require __DIR__ . '/inc/footer.php'; ?>
