<?php
// admin/login.php
declare(strict_types=1);
require_once __DIR__ . '/config.php';

$err = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email_or_user = trim($_POST['email_user'] ?? '');
  $pass = $_POST['password'] ?? '';

  if ($email_or_user === '' || $pass === '') {
    $err = 'فضلاً أدخل البريد/المستخدم وكلمة المرور.';
  } else {
    $pdo = db();

    // جرّب admincp أولاً
    $st = $pdo->prepare("SELECT id,username,email,full_name,password_hash,role,is_active FROM admincp WHERE (email=? OR username=?) LIMIT 1");
    $st->execute([$email_or_user, $email_or_user]);
    $row = $st->fetch();

    $found = false;
    if ($row && (int)$row['is_active'] === 1 && password_verify($pass, $row['password_hash'])) {
      $found = true;
      $pdo->prepare("UPDATE admincp SET last_login_at=NOW() WHERE id=?")->execute([$row['id']]);
      $_SESSION['auth'] = [
        'type' => 'admincp',
        'id'   => (int)$row['id'],
        'name' => $row['full_name'] ?: $row['username'],
        'role' => $row['role'] ?: 'superadmin'
      ];
    }

    // إن لم يوجد، جرّب teamcp
    if (!$found) {
      $st = $pdo->prepare("SELECT id,username,email,full_name,password_hash,role,is_active FROM teamcp WHERE (email=? OR username=?) LIMIT 1");
      $st->execute([$email_or_user, $email_or_user]);
      $row = $st->fetch();
      if ($row && (int)$row['is_active'] === 1 && password_verify($pass, $row['password_hash'])) {
        $found = true;
        $pdo->prepare("UPDATE teamcp SET last_login_at=NOW() WHERE id=?")->execute([$row['id']]);
        $_SESSION['auth'] = [
          'type' => 'teamcp',
          'id'   => (int)$row['id'],
          'name' => $row['full_name'] ?: $row['username'],
          'role' => $row['role'] ?: 'staff'
        ];
      }
    }

    if ($found) {
      redirect('index.php');
    } else {
      $err = 'بيانات الدخول غير صحيحة أو الحساب غير مُفعل.';
    }
  }
}

$PAGE_TITLE = "تسجيل الدخول";
require __DIR__ . '/inc/header.php';
?>
<div class="content" style="max-width:520px;margin:40px auto;">
  <div class="card">
    <h1>تسجيل الدخول</h1>
    <?php if ($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>
    <form class="form" method="post" action="">
      <div class="input">
        <label>البريد الإلكتروني أو اسم المستخدم</label>
        <input type="text" name="email_user" autocomplete="username" required>
      </div>
      <div class="input">
        <label>كلمة المرور</label>
        <input type="password" name="password" autocomplete="current-password" required>
      </div>
      <button class="btn" type="submit">دخول</button>
    </form>
  </div>
</div>
<?php require __DIR__ . '/inc/footer.php'; ?>
