<?php
// admin/join_stats.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

/* Debug اختياري: join_stats.php?dbg=1 */
if (isset($_GET['dbg'])) { ini_set('display_errors','1'); error_reporting(E_ALL); }

if (!function_exists('e')) { function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }
function fmt_dt(?string $s): string { $t=strtotime((string)$s); return $t>0?date('Y-m-d H:i',$t):''; }

$pdo = db();

/* فلاتر */
$q     = trim($_GET['q'] ?? '');      // بحث بالاسم/الـ UID
$from  = trim($_GET['from'] ?? '');
$to    = trim($_GET['to'] ?? '');
$page  = max(1,(int)($_GET['page'] ?? 1));
$per   = 50;
$off   = ($page-1)*$per;

/* الشرط */
$where="1=1"; $params=[];
if ($q!==''){ $where.=" AND (jr.room_uid LIKE ? OR r.name LIKE ?)"; $kw="%$q%"; array_push($params,$kw,$kw); }
if ($from!==''){ $where.=" AND jr.created_at >= ?"; $params[]=$from." 00:00:00"; }
if ($to!==''){ $where.=" AND jr.created_at <= ?"; $params[]=$to." 23:59:59"; }

/* إجمالي عدد الغرف بعد التجميع */
$total = 0;
try{
  $st=$pdo->prepare("SELECT COUNT(*) FROM (
                        SELECT jr.room_uid
                        FROM join_room jr
                        LEFT JOIN rooms r ON r.uid = jr.room_uid
                        WHERE $where
                        GROUP BY jr.room_uid
                      ) x");
  $st->execute($params); $total=(int)$st->fetchColumn();
}catch(Throwable $e){}
$pages=max(1,(int)ceil($total/$per));

/* بيانات التجميع */
$rows=[];
try{
  $sql="SELECT jr.room_uid,
               COUNT(*) AS total_joins,
               COUNT(DISTINCT jr.user_uid) AS unique_users,
               MIN(jr.created_at) AS first_join,
               MAX(jr.created_at) AS last_join,
               r.id AS room_id, r.name AS room_name, r.owner_uid,
               uo.username AS owner_name
        FROM join_room jr
        LEFT JOIN rooms r   ON r.uid = jr.room_uid
        LEFT JOIN users uo  ON uo.uid = r.owner_uid
        WHERE $where
        GROUP BY jr.room_uid, r.id, r.name, r.owner_uid, uo.username
        ORDER BY total_joins DESC
        LIMIT $per OFFSET $off";
  $st=$pdo->prepare($sql); $st->execute($params); $rows=$st->fetchAll(PDO::FETCH_ASSOC) ?: [];
}catch(Throwable $e){}

$PAGE_TITLE="إحصائيات الانضمام";
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';
?>
<style>
.jstats .table{width:100%;border-collapse:separate;border-spacing:0;background:var(--panel);border:1px solid var(--border);border-radius:12px;overflow:hidden;table-layout:fixed}
.jstats .table td,.jstats .table th{padding:10px 12px;border-bottom:1px solid var(--border);vertical-align:middle;text-align:start}
.jstats .table thead th{background:#0b1220;color:var(--text);font-weight:700;position:sticky;top:0;z-index:3;box-shadow:inset 0 -1px 0 var(--border)}
.jstats .table tbody tr:nth-child(even) td{background:rgba(255,255,255,.015)}
.jstats .table tbody tr:hover td{background:rgba(59,130,246,.08)}
.jstats .table-wrap{max-height:70vh;overflow:auto;position:relative}
.jstats .td-center{text-align:center}
.jstats .ellipsis{max-width:260px;display:inline-block;overflow:hidden;white-space:nowrap;text-overflow:ellipsis}
.jstats .badge{display:inline-block;padding:2px 8px;border-radius:999px;border:1px solid var(--border);font-size:12px}
.jstats .badge.ok{border-color:#22c55e}
.jstats .col-rank{width:70px}.jstats .col-room{width:320px}.jstats .col-uid{width:200px}.jstats .col-owner{width:220px}
.jstats .col-tot{width:110px}.jstats .col-uniq{width:120px}.jstats .col-first{width:170px}.jstats .col-last{width:170px}
</style>

<div class="jstats">
  <div class="card" style="margin-bottom:16px;">
    <form method="get" class="form" style="display:flex;gap:12px;align-items:flex-end;flex-wrap:wrap;">
      <div class="input" style="min-width:260px;flex:1;">
        <label>ابحث بالاسم أو Room UID</label>
        <input type="text" name="q" value="<?= e($q) ?>" placeholder="اسم الغرفة أو UID">
      </div>
      <div class="input">
        <label>من</label>
        <input type="date" name="from" value="<?= e($from) ?>">
      </div>
      <div class="input">
        <label>إلى</label>
        <input type="date" name="to" value="<?= e($to) ?>">
      </div>
      <button class="btn" type="submit">تصفية</button>
      <?php if ($q!=='' || $from!=='' || $to!==''): ?>
        <a class="btn secondary" href="join_stats.php">مسح الفلاتر</a>
      <?php endif; ?>
      <div style="margin-inline-start:auto;opacity:.9;">غرف: <b><?= $total ?></b></div>
    </form>
  </div>

  <div class="card">
    <div class="table-wrap">
      <table class="table">
        <colgroup>
          <col class="col-rank"><col class="col-room"><col class="col-uid"><col class="col-owner">
          <col class="col-tot"><col class="col-uniq"><col class="col-first"><col class="col-last">
        </colgroup>
        <thead>
          <tr>
            <th class="td-center">#</th>
            <th>الغرفة</th>
            <th>Room UID</th>
            <th>المالك</th>
            <th>إجمالي الانضمامات</th>
            <th>مستخدمون فريدون</th>
            <th>أول انضمام</th>
            <th>آخر انضمام</th>
          </tr>
        </thead>
        <tbody>
          <?php $rank = $off + 1; foreach ($rows as $r): ?>
            <tr>
              <td class="td-center"><?= $rank++ ?></td>
              <td>
                <?php if (!empty($r['room_name'])): ?>
                  <a class="ellipsis" href="rooms.php?q=<?= urlencode($r['room_uid']) ?>" title="<?= e($r['room_uid']) ?>" style="text-decoration:underline;">
                    <?= e($r['room_name']) ?>
                  </a>
                <?php else: ?>
                  <span class="ellipsis" title="<?= e($r['room_uid']) ?>"><?= e($r['room_uid']) ?></span>
                <?php endif; ?>
              </td>
              <td class="td-center"><span class="badge"><?= e($r['room_uid']) ?></span></td>
              <td>
                <?php if (!empty($r['owner_name'])): ?>
                  <span class="ellipsis" title="<?= e($r['owner_uid'] ?? '') ?>"><?= e($r['owner_name']) ?></span>
                <?php else: ?>
                  <span class="ellipsis small"><?= e($r['owner_uid'] ?? '') ?></span>
                <?php endif; ?>
              </td>
              <td class="td-center"><b><?= (int)$r['total_joins'] ?></b></td>
              <td class="td-center"><span class="badge ok"><?= (int)$r['unique_users'] ?></span></td>
              <td><?= fmt_dt($r['first_join'] ?? '') ?></td>
              <td><?= fmt_dt($r['last_join'] ?? '') ?></td>
            </tr>
          <?php endforeach; ?>
          <?php if (!$rows): ?><tr><td colspan="8" style="text-align:center;opacity:.8;">لا توجد بيانات</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>

    <?php if ($pages>1): ?>
      <div style="display:flex;gap:8px;margin-top:12px;flex-wrap:wrap;">
        <?php for($p=1;$p<=$pages;$p++):
          $url='join_stats.php?page='.$p
               .($q!==''?'&q='.urlencode($q):'')
               .($from!==''?'&from='.$from:'')
               .($to!==''?'&to='.$to:'');
          $is=$p===$page; ?>
          <a href="<?= e($url) ?>" class="btn sm <?= $is?'':'secondary' ?>"<?= $is?' style="pointer-events:none;opacity:.8;"':''; ?>><?= $p ?></a>
        <?php endfor; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
<?php require __DIR__ . '/inc/footer.php'; ?>
