<?php
// admin/join_log.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

/* Debug اختياري: join_log.php?dbg=1 */
if (isset($_GET['dbg'])) { ini_set('display_errors','1'); error_reporting(E_ALL); }

/* -------------- Helpers --------------- */
if (!function_exists('e')) {
  function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}
function fmt_dt(?string $s): string {
  if (!$s) return '';
  $t = strtotime((string)$s); return $t>0 ? date('Y-m-d H:i', $t) : '';
}

$pdo = db();

/* --------- Filters / Search / Paging -------- */
$q       = trim($_GET['q'] ?? '');
$roomUID = trim($_GET['room_uid'] ?? '');
$userUID = trim($_GET['user_uid'] ?? '');
$from    = trim($_GET['from'] ?? '');   // YYYY-MM-DD
$to      = trim($_GET['to'] ?? '');     // YYYY-MM-DD
$page    = max(1, (int)($_GET['page'] ?? 1));
$perPage = 50;
$offset  = ($page - 1) * $perPage;

/* شرط البحث */
$where = "1=1"; $params = [];
if ($q !== '') {
  $where .= " AND (jr.room_uid LIKE ? OR jr.user_uid LIKE ? OR u.username LIKE ? OR u.email LIKE ? OR r.name LIKE ?)";
  $kw = "%$q%"; array_push($params,$kw,$kw,$kw,$kw,$kw);
}
if ($roomUID !== '') { $where .= " AND jr.room_uid = ?"; $params[] = $roomUID; }
if ($userUID !== '') { $where .= " AND jr.user_uid = ?"; $params[] = $userUID; }
if ($from !== '')    { $where .= " AND jr.created_at >= ?"; $params[] = $from." 00:00:00"; }
if ($to !== '')      { $where .= " AND jr.created_at <= ?"; $params[] = $to." 23:59:59"; }

/* إجمالي النتائج */
$total = 0;
try {
  $st = $pdo->prepare("SELECT COUNT(*)
                       FROM join_room jr
                       LEFT JOIN users u ON u.uid = jr.user_uid
                       LEFT JOIN rooms r ON r.uid = jr.room_uid
                       WHERE $where");
  $st->execute($params);
  $total = (int)$st->fetchColumn();
} catch (Throwable $e) { /* لا شيء */ }
$pages = max(1, (int)ceil($total / $perPage));

/* جلب الصفحة */
$rows = [];
try {
  $sql = "SELECT jr.id, jr.room_uid, jr.user_uid, jr.created_at,
                 u.id AS user_id, u.username AS user_name, u.email AS user_email,
                 r.id AS room_id, r.name AS room_name
          FROM join_room jr
          LEFT JOIN users u ON u.uid = jr.user_uid
          LEFT JOIN rooms r ON r.uid = jr.room_uid
          WHERE $where
          ORDER BY jr.created_at DESC, jr.id DESC
          LIMIT $perPage OFFSET $offset";
  $st = $pdo->prepare($sql); $st->execute($params); $rows = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];
} catch (Throwable $e) { $rows = []; }

$PAGE_TITLE = "سجل الانضمام";
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';
?>
<style>
.jlog .table{width:100%;border-collapse:separate;border-spacing:0;background:var(--panel);border:1px solid var(--border);border-radius:12px;overflow:hidden;table-layout:fixed}
.jlog .table td,.jlog .table th{padding:10px 12px;border-bottom:1px solid var(--border);vertical-align:middle;text-align:start}
.jlog .table thead th{background:#0b1220;color:var(--text);font-weight:700;position:sticky;top:0;z-index:3;box-shadow:inset 0 -1px 0 var(--border)}
.jlog .table tbody tr:nth-child(even) td{background:rgba(255,255,255,.015)}
.jlog .table tbody tr:hover td{background:rgba(59,130,246,.08)}
.jlog .table-wrap{max-height:70vh;overflow:auto;position:relative}
.jlog .td-center{text-align:center}
.jlog .ellipsis{max-width:260px;display:inline-block;overflow:hidden;white-space:nowrap;text-overflow:ellipsis}
.jlog .badge{display:inline-block;padding:2px 8px;border-radius:999px;border:1px solid var(--border);font-size:12px}
.jlog .col-id{width:60px}.jlog .col-room{width:260px}.jlog .col-user{width:240px}.jlog .col-uids{width:220px}.jlog .col-date{width:170px}
</style>

<div class="jlog">
  <div class="card" style="margin-bottom:16px;">
    <form method="get" class="form" style="display:flex;gap:12px;align-items:flex-end;flex-wrap:wrap;">
      <div class="input" style="min-width:240px;flex:1;">
        <label>بحث (الغرفة/المستخدم/الاسم/الإيميل)</label>
        <input type="text" name="q" value="<?= e($q) ?>" placeholder="room uid / user uid / name / email">
      </div>
      <div class="input">
        <label>Room UID</label>
        <input name="room_uid" value="<?= e($roomUID) ?>">
      </div>
      <div class="input">
        <label>User UID</label>
        <input name="user_uid" value="<?= e($userUID) ?>">
      </div>
      <div class="input">
        <label>من</label>
        <input type="date" name="from" value="<?= e($from) ?>">
      </div>
      <div class="input">
        <label>إلى</label>
        <input type="date" name="to" value="<?= e($to) ?>">
      </div>
      <button class="btn" type="submit">بحث</button>
      <?php if ($q!=='' || $roomUID!=='' || $userUID!=='' || $from!=='' || $to!==''): ?>
        <a class="btn secondary" href="join_log.php">مسح الفلاتر</a>
      <?php endif; ?>
      <div style="margin-inline-start:auto;opacity:.9;">إجمالي: <b><?= $total ?></b> سِجل</div>
    </form>
  </div>

  <div class="card">
    <div class="table-wrap">
      <table class="table">
        <colgroup>
          <col class="col-id"><col class="col-room"><col class="col-user"><col class="col-uids"><col class="col-date">
        </colgroup>
        <thead>
          <tr>
            <th class="td-center">#</th>
            <th>الغرفة</th>
            <th>المستخدم</th>
            <th>UIDs</th>
            <th>التاريخ</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $r): ?>
            <tr>
              <td class="td-center"><?= (int)$r['id'] ?></td>
              <td>
                <?php if (!empty($r['room_name'])): ?>
                  <a class="ellipsis" href="rooms.php?q=<?= urlencode($r['room_uid']) ?>" title="<?= e($r['room_uid']) ?>" style="text-decoration:underline;">
                    <?= e($r['room_name']) ?>
                  </a>
                <?php else: ?>
                  <span class="ellipsis" title="<?= e($r['room_uid']) ?>"><?= e($r['room_uid']) ?></span>
                <?php endif; ?>
              </td>
              <td>
                <?php if (!empty($r['user_name'])): ?>
                  <span class="ellipsis" title="<?= e($r['user_email'] ?? '') ?>"><?= e($r['user_name']) ?></span>
                <?php else: ?>
                  <span class="ellipsis">UID: <?= e($r['user_uid']) ?></span>
                <?php endif; ?>
              </td>
              <td class="td-center">
                <span class="badge">Room: <?= e($r['room_uid']) ?></span>
                <span class="badge">User: <?= e($r['user_uid']) ?></span>
              </td>
              <td title="<?= e($r['created_at'] ?? '') ?>"><?= fmt_dt($r['created_at'] ?? '') ?></td>
            </tr>
          <?php endforeach; ?>
          <?php if (!$rows): ?><tr><td colspan="5" style="text-align:center;opacity:.8;">لا توجد بيانات</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>

    <?php if ($pages>1): ?>
      <div style="display:flex;gap:8px;margin-top:12px;flex-wrap:wrap;">
        <?php for($p=1;$p<=$pages;$p++):
          $url='join_log.php?page='.$p
              .($q!==''?'&q='.urlencode($q):'')
              .($roomUID!==''?'&room_uid='.urlencode($roomUID):'')
              .($userUID!==''?'&user_uid='.urlencode($userUID):'')
              .($from!==''?'&from='.$from:'')
              .($to!==''?'&to='.$to:'');
          $is=$p===$page; ?>
          <a href="<?= e($url) ?>" class="btn sm <?= $is?'':'secondary' ?>"<?= $is?' style="pointer-events:none;opacity:.8;"':''; ?>><?= $p ?></a>
        <?php endfor; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
<?php require __DIR__ . '/inc/footer.php'; ?>
