<?php
// admin/inc/sidebar.php

// دالة الهروب إن لم تكن موجودة
if (!function_exists('e')) {
  function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}

// اسم الملف/المسار الحالي لتمييز العنصر النشط وفتح المجموعة
$__active = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH) ?: $_SERVER['PHP_SELF']);

// روابط بسيطة (خارج المجموعات)
$nav = [
  ['icon' => '🏠', 'label' => 'الرئيسية',   'href' => 'index.php'],
  ['icon' => '👤', 'label' => 'المستخدمون', 'href' => 'users.php'],
  ['icon' => '🔔', 'label' => 'الإشعارات',  'href' => 'fcm_send.php'],
];

/* ==== تعريف صفحات كل مجموعة ==== */
$__rooms_pages    = ['rooms.php','join_stats.php','join_log.php'];

$__moments_pages  = [
  'moments.php','moments_edit.php',
  'comments.php','comments_edit.php',
  'moment_categories.php',
  'post_reports.php',
];

$__gifts_pages    = ['gifts.php','gifts_add.php','gift_categories.php','gift_transactions.php'];
$__staff_pages    = ['staff.php','staff_add.php'];
$__emoji_pages    = ['emojis.php','emojis_add.php','emoji_categories.php'];
$__banners_pages  = ['banners.php','banners_add.php'];
$__settings_pages = ['app_settings.php'];
$__agents_pages   = ['agents.php','agents_edit.php','agents_credit.php','agent_rate.php','agents_stats.php'];
$__support_pages  = ['support.php'];

/* ✅ العائلات */
$__families_pages = ['families.php', 'families_edit.php', 'families_stats.php'];

/* ✅ الشحن (Google Play) */
$__billing_pages = ['products.php','products_edit.php','receipts.php'];

/* ✅ المتجر (من جذر الأدمن) — أضفنا صفحات أصناف المتجر */
$__store_pages = [
  'items.php','items_edit.php','orders.php','user_items.php',
  'store_categories.php','store_categories_edit.php'
];

/* ==== هل نفتح المجموعة؟ ==== */
$open_rooms    = in_array($__active, $__rooms_pages, true);
$open_moments  = in_array($__active, $__moments_pages, true);
$open_gifts    = in_array($__active, $__gifts_pages, true);
$open_staff    = in_array($__active, $__staff_pages, true);
$open_emoji    = in_array($__active, $__emoji_pages, true);
$open_banners  = in_array($__active, $__banners_pages, true);
$open_settings = in_array($__active, $__settings_pages, true);
$open_agents   = in_array($__active, $__agents_pages, true);
$open_support  = in_array($__active, $__support_pages, true);
/* ✅ فتح مجموعة العائلات */
$open_families = in_array($__active, $__families_pages, true);
/* ✅ فتح مجموعة الشحن */
$open_billing  = in_array($__active, $__billing_pages, true);
/* ✅ فتح مجموعة المتجر */
$open_store    = in_array($__active, $__store_pages, true);
?>
<aside class="sidebar" id="sidebar">
  <div class="sidebar-title">القائمة</div>

  <style>
    .menu .menu-item { border:1px solid transparent; display:flex; gap:10px; padding:10px 12px; border-radius:10px; }
    .menu .menu-item.active { background:rgba(59,130,246,.12); border-color:#3b82f6; }
    .sidebar .nav-group{margin:6px 0;border:1px solid var(--border);border-radius:10px;background:var(--panel)}
    .sidebar .nav-group summary{display:flex;align-items:center;gap:10px;padding:10px 12px;cursor:pointer;user-select:none;list-style:none}
    .sidebar .nav-group summary::-webkit-details-marker{display:none}
    .sidebar .nav-group .chev{margin-inline-start:auto;transition:transform .2s}
    .sidebar .nav-group[open] .chev{transform:rotate(-90deg)}
    .sidebar .submenu{display:flex;flex-direction:column;gap:6px;padding:8px 10px 10px 10px}
    .sidebar .submenu .menu-item{padding-inline-start:28px;border-radius:8px}
    .mi-icon{width:1.25rem;text-align:center}
  </style>

  <nav class="menu">
    <!-- روابط مستقلة -->
    <?php foreach ($nav as $item): ?>
      <?php $isActive = ($__active === basename($item['href'])); ?>
      <a class="menu-item<?= $isActive ? ' active' : '' ?>" href="<?= e($item['href']) ?>">
        <span class="mi-icon"><?= e($item['icon']) ?></span>
        <span class="mi-label"><?= e($item['label']) ?></span>
      </a>
    <?php endforeach; ?>

    <!-- ✅ قسم العائلات (تحت الروابط الأساسية مباشرة) -->
    <details class="nav-group" <?= $open_families ? 'open' : '' ?>>
      <summary><span>👨‍👩‍👧‍👦</span><span>العائلات</span><span class="chev">‹</span></summary>
      <div class="submenu">
        <a href="families.php"
           class="menu-item<?= in_array($__active, ['families.php','families_edit.php'], true) ? ' active' : '' ?>">
          <span class="mi-icon">👪</span><span class="mi-label">قائمة العائلات</span>
        </a>
        <a href="families_stats.php" class="menu-item<?= ($__active==='families_stats.php') ? ' active' : '' ?>">
          <span class="mi-icon">📊</span><span class="mi-label">إحصائيات العائلات</span>
        </a>
        <!-- ملاحظة: صفحة التفاصيل تحتاج باراميتر ?id= -->
        <a href="families_edit.php" class="menu-item<?= ($__active==='families_edit.php') ? ' active' : '' ?>" title="تحتاج ?id=">
          <span class="mi-icon">✏️</span><span class="mi-label">تفاصيل/تعديل</span>
        </a>
      </div>
    </details>

    <!-- ✅ خدمة العملاء -->
    <details class="nav-group" <?= $open_support ? 'open' : '' ?>>
      <summary><span>💬</span><span>خدمة العملاء</span><span class="chev">‹</span></summary>
      <div class="submenu">
        <a href="support.php" class="menu-item<?= ($__active==='support.php') ? ' active' : '' ?>">
          <span class="mi-icon">📨</span><span class="mi-label">صندوق الرسائل</span>
        </a>
      </div>
    </details>

    <!-- ✅ وكلاء الشحن -->
    <details class="nav-group" <?= $open_agents ? 'open' : '' ?>>
      <summary><span>🤝</span><span>وكلاء الشحن</span><span class="chev">‹</span></summary>
      <div class="submenu">
        <a href="agents.php" class="menu-item<?= ($__active==='agents.php') ? ' active' : '' ?>">
          <span class="mi-icon">📑</span><span class="mi-label">قائمة الوكلاء</span>
        </a>
        <a href="agents_edit.php" class="menu-item<?= ($__active==='agents_edit.php') ? ' active' : '' ?>">
          <span class="mi-icon">➕</span><span class="mi-label">إضافة/تعديل وكيل</span>
        </a>
        <a href="agents_credit.php" class="menu-item<?= ($__active==='agents_credit.php') ? ' active' : '' ?>" title="تحتاج ?id=">
          <span class="mi-icon">💳</span><span class="mi-label">شحن/خصم رصيد وكيل</span>
        </a>
        <a href="agent_rate.php" class="menu-item<?= ($__active==='agent_rate.php') ? ' active' : '' ?>">
          <span class="mi-icon">📈</span><span class="mi-label">سعر تحويل الكوين</span>
        </a>
        <a href="agents_stats.php" class="menu-item<?= ($__active==='agents_stats.php') ? ' active' : '' ?>">
          <span class="mi-icon">📊</span><span class="mi-label">إحصائيات الوكلاء</span>
        </a>
      </div>
    </details>

    <!-- ✅ الشحن (ينتقل مباشرة إلى wesaladmin/products.php و wesaladmin/receipts.php) -->
    <details class="nav-group" <?= $open_billing ? 'open' : '' ?>>
      <summary><span>💳</span><span>الشحن</span><span class="chev">‹</span></summary>
      <div class="submenu">
        <a href="products.php"
           class="menu-item<?= in_array($__active, ['products.php','products_edit.php'], true) ? ' active' : '' ?>">
          <span class="mi-icon">🛒</span><span class="mi-label">الباقات (Google Play)</span>
        </a>
        <a href="receipts.php"
           class="menu-item<?= ($__active==='receipts.php') ? ' active' : '' ?>">
          <span class="mi-icon">🧾</span><span class="mi-label">إيصالات الشراء</span>
        </a>
      </div>
    </details>

    <!-- ✅ المتجر -->
    <details class="nav-group" <?= $open_store ? 'open' : '' ?>>
      <summary><span>🛍️</span><span>المتجر</span><span class="chev">‹</span></summary>
      <div class="submenu">
        <a href="store_categories.php"
           class="menu-item<?= in_array($__active, ['store_categories.php','store_categories_edit.php'], true) ? ' active' : '' ?>">
          <span class="mi-icon">🗂️</span><span class="mi-label">أصناف المتجر</span>
        </a>
        <a href="items.php"
           class="menu-item<?= in_array($__active, ['items.php','items_edit.php'], true) ? ' active' : '' ?>">
          <span class="mi-icon">📦</span><span class="mi-label">عناصر المتجر</span>
        </a>
        <a href="items_edit.php"
           class="menu-item<?= ($__active==='items_edit.php') ? ' active' : '' ?>">
          <span class="mi-icon">➕</span><span class="mi-label">إضافة/تعديل عنصر</span>
        </a>
        <a href="orders.php"
           class="menu-item<?= ($__active==='orders.php') ? ' active' : '' ?>">
          <span class="mi-icon">🧾</span><span class="mi-label">أوامر المتجر</span>
        </a>
        <a href="user_items.php"
           class="menu-item<?= ($__active==='user_items.php') ? ' active' : '' ?>">
          <span class="mi-icon">🎟️</span><span class="mi-label">عناصر المستخدمين</span>
        </a>
      </div>
    </details>

    <!-- الغرف -->
    <details class="nav-group" <?= $open_rooms ? 'open' : '' ?>>
      <summary><span>🎙️</span><span>الغرف</span><span class="chev">‹</span></summary>
      <div class="submenu">
        <a href="rooms.php"      class="menu-item<?= ($__active==='rooms.php')      ? ' active' : '' ?>"><span class="mi-icon">📄</span><span class="mi-label">قائمة الغرف</span></a>
        <a href="join_stats.php" class="menu-item<?= ($__active==='join_stats.php') ? ' active' : '' ?>"><span class="mi-icon">📊</span><span class="mi-label">إحصائيات الانضمام</span></a>
        <a href="join_log.php"   class="menu-item<?= ($__active==='join_log.php')   ? ' active' : '' ?>"><span class="mi-icon">🕘</span><span class="mi-label">سجل الانضمام</span></a>
      </div>
    </details>

    <!-- اللحظات + تبليغات البوستات -->
    <details class="nav-group" <?= $open_moments ? 'open' : '' ?>>
      <summary><span>🕘</span><span>اللحظات</span><span class="chev">‹</span></summary>
      <div class="submenu">
        <a href="moments.php"            class="menu-item<?= in_array($__active,['moments.php','moments_edit.php'], true) ? ' active' : '' ?>"><span class="mi-icon">🖼️</span><span class="mi-label">البوستات</span></a>
        <a href="comments.php"           class="menu-item<?= in_array($__active,['comments.php','comments_edit.php'], true) ? ' active' : '' ?>"><span class="mi-icon">💬</span><span class="mi-label">تعليقات</span></a>
        <a href="moment_categories.php"  class="menu-item<?= ($__active==='moment_categories.php') ? ' active' : '' ?>"><span class="mi-icon">🗂️</span><span class="mi-label">فئات اللحظات</span></a>
        <a href="post_reports.php"       class="menu-item<?= ($__active==='post_reports.php') ? ' active' : '' ?>"><span class="mi-icon">🚩</span><span class="mi-label">تبليغات البوستات</span></a>
      </div>
    </details>

    <!-- البنرات -->
    <details class="nav-group" <?= $open_banners ? 'open' : '' ?>>
      <summary><span>🏷️</span><span>البنرات</span><span class="chev">‹</span></summary>
      <div class="submenu">
        <a href="banners.php"     class="menu-item<?= ($__active==='banners.php')     ? ' active' : '' ?>"><span class="mi-icon">🖼️</span><span class="mi-label">عرض البنرات</span></a>
        <a href="banners_add.php" class="menu-item<?= ($__active==='banners_add.php') ? ' active' : '' ?>"><span class="mi-icon">➕</span><span class="mi-label">إضافة/رفع بانر</span></a>
      </div>
    </details>

    <!-- الهدايا -->
    <details class="nav-group" <?= $open_gifts ? 'open' : '' ?>>
      <summary><span>🎁</span><span>الهدايا</span><span class="chev">‹</span></summary>
      <div class="submenu">
        <a href="gifts.php"             class="menu-item<?= ($__active==='gifts.php')             ? ' active' : '' ?>"><span class="mi-icon">🎁</span><span class="mi-label">كل الهدايا</span></a>
        <a href="gifts_add.php"         class="menu-item<?= ($__active==='gifts_add.php')         ? ' active' : '' ?>"><span class="mi-icon">➕</span><span class="mi-label">إضافة هدية</span></a>
        <a href="gift_categories.php"   class="menu-item<?= ($__active==='gift_categories.php')   ? ' active' : '' ?>"><span class="mi-icon">🗂️</span><span class="mi-label">فئات الهدايا</span></a>
        <a href="gift_transactions.php" class="menu-item<?= ($__active==='gift_transactions.php') ? ' active' : '' ?>"><span class="mi-icon">📜</span><span class="mi-label">سجل الهدايا</span></a>
      </div>
    </details>

    <!-- الموظفون -->
    <details class="nav-group" <?= $open_staff ? 'open' : '' ?>>
      <summary><span>🧑‍💼</span><span>الموظفون</span><span class="chev">‹</span></summary>
      <div class="submenu">
        <a href="staff.php"     class="menu-item<?= ($__active==='staff.php')     ? ' active' : '' ?>"><span class="mi-icon">👥</span><span class="mi-label">قائمة الموظفين</span></a>
        <a href="staff_add.php" class="menu-item<?= ($__active==='staff_add.php') ? ' active' : '' ?>"><span class="mi-icon">➕</span><span class="mi-label">إضافة موظف</span></a>
      </div>
    </details>

    <!-- الايموجي -->
    <details class="nav-group" <?= $open_emoji ? 'open' : '' ?>>
      <summary><span>😊</span><span>الايموجي</span><span class="chev">‹</span></summary>
      <div class="submenu">
        <a href="emojis.php"            class="menu-item<?= ($__active==='emojis.php' || $__active==='emojis_add.php') ? ' active' : '' ?>"><span class="mi-icon">📚</span><span class="mi-label">عرض الايموجي</span></a>
        <a href="emoji_categories.php"  class="menu-item<?= ($__active==='emoji_categories.php')  ? ' active' : '' ?>"><span class="mi-icon">🗂️</span><span class="mi-label">فئات الايموجي</span></a>
        <a href="emojis_add.php"        class="menu-item<?= ($__active==='emojis_add.php')        ? ' active' : '' ?>"><span class="mi-icon">➕</span><span class="mi-label">رفع/إضافة ايموجي</span></a>
      </div>
    </details>
    
    <!-- ⚙️ الإعدادات -->
    <details class="nav-group" <?= $open_settings ? 'open' : '' ?>>
      <summary><span>⚙️</span><span>الإعدادات</span><span class="chev">‹</span></summary>
      <div class="submenu">
        <a href="app_settings.php" class="menu-item<?= ($__active==='app_settings.php') ? ' active' : '' ?>">
          <span class="mi-icon">🛠️</span>
          <span class="mi-label">إعدادات التطبيق</span>
        </a>
      </div>
    </details>

    <!-- صفحات ثابتة -->
    <a href="pages_edit.php" class="menu-item<?= ($__active==='pages_edit.php') ? ' active' : '' ?>">
      <span class="mi-icon">📄</span>
      <span class="mi-label">سياسة الخصوصية</span>
    </a>
  </nav>
</aside>

<main class="content">
