<?php
// admin/inc/auth.php
declare(strict_types=1);
require_once __DIR__ . '/../config.php';

// التحقق من تسجيل الدخول
function require_login(): void {
  if (!current_user()) redirect('login.php');
}

// التحقق من الصلاحية (مرن للمستقبل)
// يستخدم جدول الأدوار/الصلاحيات لاحقًا
function can(string $perm): bool {
  $u = current_user();
  if (!$u) return false;

  // سوبر أدمن له كل شيء
  if (($u['type'] ?? '') === 'admincp' && ($u['role'] ?? '') === 'superadmin') return true;

  // TODO: اربط بـ role_permissions / team_permissions
  // مؤقتًا: أرجع true للعرض فقط
  return true;
}
