<?php
// admin/gifts_add.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }
if (!function_exists('e')) { function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }

$pdo = db();
$msg = null; $err = null;
$id  = (int)($_GET['id'] ?? 0);

/* أصل الروابط المطلقة للدومين */
function app_origin(): string {
  if (defined('BASE_URL') && BASE_URL) {
    return rtrim((string)BASE_URL, '/');
  }
  return 'https://battle-party.com';
}

/* فحوصات أعمدة اختيارية إن لم تكن موجودة بعد في قاعدة البيانات */
function col_exists(PDO $pdo, string $table, string $col): bool {
  try {
    $st = $pdo->prepare("SHOW COLUMNS FROM `$table` LIKE ?");
    $st->execute([$col]);
    return (bool)$st->fetchColumn();
  } catch (Throwable $e) {
    return false;
  }
}

/* ◀︎ مسارات الرفع الخاصة بالهدايا ▶︎ */
$UPLOAD_DIR  = __DIR__ . '/../files/gifts';               // على السيرفر: /voicechat/files/gifts
$PUBLIC_BASE = app_origin() . '/voicechat/files/gifts/';  // الرابط المطلق الذي يُخزن بقاعدة البيانات

/* فئات الهدايا */
$cats = $pdo->query("SELECT id, name FROM gift_categories ORDER BY sort_order ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);

/* تحميل السطر عند التعديل */
$row = [
  'id' => 0,
  'name' => '',
  'category_id' => 0,
  'image_url' => '',
  'video_url' => '',
  'price' => 0,
  'sort_order' => 0,
  'is_active' => 1,
  'fullscreen' => 0,
  'video_crop_right' => null, // نسبة قص يمين الفيديو (0..0.9)
];

if ($id > 0) {
  $st = $pdo->prepare("SELECT * FROM gift_items WHERE id=? LIMIT 1");
  $st->execute([$id]);
  if ($r = $st->fetch(PDO::FETCH_ASSOC)) {
    $row['id']              = (int)($r['id'] ?? 0);
    $row['name']            = (string)($r['name'] ?? '');
    $row['category_id']     = (int)($r['category_id'] ?? 0);
    $row['image_url']       = (string)($r['image_url'] ?? '');
    $row['video_url']       = (string)($r['video_url'] ?? '');
    $row['price']           = (int)($r['price'] ?? 0);
    $row['sort_order']      = (int)($r['sort_order'] ?? 0);
    $row['is_active']       = (int)($r['is_active'] ?? 1);
    $row['fullscreen']      = (int)($r['fullscreen'] ?? 0);
    $row['video_crop_right']= isset($r['video_crop_right']) ? (float)$r['video_crop_right'] : null;
  }
}

/* حفظ */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.';
  } else {
    $id          = (int)($_POST['id'] ?? 0);
    $name        = trim((string)($_POST['name'] ?? ''));
    $cat         = (int)($_POST['category_id'] ?? 0);
    $img         = trim((string)($_POST['image_url'] ?? ''));
    $vid         = trim((string)($_POST['video_url'] ?? '')); // رابط فيديو
    $price       = (int)($_POST['price'] ?? 0);
    $sort        = (int)($_POST['sort_order'] ?? 0);
    $active      = (int)($_POST['is_active'] ?? 1);
    $fullscreen  = (int)($_POST['fullscreen'] ?? 0);
    $cropInput   = trim((string)($_POST['video_crop_right'] ?? ''));

    // تحويل المسارات النسبية إلى مطلقة
    $to_abs = function(string $u): string {
      if ($u !== '' && preg_match('#^/voicechat/#', $u) && !preg_match('#^https?://#i', $u)) {
        return rtrim(app_origin(), '/') . $u;
      }
      return $u;
    };
    $img = $to_abs($img);
    $vid = $to_abs($vid);

    // قص يمين الفيديو (0..0.9) أو NULL
    $crop = null;
    if ($cropInput !== '') {
      $crop = (float)$cropInput;
      if ($crop < 0) $crop = 0;
      if ($crop > 0.9) $crop = 0.9;
    }

    /* رفع ملف (صورة/Lottie) اختياري */
    if (!empty($_FILES['image_file']['name']) && $_FILES['image_file']['error'] === UPLOAD_ERR_OK) {
      $fn  = $_FILES['image_file']['name'];
      $tmp = $_FILES['image_file']['tmp_name'];
      $ext = strtolower(pathinfo($fn, PATHINFO_EXTENSION));

      // المسموح: صور + Lottie (.json) + dotLottie (.lottie)
      $allowed_ext = ['png','webp','jpg','jpeg','gif','json','lottie'];
      if (!in_array($ext, $allowed_ext, true)) {
        $err = 'صيغة الملف غير مسموحة. المسموح: PNG / WEBP / JPG / GIF / JSON / LOTTIE.'; goto out;
      }

      // فحص MIME للـ JSON/LOTTIE
      if (function_exists('finfo_open')) {
        $f = finfo_open(FILEINFO_MIME_TYPE);
        if ($f) {
          $mime = finfo_file($f, $tmp);
          finfo_close($f);
          if ($ext === 'json' && !in_array($mime, ['application/json','text/plain','application/octet-stream'], true)) {
            $err='ملف Lottie (.json) يجب أن يكون JSON صالحاً.'; goto out;
          }
          if ($ext === 'lottie' && !in_array($mime, ['application/zip','application/x-zip-compressed','application/octet-stream'], true)) {
            $err='ملف dotLottie (.lottie) يجب أن يكون حزمة ZIP صالحة.'; goto out;
          }
        }
      }

      if (!is_dir($UPLOAD_DIR)) @mkdir($UPLOAD_DIR, 0775, true);
      $base = 'gift_'.time().'_'.bin2hex(random_bytes(3)).'.'.$ext;
      $dest = rtrim($UPLOAD_DIR,'/').'/'.$base;
      if (!move_uploaded_file($tmp, $dest)) { $err = 'فشل رفع الملف.'; goto out; }
      $img = rtrim($PUBLIC_BASE,'/') . '/' . $base;
    }

    /* رفع فيديو MP4 اختياري */
    if (!empty($_FILES['video_file']['name']) && $_FILES['video_file']['error'] === UPLOAD_ERR_OK) {
      $fn  = $_FILES['video_file']['name'];
      $tmp = $_FILES['video_file']['tmp_name'];
      $ext = strtolower(pathinfo($fn, PATHINFO_EXTENSION));

      if ($ext !== 'mp4') { $err = 'صيغة الفيديو يجب أن تكون MP4.'; goto out; }

      if (function_exists('finfo_open')) {
        $f = finfo_open(FILEINFO_MIME_TYPE);
        if ($f) {
          $mime = finfo_file($f, $tmp);
          finfo_close($f);
          // بعض السيرفرات تُرجع application/octet-stream — نقبلها
          if (!in_array($mime, ['video/mp4','application/octet-stream'], true)) {
            $err='ملف الفيديو ليس MP4 صالحاً.'; goto out;
          }
        }
      }

      if (!is_dir($UPLOAD_DIR)) @mkdir($UPLOAD_DIR, 0775, true);
      $base = 'gift_'.time().'_'.bin2hex(random_bytes(3)).'.mp4';
      $dest = rtrim($UPLOAD_DIR,'/').'/'.$base;
      if (!move_uploaded_file($tmp, $dest)) { $err = 'فشل رفع الفيديو.'; goto out; }
      $vid = rtrim($PUBLIC_BASE,'/') . '/' . $base; // مثال: https://battle-party.com/voicechat/files/gifts/gift_xxx.mp4
    }

    // تحقق الحقول
    if ($name === '') { $err='الاسم مطلوب.'; goto out; }
    if ($cat <= 0) { $err='اختر فئة.'; goto out; }
    // الآن نسمح بهدية فيديو فقط بدون صورة:
    if ($img === '' && $vid === '') { $err='يجب إدخال صورة/Lottie أو فيديو MP4.'; goto out; }
    if ($price < 0) $price = 0;

    // لو الأعمدة غير موجودة في الجدول، سنرجع لخيار حفظ الفيديو داخل image_url عند الضرورة
    $hasVideoCol = col_exists($pdo, 'gift_items', 'video_url');
    $hasFullCol  = col_exists($pdo, 'gift_items', 'fullscreen');
    $hasCropCol  = col_exists($pdo, 'gift_items', 'video_crop_right');

    // fallback: إن لم يوجد عمود video_url ونوع الوسيط هو mp4 ولم تُدخل صورة، خزّن الفيديو في image_url
    if (!$hasVideoCol && $img === '' && $vid !== '') {
      $img = $vid;
    }

    try {
      if ($id > 0) {
        // UPDATE ديناميكي حسب الأعمدة الموجودة
        $sets = ['name=?','category_id=?','image_url=?','price=?','sort_order=?','is_active=?'];
        $vals = [$name, $cat, $img, $price, $sort, $active];
        if ($hasVideoCol) { $sets[]='video_url=?'; $vals[]=$vid; }
        if ($hasFullCol)  { $sets[]='fullscreen=?'; $vals[]=$fullscreen; }
        if ($hasCropCol)  { $sets[]='video_crop_right=?'; $vals[]=$crop; }

        $sql = "UPDATE gift_items SET ".implode(',', $sets)." WHERE id=? LIMIT 1";
        $vals[] = $id;
        $pdo->prepare($sql)->execute($vals);
        $msg='تم التحديث.';
      } else {
        // INSERT ديناميكي حسب الأعمدة الموجودة
        $cols = ['name','category_id','image_url','price','sort_order','is_active'];
        $vals = [$name, $cat, $img, $price, $sort, $active];
        if ($hasVideoCol) { $cols[]='video_url'; $vals[]=$vid; }
        if ($hasFullCol)  { $cols[]='fullscreen'; $vals[]=$fullscreen; }
        if ($hasCropCol)  { $cols[]='video_crop_right'; $vals[]=$crop; }

        $sql = "INSERT INTO gift_items (".implode(',', $cols).") VALUES (".implode(',', array_fill(0, count($cols), '?')).")";
        $pdo->prepare($sql)->execute($vals);
        $msg='تمت الإضافة.';
      }

      // إعادة تحميل القيم
      if ($id > 0) {
        $st=$pdo->prepare("SELECT * FROM gift_items WHERE id=?"); $st->execute([$id]); $r=$st->fetch(PDO::FETCH_ASSOC);
        if ($r) {
          $row['id']              = (int)($r['id'] ?? 0);
          $row['name']            = (string)($r['name'] ?? '');
          $row['category_id']     = (int)($r['category_id'] ?? 0);
          $row['image_url']       = (string)($r['image_url'] ?? '');
          $row['video_url']       = (string)($r['video_url'] ?? '');
          $row['price']           = (int)($r['price'] ?? 0);
          $row['sort_order']      = (int)($r['sort_order'] ?? 0);
          $row['is_active']       = (int)($r['is_active'] ?? 1);
          $row['fullscreen']      = (int)($r['fullscreen'] ?? 0);
          $row['video_crop_right']= isset($r['video_crop_right']) ? (float)$r['video_crop_right'] : null;
        }
      } else {
        $row = [
          'id'=>0,'name'=>'','category_id'=>0,'image_url'=>'','video_url'=>'',
          'price'=>0,'sort_order'=>0,'is_active'=>1,'fullscreen'=>0,'video_crop_right'=>null
        ];
      }
    } catch (Throwable $e) {
      $err='تعذر الحفظ.';
    }
  }
}
out:

$PAGE_TITLE = ($row['id']? 'تعديل هدية #'.$row['id'] : 'إضافة هدية');
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';

/** مساعدين للتمييز */
function url_ext(string $url): string {
  $path = parse_url($url, PHP_URL_PATH) ?? '';
  return strtolower(pathinfo($path, PATHINFO_EXTENSION));
}
function file_is_lottie(string $url): bool {
  $ext = url_ext($url);
  return in_array($ext, ['json','lottie'], true);
}
function file_is_video(string $url): bool {
  $ext = url_ext($url);
  return $ext === 'mp4';
}
$hasVideoCol = col_exists($pdo, 'gift_items', 'video_url');
$hasFullCol  = col_exists($pdo, 'gift_items', 'fullscreen');
$hasCropCol  = col_exists($pdo, 'gift_items', 'video_crop_right');
?>
<style>
.gadd-page .hint{opacity:.8;font-size:12px}
.gadd-page .thumb{width:72px;height:72px;object-fit:contain;background:#0d111a;border:1px solid var(--border);border-radius:10px}
.gadd-page .lbadge{display:inline-block;padding:2px 6px;border:1px solid var(--border);border-radius:6px;font-size:12px}
.gadd-page .videobox{width:220px;max-width:100%;aspect-ratio:16/9;background:#0d111a;border:1px solid var(--border);border-radius:10px;display:flex;align-items:center;justify-content:center}
</style>

<div class="gadd-page">
  <div class="card" style="max-width:920px;">
    <h1 style="margin-top:0"><?= e($PAGE_TITLE) ?></h1>
    <?php if($msg): ?><div class="alert" style="border-color:#22c55e;"><?= e($msg) ?></div><?php endif; ?>
    <?php if($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>

    <form method="post" class="form" enctype="multipart/form-data">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="id" value="<?= (int)$row['id'] ?>">

      <div class="grid cols-2">
        <div class="input">
          <label>الاسم</label>
          <input name="name" value="<?= e($row['name']) ?>" required>
        </div>

        <div class="input">
          <label>الفئة</label>
          <select name="category_id" required>
            <option value="">اختر فئة…</option>
            <?php foreach($cats as $c): ?>
              <option value="<?= (int)$c['id'] ?>"<?= ((int)$row['category_id']===(int)$c['id'])?' selected':''; ?>><?= e($c['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="input">
          <label>الرابط المباشر (صورة أو Lottie)</label>
          <input name="image_url" value="<?= e($row['image_url']) ?>" placeholder="https://… (png/webp/jpg/gif/json/lottie)">
          <div class="hint">يمكن تركه فارغًا إذا استخدمت خانة رفع الملف بالأسفل. إن أدخلت مسارًا نسبيًا يبدأ بـ /voicechat/ سيتم تحويله تلقائيًا إلى رابط مطلق.</div>
        </div>

        <div class="input">
          <label>ملف (صورة أو Lottie)</label>
          <input type="file" name="image_file" accept=".png,.webp,.jpg,.jpeg,.gif,.json,.lottie">
          <div class="hint">يدعم: PNG / WEBP / JPG / GIF / JSON (Lottie) / LOTTIE (dotLottie).</div>
        </div>

        <!-- فيديو MP4 اختياري -->
        <div class="input">
          <label>رابط فيديو MP4 (اختياري)</label>
          <input name="video_url" value="<?= e($row['video_url']) ?>" placeholder="https://… (mp4)">
          <div class="hint">يمكن تركه فارغًا إذا استخدمت خانة رفع الفيديو بالأسفل. يُسمح باستخدام هدية فيديو فقط بدون صورة.</div>
        </div>

        <div class="input">
          <label>ملف فيديو MP4 (اختياري)</label>
          <input type="file" name="video_file" accept=".mp4,video/mp4">
          <div class="hint">الحجم الكبير قد يؤثر على سرعة التحميل لدى المستخدمين.</div>
        </div>

        <div class="input">
          <label>السعر (كوين)</label>
          <input type="number" name="price" value="<?= (int)$row['price'] ?>" min="0" step="1" required>
        </div>

        <div class="input">
          <label>الترتيب</label>
          <input type="number" name="sort_order" value="<?= (int)$row['sort_order'] ?>" step="1">
        </div>

        <div class="input">
          <label>الحالة</label>
          <select name="is_active">
            <option value="1"<?= ((int)$row['is_active']===1)?' selected':''; ?>>مفعل</option>
            <option value="0"<?= ((int)$row['is_active']===0)?' selected':''; ?>>معطّل</option>
          </select>
        </div>

        <div class="input">
          <label>عرض بملء الشاشة (للفيديو)</label>
          <?php if ($hasFullCol): ?>
            <select name="fullscreen">
              <option value="0"<?= ((int)$row['fullscreen']===0)?' selected':''; ?>>لا</option>
              <option value="1"<?= ((int)$row['fullscreen']===1)?' selected':''; ?>>نعم</option>
            </select>
          <?php else: ?>
            <select disabled>
              <option>غير متاح (أضف عمود fullscreen أولاً)</option>
            </select>
            <div class="hint">للتفعيل الكامل اقترح إضافة العمود: <code>ALTER TABLE gift_items ADD COLUMN fullscreen TINYINT(1) NOT NULL DEFAULT 0;</code></div>
          <?php endif; ?>
        </div>

        <div class="input">
          <label>قص يمين الفيديو % (0..0.9)</label>
          <?php if ($hasCropCol): ?>
            <input type="number" name="video_crop_right" step="0.01" min="0" max="0.9"
                   value="<?= is_null($row['video_crop_right']) ? '' : (float)$row['video_crop_right'] ?>"
                   placeholder="مثال: 0.18">
            <div class="hint">يُستخدم لإخفاء الهامش/الفراغ الأبيض في بعض الفيديوهات العمودية.</div>
          <?php else: ?>
            <input type="number" step="0.01" min="0" max="0.9" disabled placeholder="أضف عمود video_crop_right">
            <div class="hint">لإتاحة هذا الحقل أضف: <code>ALTER TABLE gift_items ADD COLUMN video_crop_right DECIMAL(4,2) DEFAULT NULL;</code></div>
          <?php endif; ?>
        </div>
      </div>

      <?php if($row['image_url'] || $row['video_url']): ?>
        <div style="margin-top:8px;display:flex;align-items:center;gap:16px;flex-wrap:wrap">
          <?php if ($row['image_url']): ?>
            <?php if (!file_is_lottie($row['image_url']) && !file_is_video($row['image_url'])): ?>
              <div>
                <img class="thumb" src="<?= e($row['image_url']) ?>" alt="">
                <div class="hint">معاينة الصورة الحالية</div>
              </div>
            <?php elseif (file_is_lottie($row['image_url'])): ?>
              <div>
                <span class="lbadge">ملف Lottie</span>
                <a href="<?= e($row['image_url']) ?>" target="_blank" rel="noopener">فتح المعاينة</a>
              </div>
            <?php else: // mp4 داخل image_url (حالة توافق قديمة) ?>
              <div>
                <div class="videobox">
                  <video src="<?= e($row['image_url']) ?>" controls muted style="max-width:100%;max-height:100%;border-radius:10px"></video>
                </div>
                <div class="hint">فيديو MP4 (محفوظ ضمن image_url)</div>
              </div>
            <?php endif; ?>
          <?php endif; ?>

          <?php if ($row['video_url']): ?>
            <div>
              <div class="videobox">
                <video src="<?= e($row['video_url']) ?>" controls muted style="max-width:100%;max-height:100%;border-radius:10px"></video>
              </div>
              <div class="hint">
                فيديو MP4 (video_url)
                <?php if (!is_null($row['video_crop_right'])): ?>
                  — قص يمين: <?= e((string)$row['video_crop_right']) ?>
                <?php endif; ?>
              </div>
            </div>
          <?php endif; ?>
        </div>
      <?php endif; ?>

      <div style="display:flex;gap:8px;margin-top:12px;">
        <button class="btn" type="submit"><?= $row['id']?'تحديث':'إضافة' ?></button>
        <a class="btn secondary" href="gifts.php">رجوع للقائمة</a>
      </div>
    </form>

    <?php if(!$hasVideoCol): ?>
      <div class="hint" style="margin-top:16px">
        <strong>ملاحظة:</strong> لتخزين روابط الفيديو بشكل منفصل يُنصح بإضافة الأعمدة التالية:
        <pre style="white-space:pre-wrap;background:#0d111a;color:#ddd;padding:8px;border-radius:8px;border:1px solid var(--border)">ALTER TABLE gift_items
  ADD COLUMN video_url VARCHAR(255) DEFAULT NULL,
  ADD COLUMN fullscreen TINYINT(1) NOT NULL DEFAULT 0,
  ADD COLUMN video_crop_right DECIMAL(4,2) DEFAULT NULL;</pre>
        إن لم تُضِف الأعمدة، سيحاول السكربت حفظ رابط MP4 داخل <code>image_url</code> عند الضرورة.
      </div>
    <?php endif; ?>
  </div>
</div>
<?php require __DIR__ . '/inc/footer.php'; ?>
