<?php
// admin/gift_transactions.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
if (!function_exists('e')) { function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }
function fmt_dt(?string $s): string { $t=strtotime((string)$s); return $t>0?date('Y-m-d H:i',$t):''; }

$pdo = db();

/* فلاتر */
$q       = trim($_GET['q'] ?? '');  // بحث عام في room_uid/meta
$giftId  = (int)($_GET['gift_id'] ?? 0);
$sender  = (int)($_GET['sender'] ?? 0);
$recv    = (int)($_GET['receiver'] ?? 0);
$page    = max(1,(int)($_GET['page'] ?? 1));
$perPage = 50;
$offset  = ($page-1)*$perPage;

/* أسماء الهدايا */
$giftNames=[];
try{ $res=$pdo->query("SELECT id,name FROM `gift_items` ORDER BY sort_order ASC, id ASC"); foreach($res?->fetchAll() ?? [] as $g) $giftNames[(int)$g['id']]=$g['name']; }catch(Throwable $e){}

/* شرط */
$where="1=1"; $params=[];
if ($q!==''){ $where.=" AND (gt.room_uid LIKE ? OR gt.meta LIKE ?)"; $params[]="%$q%"; $params[]="%$q%"; }
if ($giftId>0){ $where.=" AND gt.gift_id=?"; $params[]=$giftId; }
if ($sender>0){ $where.=" AND gt.sender_user_id=?"; $params[]=$sender; }
if ($recv>0){ $where.=" AND gt.receiver_user_id=?"; $params[]=$recv; }

/* إجمالي */
$st=$pdo->prepare("SELECT COUNT(*) FROM `gift_transactions` gt WHERE $where");
$st->execute($params); $total=(int)$st->fetchColumn();
$pages=max(1,(int)ceil($total/$perPage));

/* بيانات */
$sql="SELECT gt.id,gt.gift_id,gt.sender_user_id,gt.receiver_user_id,gt.room_uid,
             gt.quantity,gt.unit_price,gt.total_price,gt.meta,gt.created_at
      FROM `gift_transactions` gt
      WHERE $where
      ORDER BY gt.created_at DESC, gt.id DESC
      LIMIT $perPage OFFSET $offset";
$st=$pdo->prepare($sql); $st->execute($params);
$rows=$st->fetchAll();

$PAGE_TITLE="سجل الهدايا";
require __DIR__.'/inc/header.php';
require __DIR__.'/inc/sidebar.php';
?>
<style>
.glog .table{width:100%;border-collapse:separate;border-spacing:0;background:var(--panel);border:1px solid var(--border);border-radius:12px;overflow:hidden;table-layout:fixed}
.glog .table td,.glog .table th{padding:10px 12px;border-bottom:1px solid var(--border);vertical-align:middle;text-align:start}
.glog .table thead th{background:#0b1220;color:var(--text);font-weight:700;position:sticky;top:0;z-index:3;box-shadow:inset 0 -1px 0 var(--border)}
.glog .table tbody tr:nth-child(even) td{background:rgba(255,255,255,.015)}
.glog .table tbody tr:hover td{background:rgba(59,130,246,.08)}
.glog .table-wrap{max-height:70vh;overflow:auto;position:relative}
.glog .td-center{text-align:center}
.glog .ellipsis{max-width:260px;display:inline-block;overflow:hidden;white-space:nowrap;text-overflow:ellipsis}
.glog .badge{display:inline-block;padding:2px 8px;border-radius:999px;border:1px solid var(--border);font-size:12px}
.glog .badge.ok{border-color:#22c55e}
.glog .col-id{width:60px}.glog .col-gift{width:200px}.glog .col-users{width:220px}.glog .col-room{width:160px}
.glog .col-qty{width:80px}.glog .col-unit{width:110px}.glog .col-total{width:120px}.glog .col-time{width:170px}.glog .col-meta{width:280px}
</style>

<div class="glog">
  <div class="card" style="margin-bottom:16px;">
    <form method="get" class="form" style="display:flex;gap:12px;align-items:flex-end;flex-wrap:wrap;">
      <div class="input" style="min-width:240px;flex:1;">
        <label>بحث عام (الغرفة/الميتا)</label>
        <input type="text" name="q" value="<?= e($q) ?>" placeholder="room uid / meta">
      </div>
      <div class="input">
        <label>ID المُرسل</label>
        <input type="number" name="sender" value="<?= $sender>0?(int)$sender:'' ?>">
      </div>
      <div class="input">
        <label>ID المُستلم</label>
        <input type="number" name="receiver" value="<?= $recv>0?(int)$recv:'' ?>">
      </div>
      <div class="input">
        <label>الهدية</label>
        <select name="gift_id" style="padding:10px 12px;border-radius:10px;border:1px solid var(--border);background:#0b1220;color:var(--text);">
          <option value="0" <?= $giftId===0?'selected':'' ?>>الكل</option>
          <?php foreach($giftNames as $gid=>$name): ?>
            <option value="<?= (int)$gid ?>" <?= $giftId===$gid?'selected':'' ?>><?= e($name) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <button class="btn sm" type="submit">بحث</button>
      <?php if ($q!==''||$giftId>0||$sender>0||$recv>0): ?>
        <a class="btn sm secondary" href="gift_transactions.php">مسح الفلاتر</a>
      <?php endif; ?>
      <div style="margin-inline-start:auto;opacity:.9;">إجمالي: <b><?= $total ?></b> عملية</div>
    </form>
  </div>

  <div class="card">
    <div class="table-wrap">
      <table class="table">
        <colgroup>
          <col class="col-id"><col class="col-gift"><col class="col-users"><col class="col-room">
          <col class="col-qty"><col class="col-unit"><col class="col-total"><col class="col-time"><col class="col-meta">
        </colgroup>
        <thead>
          <tr>
            <th class="td-center">#</th>
            <th>الهدية</th>
            <th>المرسل ← المستلم</th>
            <th>الغرفة</th>
            <th>الكمية</th>
            <th>سعر الوحدة</th>
            <th>الإجمالي</th>
            <th>التاريخ</th>
            <th>Meta</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($rows as $r): ?>
            <tr>
              <td class="td-center"><?= (int)$r['id'] ?></td>
              <td><?= e($giftNames[(int)$r['gift_id']] ?? ('#'.(int)$r['gift_id'])) ?></td>
              <td class="td-center"><span class="badge">#<?= (int)$r['sender_user_id'] ?></span> ← <span class="badge ok">#<?= (int)$r['receiver_user_id'] ?></span></td>
              <td><span class="badge"><?= e($r['room_uid'] ?? '') ?></span></td>
              <td class="td-center"><?= (int)$r['quantity'] ?></td>
              <td class="td-center"><?= e((string)$r['unit_price']) ?></td>
              <td class="td-center"><b><?= e((string)$r['total_price']) ?></b></td>
              <td><?= fmt_dt($r['created_at'] ?? '') ?></td>
              <td title="<?= e($r['meta'] ?? '') ?>"><span class="ellipsis"><?= e($r['meta'] ?? '') ?></span></td>
            </tr>
          <?php endforeach; ?>
          <?php if(!$rows): ?><tr><td colspan="9" style="text-align:center;opacity:.8;">لا توجد عمليات</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>

    <?php if ($pages>1): ?>
      <div style="display:flex;gap:8px;margin-top:12px;flex-wrap:wrap;">
        <?php for($p=1;$p<=$pages;$p++):
          $url='gift_transactions.php?page='.$p
            .($q!==''?'&q='.urlencode($q):'')
            .($giftId>0?'&gift_id='.$giftId:'')
            .($sender>0?'&sender='.$sender:'')
            .($recv>0?'&receiver='.$recv:'');
          $is=$p===$page; ?>
          <a href="<?= e($url) ?>" class="btn sm <?= $is?'':'secondary' ?>"<?= $is?' style="pointer-events:none;opacity:.8;"':''; ?>><?= $p ?></a>
        <?php endfor; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
<?php require __DIR__.'/inc/footer.php'; ?>
