<?php
// families_stats.php  (يعمل سواءً كان داخل wesaladmin/ أو wesaladmin/family/)
declare(strict_types=1);

/* ===== detect location & bootstrap ===== */
if (isset($_GET['dbg'])) { ini_set('display_errors','1'); error_reporting(E_ALL); }

$IN_FAMILY_DIR = (basename(__DIR__) === 'family');
$ROOT_DIR      = $IN_FAMILY_DIR ? dirname(__DIR__) : __DIR__;
$CFG_PATH      = $ROOT_DIR . '/config.php';
$INC_DIR       = $ROOT_DIR . '/inc';
$LINK_PREFIX   = $IN_FAMILY_DIR ? '../' : '';

require_once $CFG_PATH;
require_once $INC_DIR . '/auth.php';
require_login();
/* ======================================= */

if (!function_exists('e')) {
  function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}
function fmt_dt(?string $s): string {
  if (!$s) return '';
  $t = strtotime($s); if ($t<=0) return e($s);
  return date('Y-m-d H:i', $t);
}

$pdo = db();

/* أرقام عامة */
$totFamilies = (int)$pdo->query("SELECT COUNT(*) FROM families")->fetchColumn();
$totMembers  = (int)$pdo->query("SELECT COUNT(*) FROM family_members")->fetchColumn();
$avgMembers  = $totFamilies ? round($totMembers / $totFamilies, 2) : 0.0;

/* أفضل 10 عائلات */
$top = $pdo->query("
  SELECT f.id, f.name, f.owner_uid, u.username AS owner_name, COALESCE(m.cnt,0) AS members
  FROM families f
  LEFT JOIN users u ON u.id = f.owner_uid
  LEFT JOIN ( SELECT family_id, COUNT(*) AS cnt FROM family_members GROUP BY family_id ) m
    ON m.family_id = f.id
  ORDER BY members DESC, f.id DESC
  LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC) ?: [];

/* أحدث 10 عائلات */
$latest = $pdo->query("
  SELECT f.id, f.name, f.owner_uid, f.created_at, u.username AS owner_name
  FROM families f LEFT JOIN users u ON u.id = f.owner_uid
  ORDER BY f.created_at DESC, f.id DESC
  LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC) ?: [];

/* -------------- Render ------------------ */
$PAGE_TITLE = "إحصائيات العائلات";
require $INC_DIR . '/header.php';
require $INC_DIR . '/sidebar.php';
?>
<style>
:root{ --bg:#0b1220; --panel:#0f172a; --text:#e5e7eb; --muted:#9ca3af; --border:#1f2937; --brand:#3b82f6; }
*{box-sizing:border-box} html{direction:rtl}
body{background:var(--bg);color:var(--text);font:16px/1.6 system-ui,-apple-system,"Segoe UI",Roboto,"Tajawal","Cairo",Arial}
a{color:#93c5fd;text-decoration:none} a:hover{text-decoration:underline}
.card{background:var(--panel);border:1px solid var(--border);border-radius:12px;padding:12px}
.k{font-size:28px;font-weight:800}
.table{width:100%;border-collapse:separate;border-spacing:0;background:var(--panel);border:1px solid var(--border);border-radius:12px;overflow:hidden}
.table td,.table th{padding:10px 12px;border-bottom:1px solid var(--border);vertical-align:middle;text-align:start}
.table thead th{background:#0b1220;color:var(--text);font-weight:700}
.cards{display:grid;grid-template-columns:repeat(3,1fr);gap:12px}
@media (max-width:900px){.cards{grid-template-columns:1fr}}
</style>

<div class="fstats">
  <div class="cards" style="margin-bottom:16px;">
    <div class="card"><div style="opacity:.8">إجمالي العائلات</div><div class="k"><?= $totFamilies ?></div></div>
    <div class="card"><div style="opacity:.8">إجمالي الأعضاء</div><div class="k"><?= $totMembers ?></div></div>
    <div class="card"><div style="opacity:.8">متوسط أعضاء لكل عائلة</div><div class="k"><?= $avgMembers ?></div></div>
  </div>

  <div class="card" style="margin-bottom:16px;">
    <h3 style="margin-top:0">أفضل 10 عائلات (حسب عدد الأعضاء)</h3>
    <table class="table">
      <thead><tr><th style="width:64px;">#</th><th>الاسم</th><th style="width:260px;">المالك</th><th style="width:120px;">الأعضاء</th></tr></thead>
      <tbody>
        <?php foreach($top as $r): ?>
          <?php
            $editHref = (file_exists(__DIR__.'/families_edit.php') ? 'families_edit.php' : (($IN_FAMILY_DIR ? '' : 'family/').'families_edit.php')) . '?id=' . (int)$r['id'];
          ?>
          <tr>
            <td><?= (int)$r['id'] ?></td>
            <td><a href="<?= e($editHref) ?>" style="text-decoration:underline;"><?= e($r['name'] ?? '') ?></a></td>
            <td>
              <?php if (!empty($r['owner_name'])): ?>
                <a href="<?= $LINK_PREFIX ?>users_edit.php?id=<?= (int)$r['owner_uid'] ?>" style="text-decoration:underline;"><?= e($r['owner_name']) ?></a>
              <?php else: ?>
                ID: <?= (int)$r['owner_uid'] ?>
              <?php endif; ?>
            </td>
            <td><?= (int)$r['members'] ?></td>
          </tr>
        <?php endforeach; ?>
        <?php if (!$top): ?>
          <tr><td colspan="4" style="text-align:center;opacity:.8;">لا توجد بيانات</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="card">
    <h3 style="margin-top:0">أحدث 10 عائلات</h3>
    <table class="table">
      <thead><tr><th style="width:64px;">#</th><th>الاسم</th><th style="width:260px;">المالك</th><th style="width:180px;">أُنشئت</th></tr></thead>
      <tbody>
        <?php foreach($latest as $r): ?>
          <?php
            $editHref = (file_exists(__DIR__.'/families_edit.php') ? 'families_edit.php' : (($IN_FAMILY_DIR ? '' : 'family/').'families_edit.php')) . '?id=' . (int)$r['id'];
          ?>
          <tr>
            <td><?= (int)$r['id'] ?></td>
            <td><a href="<?= e($editHref) ?>" style="text-decoration:underline;"><?= e($r['name'] ?? '') ?></a></td>
            <td>
              <?php if (!empty($r['owner_name'])): ?>
                <a href="<?= $LINK_PREFIX ?>users_edit.php?id=<?= (int)$r['owner_uid'] ?>" style="text-decoration:underline;"><?= e($r['owner_name']) ?></a>
              <?php else: ?>
                ID: <?= (int)$r['owner_uid'] ?>
              <?php endif; ?>
            </td>
            <td><?= fmt_dt($r['created_at'] ?? '') ?></td>
          </tr>
        <?php endforeach; ?>
        <?php if (!$latest): ?>
          <tr><td colspan="4" style="text-align:center;opacity:.8;">لا توجد بيانات</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require $INC_DIR . '/footer.php'; ?>
