<?php
// families_edit.php  (يعمل سواءً كان داخل wesaladmin/ أو wesaladmin/family/)
declare(strict_types=1);

/* ===== detect location & bootstrap ===== */
if (isset($_GET['dbg'])) { ini_set('display_errors','1'); error_reporting(E_ALL); }

$IN_FAMILY_DIR = (basename(__DIR__) === 'family');      // true لو الملف داخل wesaladmin/family/
$ROOT_DIR      = $IN_FAMILY_DIR ? dirname(__DIR__) : __DIR__;
$CFG_PATH      = $ROOT_DIR . '/config.php';
$INC_DIR       = $ROOT_DIR . '/inc';
$LINK_PREFIX   = $IN_FAMILY_DIR ? '../' : '';           // للروابط إلى ملفات بالجذر (users_edit.php مثلاً)

require_once $CFG_PATH;
require_once $INC_DIR . '/auth.php';
require_login();
/* ======================================= */

/* Helpers */
if (!function_exists('e')) {
  function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}
function fmt_dt(?string $s): string {
  if (!$s) return '';
  $t = strtotime($s); if ($t<=0) return e($s);
  return date('Y-m-d H:i', $t);
}

/* CSRF */
if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }

$pdo = db();
$id  = (int)($_GET['id'] ?? 0);

/* حدّد رابط صفحة القائمة حسب توفرها في نفس المجلد أو في مجلد family */
$LIST_HREF = file_exists(__DIR__ . '/families.php')
  ? 'families.php'
  : (($IN_FAMILY_DIR ? '' : 'family/') . 'families.php');

if ($id<=0) { header('Location: '.$LIST_HREF); exit; }

$msg=null; $err=null;

/* جلب بيانات العائلة */
$family = null;
$st = $pdo->prepare("SELECT f.*, u.username AS owner_name, u.email AS owner_email
                     FROM families f
                     LEFT JOIN users u ON u.id = f.owner_uid
                     WHERE f.id=? LIMIT 1");
$st->execute([$id]);
$family = $st->fetch(PDO::FETCH_ASSOC);
if (!$family) { $err='العائلة غير موجودة.'; }

/* إجراءات POST */
if ($_SERVER['REQUEST_METHOD']==='POST' && $family) {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.';
  } else {
    $action = $_POST['action'] ?? '';
    try {
      if ($action==='save_family') {
        $name = trim((string)($_POST['name'] ?? ''));
        $badge = trim((string)($_POST['badge_url'] ?? ''));
        $ann  = trim((string)($_POST['announcement'] ?? ''));
        $owner= (int)($_POST['owner_uid'] ?? (int)$family['owner_uid']);
        $allow= isset($_POST['allow_join']) ? 1 : 0;
        if ($name==='') throw new Exception('الاسم مطلوب.');
        $st = $pdo->prepare("UPDATE families SET name=?, badge_url=?, announcement=?, owner_uid=?, allow_join=? WHERE id=?");
        $st->execute([$name,$badge,$ann,$owner,$allow,$id]);
        $msg = 'تم حفظ البيانات.';
      } elseif ($action==='add_member') {
        $userId = (int)($_POST['user_id'] ?? 0);
        $role   = trim((string)($_POST['role'] ?? 'member'));
        if ($userId<=0) throw new Exception('ID عضو غير صالح.');
        $pdo->prepare("INSERT IGNORE INTO family_members (family_id,user_uid,role,joined_at) VALUES (?,?,?,NOW())")
            ->execute([$id,$userId,$role]);
        $msg = 'تم إضافة العضو.';
      } elseif ($action==='remove_member') {
        $userId = (int)($_POST['user_id'] ?? 0);
        $pdo->prepare("DELETE FROM family_members WHERE family_id=? AND user_uid=? LIMIT 1")->execute([$id,$userId]);
        $msg = 'تم إزالة العضو.';
      } elseif ($action==='set_role') {
        $userId = (int)($_POST['user_id'] ?? 0);
        $role   = trim((string)($_POST['role'] ?? 'member'));
        $pdo->prepare("UPDATE family_members SET role=? WHERE family_id=? AND user_uid=?")->execute([$role,$id,$userId]);
        $msg = 'تم تحديث دور العضو.';
      } elseif ($action==='transfer_owner') {
        $newOwner = (int)($_POST['new_owner_id'] ?? 0);
        if ($newOwner<=0) throw new Exception('ID مالك جديد غير صالح.');
        $pdo->prepare("UPDATE families SET owner_uid=? WHERE id=?")->execute([$newOwner,$id]);
        $msg = 'تم نقل الملكية.';
      }
    } catch (Throwable $e) {
      $err = $e->getMessage();
    }
    // إعادة جلب آخر نسخة
    $st = $pdo->prepare("SELECT f.*, u.username AS owner_name, u.email AS owner_email
                         FROM families f LEFT JOIN users u ON u.id = f.owner_uid
                         WHERE f.id=? LIMIT 1");
    $st->execute([$id]);
    $family = $st->fetch(PDO::FETCH_ASSOC);
  }
}

/* أعضاء العائلة */
$members = [];
try {
  $st = $pdo->prepare("SELECT fm.user_uid, fm.role, fm.joined_at, u.username, u.email, u.avatar_url
                       FROM family_members fm
                       LEFT JOIN users u ON u.id = fm.user_uid
                       WHERE fm.family_id=?
                       ORDER BY fm.joined_at DESC, fm.user_uid DESC
                       LIMIT 200");
  $st->execute([$id]);
  $members = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];
} catch (Throwable $e) {
  $err = $err ?: ('تعذّر جلب الأعضاء.' . (isset($_GET['dbg']) ? ' ('.$e->getMessage().')' : ''));
}

/* -------------- Render ------------------ */
$PAGE_TITLE = "تفاصيل العائلة #$id";
require $INC_DIR . '/header.php';
require $INC_DIR . '/sidebar.php';
?>
<style>
:root{ --bg:#0b1220; --panel:#0f172a; --text:#e5e7eb; --muted:#9ca3af; --border:#1f2937; --brand:#3b82f6; --danger:#ef4444; --success:#22c55e; }
*{box-sizing:border-box} html{direction:rtl}
body{background:var(--bg);color:var(--text);font:16px/1.6 system-ui,-apple-system,"Segoe UI",Roboto,"Tajawal","Cairo",Arial}
a{color:#93c5fd;text-decoration:none} a:hover{text-decoration:underline}
.card{background:var(--panel);border:1px solid var(--border);border-radius:12px;padding:12px}
.alert{border:1px solid var(--border);padding:10px 12px;border-radius:10px;background:#0b132a}
.btn{display:inline-flex;align-items:center;gap:8px;padding:10px 14px;border-radius:10px;background:var(--brand);color:#fff;border:1px solid transparent;cursor:pointer}
.btn:hover{opacity:.95}.btn.secondary{background:transparent;color:var(--text);border-color:var(--border)}.btn.sm{padding:6px 10px;font-size:14px}
.form .input{display:flex;flex-direction:column;gap:6px}
.form input[type="text"],.form input[type="number"],.form input[type="url"],.form select,.form textarea{background:#0b132a;border:1px solid var(--border);color:var(--text);border-radius:10px;padding:10px 12px}
.table{width:100%;border-collapse:separate;border-spacing:0;background:var(--panel);border:1px solid var(--border);border-radius:12px;overflow:hidden;table-layout:fixed}
.table td,.table th{padding:10px 12px;border-bottom:1px solid var(--border);vertical-align:middle;text-align:start}
.table thead th{background:#0b1220;color:var(--text);font-weight:700}
.table tbody tr:nth-child(even) td{background:rgba(255,255,255,.015)} .table tbody tr:hover td{background:rgba(59,130,246,.08)}
.grid{display:grid;grid-template-columns:1.1fr .9fr;gap:16px} @media (max-width:1100px){.grid{grid-template-columns:1fr}}
.avatar{width:36px;height:36px;border-radius:50%;object-fit:cover;border:1px solid var(--border);background:#111}
</style>

<div class="fedit">
  <?php if ($msg): ?><div class="alert" style="margin-bottom:12px; border-color:var(--success);"><?= e($msg) ?></div><?php endif; ?>
  <?php if ($err): ?><div class="alert" style="margin-bottom:12px; border-color:var(--danger);"><?= e($err) ?></div><?php endif; ?>

  <?php if ($family): ?>
  <div class="grid">
    <!-- بطاقة تعديل البيانات -->
    <div class="card">
      <form method="post" class="form">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="action" value="save_family">
        <div class="input">
          <label>اسم العائلة</label>
          <input type="text" name="name" value="<?= e($family['name'] ?? '') ?>" required>
        </div>
        <div class="input">
          <label>رابط الشعار (badge_url)</label>
          <input type="url" name="badge_url" value="<?= e($family['badge_url'] ?? '') ?>" placeholder="https://...">
        </div>
        <div class="input">
          <label>إعلان/وصف</label>
          <textarea name="announcement" rows="3" placeholder="نص مختصر..."><?= e($family['announcement'] ?? '') ?></textarea>
        </div>
        <div class="input">
          <label>ID المالك</label>
          <input type="number" name="owner_uid" value="<?= (int)$family['owner_uid'] ?>">
          <?php if (!empty($family['owner_name'])): ?>
            <div style="opacity:.8;margin-top:4px;">المالك الحالي: <b><?= e($family['owner_name']) ?></b> (<?= e($family['owner_email'] ?? '') ?>)</div>
          <?php endif; ?>
        </div>
        <div class="input">
          <label style="display:flex;gap:8px;align-items:center;">
            <input type="checkbox" name="allow_join" value="1"<?= (int)$family['allow_join']? ' checked':''; ?>>
            السماح بالانضمام
          </label>
        </div>
        <button class="btn" type="submit">حفظ</button>
      </form>

      <div class="hr" style="height:1px;background:var(--border);margin:14px 0;"></div>

      <form method="post" class="form" style="display:flex;gap:12px;align-items:flex-end;flex-wrap:wrap">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="action" value="transfer_owner">
        <div class="input">
          <label>نقل الملكية إلى ID</label>
          <input type="number" name="new_owner_id" min="1" placeholder="User ID">
        </div>
        <button class="btn sm" type="submit">نقل الملكية</button>
      </form>

      <div style="opacity:.8;margin-top:10px;">أُنشئت: <?= fmt_dt($family['created_at'] ?? '') ?></div>
    </div>

    <!-- بطاقة إدارة الأعضاء -->
    <div class="card">
      <h3 style="margin-top:0">أعضاء العائلة (<?= count($members) ?>)</h3>

      <form method="post" class="form" style="display:flex;gap:12px;align-items:flex-end;flex-wrap:wrap;margin-bottom:10px;">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="action" value="add_member">
        <div class="input">
          <label>ID العضو</label>
          <input type="number" name="user_id" min="1" required>
        </div>
        <div class="input">
          <label>الدور</label>
          <select name="role">
            <option value="member">عضو</option>
            <option value="admin">مشرف</option>
          </select>
        </div>
        <button class="btn sm" type="submit">إضافة</button>
      </form>

      <div class="table-wrap" style="max-height:58vh;overflow:auto;">
        <table class="table">
          <thead>
            <tr>
              <th style="width:64px;">ID</th>
              <th>المستخدم</th>
              <th style="width:120px;">الدور</th>
              <th style="width:160px;">انضمّ</th>
              <th style="width:240px;">إجراءات</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($members as $m): ?>
              <tr>
                <td><?= (int)$m['user_uid'] ?></td>
                <td>
                  <div style="display:flex;align-items:center;gap:10px;">
                    <?php if (!empty($m['avatar_url'])): ?>
                      <img class="avatar" src="<?= e($m['avatar_url']) ?>" alt="">
                    <?php endif; ?>
                    <?php if (!empty($m['username'])): ?>
                      <a href="<?= $LINK_PREFIX ?>users_edit.php?id=<?= (int)$m['user_uid'] ?>" style="text-decoration:underline;">
                        <?= e($m['username']) ?>
                      </a>
                      <span style="opacity:.7;margin-inline-start:6px;"><?= e($m['email'] ?? '') ?></span>
                    <?php else: ?>
                      <span>—</span>
                    <?php endif; ?>
                  </div>
                </td>
                <td>
                  <form method="post" style="display:flex;gap:6px;align-items:center;">
                    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                    <input type="hidden" name="action" value="set_role">
                    <input type="hidden" name="user_id" value="<?= (int)$m['user_uid'] ?>">
                    <select name="role">
                      <option value="member"<?= ($m['role']??'')==='member'?' selected':''; ?>>عضو</option>
                      <option value="admin"<?= ($m['role']??'')==='admin'?' selected':''; ?>>مشرف</option>
                    </select>
                    <button class="btn sm" type="submit">حفظ</button>
                  </form>
                </td>
                <td><?= fmt_dt($m['joined_at'] ?? '') ?></td>
                <td>
                  <form method="post" onsubmit="return confirm('إزالة هذا العضو من العائلة؟');">
                    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                    <input type="hidden" name="action" value="remove_member">
                    <input type="hidden" name="user_id" value="<?= (int)$m['user_uid'] ?>">
                    <button class="btn sm" type="submit" style="background:var(--danger);">إزالة</button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if(!$members): ?>
              <tr><td colspan="5" style="text-align:center;opacity:.8;">لا يوجد أعضاء</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <?php endif; ?>

  <div style="margin-top:16px;">
    <a class="btn secondary" href="<?= e($LIST_HREF) ?>">← العودة لقائمة العائلات</a>
  </div>
</div>

<?php require $INC_DIR . '/footer.php'; ?>
