<?php
// families.php  (يعمل سواءً كان داخل wesaladmin/ أو داخل wesaladmin/family/)
declare(strict_types=1);

/* ===== detect location & bootstrap ===== */
if (isset($_GET['dbg'])) { ini_set('display_errors','1'); error_reporting(E_ALL); }

$IN_FAMILY_DIR = (basename(__DIR__) === 'family');     // true لو الملف داخل wesaladmin/family/
$CFG_PATH      = $IN_FAMILY_DIR ? __DIR__ . '/../config.php'      : __DIR__ . '/config.php';
$INC_DIR       = $IN_FAMILY_DIR ? __DIR__ . '/../inc'             : __DIR__ . '/inc';
$LINK_PREFIX   = $IN_FAMILY_DIR ? '../'                            : ''; // للروابط إلى ملفات بالجذر

require_once $CFG_PATH;
require_once $INC_DIR . '/auth.php';
require_login();
/* ======================================= */

/* ---------------- CSRF ---------------- */
if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }

/* -------------- Helpers --------------- */
if (!function_exists('e')) {
  function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}
function fmt_dt(?string $s): string {
  if (!$s) return '';
  $t = strtotime($s); if ($t<=0) return e($s);
  return date('Y-m-d H:i', $t);
}

/* -------------- Actions ---------------- */
$pdo = db();
$msg = null; $err = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action = $_POST['action'] ?? '';
  $id     = (int)($_POST['id'] ?? 0);
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.';
  } elseif ($id <= 0) {
    $err = 'مُعرّف غير صالح.';
  } else {
    try {
      if ($action === 'delete_family') {
        $pdo->beginTransaction();
        $pdo->prepare("DELETE FROM `family_members` WHERE `family_id`=?")->execute([$id]);
        $pdo->prepare("DELETE FROM `families` WHERE `id`=? LIMIT 1")->execute([$id]);
        $pdo->commit();
        $msg = 'تم حذف العائلة وكل أعضائها.';
      } elseif ($action === 'toggle_allow') {
        $st = $pdo->prepare("SELECT `allow_join` FROM `families` WHERE `id`=?");
        $st->execute([$id]);
        $cur = (int)($st->fetchColumn() ?? 0);
        $new = $cur ? 0 : 1;
        $pdo->prepare("UPDATE `families` SET `allow_join`=? WHERE `id`=?")->execute([$new,$id]);
        $msg = $new ? 'تم فتح الانضمام.' : 'تم إغلاق الانضمام.';
      }
    } catch (Throwable $e) {
      if ($pdo->inTransaction()) $pdo->rollBack();
      $err = 'حدث خطأ أثناء تنفيذ العملية.' . (isset($_GET['dbg']) ? ' ('.$e->getMessage().')' : '');
    }
  }
}

/* --------- Filters / Search / Paging -------- */
$q          = trim($_GET['q'] ?? '');
$ownerId    = (int)($_GET['owner_id'] ?? 0);
$allowJoin  = $_GET['allow_join'] ?? ''; // '', '0', '1'
$page       = max(1, (int)($_GET['page'] ?? 1));
$perPage    = 50;
$offset     = ($page - 1) * $perPage;

$where  = "1=1"; $params = [];
if ($q !== '') {
  $where .= " AND (f.`name` LIKE ? OR f.`announcement` LIKE ? OR u.username LIKE ? OR u.email LIKE ?)";
  $kw = "%$q%"; array_push($params,$kw,$kw,$kw,$kw);
}
if ($ownerId > 0) { $where .= " AND f.`owner_uid`=?"; $params[] = $ownerId; }
if ($allowJoin === '0' || $allowJoin === '1') { $where .= " AND f.`allow_join`=?"; $params[] = (int)$allowJoin; }

/* الإجمالي */
$total = 0;
try {
  $st = $pdo->prepare("SELECT COUNT(*)
                       FROM `families` f
                       LEFT JOIN `users` u ON u.id = f.owner_uid
                       WHERE $where");
  $st->execute($params);
  $total = (int)$st->fetchColumn();
} catch (Throwable $e) {
  $err = 'تعذّر حساب الإجمالي.' . (isset($_GET['dbg']) ? ' ('.$e->getMessage().')' : '');
}
$pages = max(1, (int)ceil($total / $perPage));

/* جلب الصفحة مع عدد الأعضاء */
$rows = [];
try {
  $sql = "SELECT f.*, u.username AS owner_name, u.email AS owner_email,
                 COALESCE(m.cnt,0) AS members_count
          FROM `families` f
          LEFT JOIN `users` u ON u.id = f.owner_uid
          LEFT JOIN (
            SELECT family_id, COUNT(*) AS cnt
            FROM family_members GROUP BY family_id
          ) m ON m.family_id = f.id
          WHERE $where
          ORDER BY f.id DESC
          LIMIT $perPage OFFSET $offset";
  $st = $pdo->prepare($sql);
  $st->execute($params);
  $rows = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];
} catch (Throwable $e) {
  $rows = [];
  $err = 'تعذّر جلب البيانات.' . (isset($_GET['dbg']) ? ' ('.$e->getMessage().')' : '');
}

/* -------------- Render ------------------ */
$PAGE_TITLE = "إدارة العائلات";
require $INC_DIR . '/header.php';
require $INC_DIR . '/sidebar.php';
?>
<style>
/* ========= Fallback CSS داخلي — يعمل حتى لو assets/admin.css لم تُحمَّل ========= */
:root{
  --bg:#0b1220; --panel:#0f172a; --text:#e5e7eb; --muted:#9ca3af;
  --border:#1f2937; --brand:#3b82f6; --danger:#ef4444; --success:#22c55e;
}
*{box-sizing:border-box}
html{direction:rtl}
body{background:var(--bg);color:var(--text);font:16px/1.6 system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue","Tajawal","Cairo",Arial}
a{color:#93c5fd;text-decoration:none}
a:hover{text-decoration:underline}
.card{background:var(--panel);border:1px solid var(--border);border-radius:12px;padding:12px}
.hr{height:1px;background:var(--border);margin:12px 0}
.alert{border:1px solid var(--border);padding:10px 12px;border-radius:10px;background:#0b132a}
.btn{display:inline-flex;align-items:center;gap:8px;padding:10px 14px;border-radius:10px;background:var(--brand);color:#fff;border:1px solid transparent;cursor:pointer}
.btn:hover{opacity:.95}
.btn.secondary{background:transparent;color:var(--text);border-color:var(--border)}
.btn.sm{padding:6px 10px;font-size:14px}
.form .input{display:flex;flex-direction:column;gap:6px}
.form input[type="text"],.form input[type="number"],.form input[type="url"],.form select,.form textarea{
  background:#0b132a;border:1px solid var(--border);color:var(--text);border-radius:10px;padding:10px 12px;min-width:160px
}
.form label{font-size:13px;opacity:.9}
.table{width:100%;border-collapse:separate;border-spacing:0;background:var(--panel);border:1px solid var(--border);border-radius:12px;overflow:hidden;table-layout:fixed}
.table td,.table th{padding:10px 12px;border-bottom:1px solid var(--border);vertical-align:middle;text-align:start}
.table thead th{background:#0b1220;color:var(--text);font-weight:700;position:sticky;top:0;z-index:3;box-shadow:inset 0 -1px 0 var(--border)}
.table tbody tr:nth-child(even) td{background:rgba(255,255,255,.015)}
.table tbody tr:hover td{background:rgba(59,130,246,.08)}
.table-wrap{max-height:70vh;overflow:auto;position:relative}
.badge{display:inline-block;padding:2px 8px;border-radius:999px;border:1px solid var(--border);font-size:12px}
.td-center{text-align:center}
.ellipsis{max-width:320px;display:inline-block;overflow:hidden;white-space:nowrap;text-overflow:ellipsis}
.logo{width:34px;height:34px;border-radius:8px;object-fit:cover;border:1px solid var(--border);background:#111}
.families-page .filters{display:flex;gap:12px;align-items:flex-end;flex-wrap:wrap}

/* Breadcrumb / القائمة الجانبية fallback لمنع ظهور رموز › كسطور */
.breadcrumbs, .breadcrumb { display:flex; align-items:center; gap:8px; flex-wrap:wrap; margin:0; padding:8px 12px; list-style:none; }
.breadcrumbs li, .breadcrumb li { display:inline-flex; align-items:center; }
.breadcrumbs .sep, .breadcrumb .sep { opacity:.5; user-select:none; }

@media (max-width:900px){ .ellipsis{max-width:180px} }
/* ======== نهاية fallback، يليها تنسيقات الصفحة الخاصة ======== */

.families-page .col-id{width:64px}
.families-page .col-name{width:340px}
.families-page .col-owner{width:260px}
.families-page .col-members{width:120px}
.families-page .col-join{width:120px}
.families-page .col-created{width:170px}
.families-page .col-actions{width:240px}
</style>

<div class="families-page">
  <div class="card" style="margin-bottom:16px;">
    <form method="get" class="form filters">
      <div class="input" style="min-width:260px; flex:1;">
        <label>بحث بالاسم / الوصف / اسم أو إيميل المالك</label>
        <input type="text" name="q" value="<?= e($q) ?>" placeholder="مثال: عائلة / وصف / user@mail.com">
      </div>
      <div class="input">
        <label>ID المالك</label>
        <input type="number" name="owner_id" min="1" value="<?= $ownerId>0?(int)$ownerId:'' ?>">
      </div>
      <div class="input">
        <label>حالة الانضمام</label>
        <select name="allow_join">
          <option value=""<?= $allowJoin===''?' selected':''; ?>>الكل</option>
          <option value="1"<?= $allowJoin==='1'?' selected':''; ?>>مفتوح</option>
          <option value="0"<?= $allowJoin==='0'?' selected':''; ?>>مغلق</option>
        </select>
      </div>
      <button class="btn sm" type="submit">بحث</button>
      <?php if ($q!=='' || $ownerId>0 || $allowJoin!==''): ?>
        <a class="btn sm secondary" href="families.php">مسح الفلاتر</a>
      <?php endif; ?>
      <div style="margin-inline-start:auto; opacity:.9;">إجمالي: <b><?= $total ?></b> عائلة</div>
    </form>
    <?php if ($msg): ?><div class="alert" style="margin-top:12px; border-color:var(--success);"><?= e($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert" style="margin-top:12px; border-color:var(--danger);"><?= e($err) ?></div><?php endif; ?>
  </div>

  <div class="card">
    <div class="table-wrap">
      <table class="table">
        <colgroup>
          <col class="col-id"><col class="col-name"><col class="col-owner">
          <col class="col-members"><col class="col-join"><col class="col-created"><col class="col-actions">
        </colgroup>
        <thead>
          <tr>
            <th class="td-center">#</th>
            <th>العائلة</th>
            <th>المالك</th>
            <th class="td-center">الأعضاء</th>
            <th class="td-center">الانضمام</th>
            <th>أُنشئت</th>
            <th>إجراءات</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $r): ?>
            <tr>
              <td class="td-center"><?= (int)$r['id'] ?></td>
              <td>
                <div style="display:flex;align-items:center;gap:10px;min-width:0;">
                  <?php if (!empty($r['badge_url'])): ?>
                    <img class="logo" src="<?= e($r['badge_url']) ?>" alt="">
                  <?php else: ?>
                    <div class="logo" style="display:flex;align-items:center;justify-content:center;opacity:.6;">—</div>
                  <?php endif; ?>
                  <div style="min-width:0;">
                    <div class="ellipsis" title="<?= e($r['name'] ?? '') ?>"><b><?= e($r['name'] ?? '') ?></b></div>
                    <?php if (!empty($r['announcement'])): ?>
                      <div class="ellipsis" style="opacity:.8" title="<?= e($r['announcement']) ?>"><?= e($r['announcement']) ?></div>
                    <?php endif; ?>
                  </div>
                </div>
              </td>
              <td>
                <?php if (!empty($r['owner_name'])): ?>
                  <a class="ellipsis" title="<?= e($r['owner_email'] ?? '') ?>" href="<?= $LINK_PREFIX ?>users_edit.php?id=<?= (int)$r['owner_uid'] ?>" style="text-decoration:underline;">
                    <?= e($r['owner_name']) ?>
                  </a>
                <?php else: ?>
                  <span class="ellipsis">ID: <?= (int)$r['owner_uid'] ?></span>
                <?php endif; ?>
              </td>
              <td class="td-center"><span class="badge"><?= (int)$r['members_count'] ?></span></td>
              <td class="td-center">
                <span class="badge" style="border-color:<?= (int)$r['allow_join']? 'var(--success)':'var(--danger)' ?>;">
                  <?= (int)$r['allow_join'] ? 'مفتوح' : 'مغلق' ?>
                </span>
              </td>
              <td title="<?= e($r['created_at'] ?? '') ?>"><?= fmt_dt($r['created_at'] ?? '') ?></td>
              <td class="actions" style="display:flex;gap:8px;flex-wrap:nowrap;align-items:center;">
                <?php
                  // ===== إصلاح مسار صفحة التعديل =====
                  // إن كانت صفحة families_edit.php موجودة في نفس المجلد استخدمها مباشرة،
                  // وإلا جرّب مسار مجلد family/ (للّين المرن).
                  $editScript = file_exists(__DIR__ . '/families_edit.php')
                                ? 'families_edit.php'
                                : (($IN_FAMILY_DIR ? '' : 'family/') . 'families_edit.php');
                  $familyEditHref = $editScript . '?id=' . (int)$r['id'];
                ?>
                <a class="btn sm secondary" href="<?= e($familyEditHref) ?>">تفاصيل</a>

                <form method="post">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                  <input type="hidden" name="action" value="toggle_allow">
                  <button class="btn sm" type="submit"><?= (int)$r['allow_join'] ? 'إغلاق الانضمام' : 'فتح الانضمام' ?></button>
                </form>
                <form method="post" onsubmit="return confirm('حذف العائلة سيحذف أعضاءها، هل أنت متأكد؟');">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                  <input type="hidden" name="action" value="delete_family">
                  <button class="btn sm" type="submit" style="background:var(--danger);">حذف</button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if (!$rows): ?>
            <tr><td colspan="7" style="text-align:center; opacity:.8;">لا توجد بيانات</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <?php if ($pages > 1): ?>
      <div style="display:flex; gap:8px; margin-top:12px; flex-wrap:wrap;">
        <?php for($p=1;$p<=$pages;$p++):
          $url = 'families.php?page='.$p
               .($q!=='' ? '&q='.urlencode($q) : '')
               .($ownerId>0 ? '&owner_id='.$ownerId : '')
               .($allowJoin!=='' ? '&allow_join='.$allowJoin : '');
          $is = $p===$page; ?>
          <a href="<?= e($url) ?>" class="btn sm <?= $is ? '' : 'secondary' ?>"<?= $is?' style="pointer-events:none; opacity:.8;"':''; ?>><?= $p ?></a>
        <?php endfor; ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<?php require $INC_DIR . '/footer.php'; ?>
