<?php
// admin/emoji_categories.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }

if (!function_exists('e')) { function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }

$pdo = db();
$msg = null; $err = null;

$editId = (int)($_GET['id'] ?? 0);

/* Actions save/delete */
if ($_SERVER['REQUEST_METHOD']==='POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err='رمز الأمان غير صالح.';
  } else {
    $act = $_POST['action'] ?? '';
    if ($act==='save_cat') {
      $id   = (int)($_POST['id'] ?? 0);
      $name = trim((string)($_POST['name'] ?? ''));
      $icon = trim((string)($_POST['icon_url'] ?? ''));
      $sort = (int)($_POST['sort_order'] ?? 0);
      if ($name==='') $name='بدون اسم';
      try{
        if ($id>0) {
          $pdo->prepare("UPDATE emoji_categories SET name=?, icon_url=?, sort_order=? WHERE id=? LIMIT 1")->execute([$name,$icon,$sort,$id]);
          $msg='تم التحديث.';
        } else {
          $pdo->prepare("INSERT INTO emoji_categories (name,icon_url,sort_order) VALUES (?,?,?)")->execute([$name,$icon,$sort]);
          $msg='تمت الإضافة.';
        }
      }catch(Throwable $e){ $err='تعذر الحفظ.'; }
    } elseif ($act==='delete_cat') {
      $id=(int)($_POST['id'] ?? 0);
      try{ $pdo->prepare("DELETE FROM emoji_categories WHERE id=? LIMIT 1")->execute([$id]); $msg='تم الحذف.'; }
      catch(Throwable $e){ $err='تعذر الحذف.'; }
    }
  }
}

/* Load rows & edit row */
$rows = $pdo->query("SELECT id,name,icon_url,sort_order FROM emoji_categories ORDER BY sort_order ASC, id ASC")->fetchAll();
$edit = ['id'=>0,'name'=>'','icon_url'=>'','sort_order'=>0];
if ($editId>0) {
  $st=$pdo->prepare("SELECT * FROM emoji_categories WHERE id=? LIMIT 1"); $st->execute([$editId]);
  if ($r=$st->fetch()) $edit = $r;
}

$PAGE_TITLE="فئات الايموجي";
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';
?>
<style>
.ec-page .table{width:100%;border-collapse:separate;border-spacing:0;background:var(--panel);border:1px solid var(--border);border-radius:12px;overflow:hidden}
.ec-page .table td,.ec-page .table th{padding:10px 12px;border-bottom:1px solid var(--border)}
.ec-page .table thead th{background:#0b1220;position:sticky;top:0;z-index:3;box-shadow:inset 0 -1px 0 var(--border)}
.ec-page .badge{display:inline-block;padding:2px 8px;border-radius:999px;border:1px solid var(--border);font-size:12px}
.ec-page .icon{width:28px;height:28px;object-fit:contain;background:#0d111a;border:1px solid var(--border);border-radius:6px}
.ec-page .grid2{display:grid;grid-template-columns:1.1fr .9fr;gap:16px}
@media(max-width:900px){.ec-page .grid2{grid-template-columns:1fr}}
</style>

<div class="ec-page">
  <div class="grid2">
    <div class="card">
      <h1 style="margin-top:0">قائمة الفئات</h1>
      <?php if($msg): ?><div class="alert" style="border-color:#22c55e;"><?= e($msg) ?></div><?php endif; ?>
      <?php if($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>
      <table class="table">
        <thead>
          <tr><th>#</th><th>الأيقونة</th><th>الاسم</th><th>الترتيب</th><th>إجراءات</th></tr>
        </thead>
        <tbody>
          <?php foreach($rows as $r): ?>
            <tr>
              <td><?= (int)$r['id'] ?></td>
              <td><?php if($r['icon_url']): ?><img class="icon" src="<?= e($r['icon_url']) ?>" alt=""><?php else:?><span class="badge">—</span><?php endif; ?></td>
              <td><?= e($r['name']) ?></td>
              <td><?= (int)$r['sort_order'] ?></td>
              <td style="display:flex;gap:8px;flex-wrap:wrap">
                <a class="btn sm secondary" href="emoji_categories.php?id=<?= (int)$r['id'] ?>">تعديل</a>
                <form method="post" onsubmit="return confirm('حذف الفئة؟');">
                  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                  <input type="hidden" name="action" value="delete_cat">
                  <button class="btn sm" type="submit" style="background:var(--danger);">حذف</button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if(!$rows): ?><tr><td colspan="5" style="text-align:center;opacity:.8;">لا توجد بيانات</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>

    <div class="card">
      <h2 style="margin-top:0"><?= $edit['id']? 'تعديل فئة #'.(int)$edit['id'] : 'إضافة فئة' ?></h2>
      <form method="post" class="form">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="action" value="save_cat">
        <input type="hidden" name="id" value="<?= (int)$edit['id'] ?>">
        <div class="input">
          <label>الاسم</label>
          <input name="name" value="<?= e($edit['name']) ?>" required>
        </div>
        <div class="input">
          <label>أيقونة (URL اختياري)</label>
          <input name="icon_url" value="<?= e($edit['icon_url']) ?>">
        </div>
        <div class="input">
          <label>الترتيب</label>
          <input type="number" name="sort_order" value="<?= (int)$edit['sort_order'] ?>">
        </div>
        <div style="display:flex;gap:8px;margin-top:8px;">
          <button class="btn" type="submit"><?= $edit['id']?'تحديث':'إضافة' ?></button>
          <a class="btn secondary" href="emoji_categories.php">جديد</a>
        </div>
      </form>
    </div>
  </div>
</div>
<?php require __DIR__ . '/inc/footer.php'; ?>
