<?php
// voicechat/wesaladmin/customer/index.php
declare(strict_types=1);
require_once __DIR__ . '/../../api/config.php';
// include __DIR__.'/../inc/auth.php'; // فعّل لو عندك مصادقة إدمن

$pdo = db();
$status = $_GET['status'] ?? 'open';
$q = "SELECT t.id, t.user_id, t.subject, t.status, t.last_message_at, t.created_at,
             u.username, u.avatar_url
      FROM support_tickets t
      LEFT JOIN users u ON u.id=t.user_id
      WHERE 1";
$params = [];
if (in_array($status, ['open','closed'], true)) { $q .= " AND t.status=?"; $params[] = $status; }
$q .= " ORDER BY t.last_message_at DESC LIMIT 200";
$st = $pdo->prepare($q);
$st->execute($params);
$rows = $st->fetchAll();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<meta charset="utf-8">
<title>تذاكر خدمة العملاء</title>
<link rel="stylesheet" href="../admin.css">
<body style="font-family:system-ui,-apple-system,Segoe UI,Tahoma; background:#0d1117; color:#e6edf3;">
<div style="max-width:980px;margin:20px auto;">
  <h2>تذاكر خدمة العملاء</h2>

  <p>
    <a href="?status=open"  style="margin-inline-end:8px;<?= $status==='open'?'font-weight:bold':'';?>">مفتوحة</a>
    <a href="?status=closed" style="<?= $status==='closed'?'font-weight:bold':'';?>">مغلقة</a>
  </p>

  <div style="border:1px solid #30363d;border-radius:10px;overflow:hidden;">
    <table style="width:100%; border-collapse:collapse;">
      <thead style="background:#161b22">
        <tr>
          <th style="padding:8px;border-bottom:1px solid #30363d">#</th>
          <th style="padding:8px;border-bottom:1px solid #30363d">المستخدم</th>
          <th style="padding:8px;border-bottom:1px solid #30363d">الموضوع</th>
          <th style="padding:8px;border-bottom:1px solid #30363d">الحالة</th>
          <th style="padding:8px;border-bottom:1px solid #30363d">آخر رسالة</th>
          <th style="padding:8px;border-bottom:1px solid #30363d"></th>
        </tr>
      </thead>
      <tbody>
      <?php foreach ($rows as $r): ?>
        <tr>
          <td style="padding:8px;border-bottom:1px solid #30363d"><?= (int)$r['id'] ?></td>
          <td style="padding:8px;border-bottom:1px solid #30363d">
            <?= htmlspecialchars($r['username'] ?? ''); ?>
          </td>
          <td style="padding:8px;border-bottom:1px solid #30363d"><?= htmlspecialchars($r['subject']) ?></td>
          <td style="padding:8px;border-bottom:1px solid #30363d"><?= $r['status']==='open'?'مفتوحة':'مغلقة' ?></td>
          <td style="padding:8px;border-bottom:1px solid #30363d"><?= htmlspecialchars($r['last_message_at']) ?></td>
          <td style="padding:8px;border-bottom:1px solid #30363d">
            <a href="view.php?id=<?= (int)$r['id'] ?>">فتح</a>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
</body>
</html>
