<?php
// admin/config.php
declare(strict_types=1);

// ====== إعدادات قاعدة البيانات ======
$DB_HOST = "localhost";
$DB_NAME = "u564352071_vociechat";
$DB_USER = "u564352071_vociechat";
$DB_PASS = "#5^n]Z|sV5c";

// ====== إعدادات عامة ======
date_default_timezone_set('Africa/Cairo');
ini_set('session.cookie_httponly', '1');
ini_set('session.use_strict_mode', '1');
session_name('admincp_sid');
session_start();

// للإنتاج: قفّل الأخطاء المعروضة
// ini_set('display_errors', '0'); error_reporting(0);

// اتصال PDO
function db(): PDO {
  static $pdo = null;
  global $DB_HOST, $DB_NAME, $DB_USER, $DB_PASS;
  if ($pdo === null) {
    $pdo = new PDO(
      "mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4",
      $DB_USER,
      $DB_PASS,
      [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
      ]
    );
  }
  return $pdo;
}

// دوال مساعدة
function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
function redirect(string $path): void { header("Location: $path"); exit; }

// هوية المستخدم الحالي (أدمن أو موظّف)
function current_user(): ?array {
  if (!empty($_SESSION['auth'])) return $_SESSION['auth']; // ['type'=>'admincp'|'teamcp', 'id'=>..., 'name'=>..., 'role'=>...]
  return null;
}
