<?php
// admin/banners_add.php
declare(strict_types=1);
require_once __DIR__ . '/inc/auth.php';
require_login();

/* CSRF */
if (!isset($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(?string $t): bool { return $t && hash_equals($_SESSION['csrf'], $t); }

/* HTML escape */
if (!function_exists('e')) {
  function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}

$pdo = db();
$msg = null; $err = null;
$id  = (int)($_GET['id'] ?? 0);

/* أصل الروابط المطلقة للدومين */
function app_origin(): string {
  if (defined('BASE_URL') && BASE_URL) {
    return rtrim((string)BASE_URL, '/');
  }
  return 'https://battle-party.com'; // عدّلها لو احتجت
}

/* مسارات رفع البنرات */
$UPLOAD_DIR  = __DIR__ . '/../files/banners';               // مسار فعلي على السيرفر
$PUBLIC_BASE = app_origin() . '/voicechat/files/banners/';  // رابط عمومي يُخزن بقاعدة البيانات

/* محوّل datetime-local -> DATETIME */
function to_mysql_dt(?string $v): ?string {
  if (!$v) return null;
  $v = trim($v);
  if ($v === '') return null;
  // يدعم "YYYY-MM-DDTHH:MM" أو "YYYY-MM-DD HH:MM"
  $v = str_replace('T', ' ', $v);
  // لو بدون ثواني أضف :00
  if (preg_match('/^\d{4}-\d{2}-\d{2}\s+\d{2}:\d{2}$/', $v)) $v .= ':00';
  $ts = strtotime($v);
  return $ts ? date('Y-m-d H:i:s', $ts) : null;
}

/* السجل الحالي (للتعديل) */
$row = [
  'id' => 0,
  'image_url' => '',
  'page_url'  => '',
  'is_active' => 1,
  'sort_order'=> 0,
  'starts_at' => null,
  'ends_at'   => null,
];
if ($id > 0) {
  $st = $pdo->prepare("SELECT * FROM banners WHERE id=? LIMIT 1");
  $st->execute([$id]);
  if ($r = $st->fetch(PDO::FETCH_ASSOC)) $row = $r;
}

/* حفظ */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.'; goto out;
  }

  $id        = (int)($_POST['id'] ?? 0);
  $image_url = trim((string)($_POST['image_url'] ?? ''));
  $page_url  = trim((string)($_POST['page_url'] ?? ''));
  $is_active = (int)($_POST['is_active'] ?? 1);
  $sort_order= (int)($_POST['sort_order'] ?? 0);
  $starts_at = to_mysql_dt($_POST['starts_at'] ?? null);
  $ends_at   = to_mysql_dt($_POST['ends_at'] ?? null);

  /* رابط نسبي يبدأ بـ /voicechat/ → حوّله لمطلق */
  if ($image_url !== '' && preg_match('#^/voicechat/#', $image_url) && !preg_match('#^https?://#i', $image_url)) {
    $image_url = rtrim(app_origin(), '/') . $image_url;
  }

  /* رفع صورة اختياري */
  if (!empty($_FILES['image_file']['name']) && $_FILES['image_file']['error'] === UPLOAD_ERR_OK) {
    $fn  = $_FILES['image_file']['name'];
    $tmp = $_FILES['image_file']['tmp_name'];
    $ext = strtolower(pathinfo($fn, PATHINFO_EXTENSION));
    $allowed = ['png','webp','jpg','jpeg','gif'];
    if (!in_array($ext, $allowed, true)) {
      $err = 'صيغة الصورة غير مسموحة. المسموح: PNG / WEBP / JPG / JPEG / GIF.'; goto out;
    }
    if (!is_dir($UPLOAD_DIR)) @mkdir($UPLOAD_DIR, 0775, true);
    $base = 'banner_'.time().'_'.bin2hex(random_bytes(3)).'.'.$ext;
    $dest = rtrim($UPLOAD_DIR,'/').'/'.$base;
    if (!move_uploaded_file($tmp, $dest)) {
      $err = 'فشل رفع الصورة.'; goto out;
    }
    $image_url = rtrim($PUBLIC_BASE,'/').'/'.$base; // الرابط الذي سنخزّنه
  }

  if ($image_url === '') { $err = 'الصورة مطلوبة (رابط أو رفع).'; goto out; }

  try {
    if ($id > 0) {
      $sql = "UPDATE banners
              SET image_url=?, page_url=?, is_active=?, sort_order=?, starts_at=?, ends_at=?
              WHERE id=? LIMIT 1";
      $pdo->prepare($sql)->execute([
        $image_url,
        ($page_url !== '' ? $page_url : null),
        $is_active,
        $sort_order,
        $starts_at,
        $ends_at,
        $id
      ]);
      $msg = 'تم التحديث بنجاح.';
      // إعادة التحميل
      $st = $pdo->prepare("SELECT * FROM banners WHERE id=?");
      $st->execute([$id]);
      $row = $st->fetch(PDO::FETCH_ASSOC);
    } else {
      $sql = "INSERT INTO banners (image_url, page_url, is_active, sort_order, starts_at, ends_at)
              VALUES (?,?,?,?,?,?)";
      $pdo->prepare($sql)->execute([
        $image_url,
        ($page_url !== '' ? $page_url : null),
        $is_active,
        $sort_order,
        $starts_at,
        $ends_at
      ]);
      $msg = 'تمت إضافة البنر.';
      $row = [
        'id' => 0,
        'image_url' => '',
        'page_url'  => '',
        'is_active' => 1,
        'sort_order'=> 0,
        'starts_at' => null,
        'ends_at'   => null,
      ];
    }
  } catch (Throwable $e) {
    $err = 'تعذّر الحفظ: '.$e->getMessage();
  }
}
out:

$PAGE_TITLE = ($row['id'] ? ('تعديل بنر #'.$row['id']) : 'إضافة بنر');
require __DIR__ . '/inc/header.php';
require __DIR__ . '/inc/sidebar.php';
?>
<style>
/* نفس ستايل صفحة الهدايا تقريبًا */
.badd-page .hint{opacity:.8;font-size:12px}
.badd-page .thumb{width:220px;height:120px;object-fit:cover;background:#0d111a;border:1px solid var(--border);border-radius:10px}
</style>

<div class="badd-page">
  <div class="card" style="max-width:920px;">
    <h1 style="margin-top:0"><?= e($PAGE_TITLE) ?></h1>
    <?php if($msg): ?><div class="alert" style="border-color:#22c55e;"><?= e($msg) ?></div><?php endif; ?>
    <?php if($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>

    <form method="post" class="form" enctype="multipart/form-data">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="id" value="<?= (int)$row['id'] ?>">

      <div class="grid cols-2">
        <div class="input">
          <label>الصورة (رابط مباشر)</label>
          <input name="image_url" value="<?= e((string)$row['image_url']) ?>" placeholder="https://…/banner.webp أو /voicechat/files/banners/x.png">
          <div class="hint">يمكن تركها فارغة إذا استخدمت خانة رفع الصورة بالأسفل. المُدخلات التي تبدأ بـ <code>/voicechat/</code> تُحوّل تلقائيًا لرابط مطلق.</div>
        </div>

        <div class="input">
          <label>رفع صورة</label>
          <input type="file" name="image_file" accept=".png,.webp,.jpg,.jpeg,.gif">
          <div class="hint">المسموح: PNG / WEBP / JPG / JPEG / GIF.</div>
        </div>

        <div class="input">
          <label>رابط الصفحة (اختياري)</label>
          <input name="page_url" value="<?= e((string)$row['page_url']) ?>" placeholder="https://example.com أو /page.php?slug=promo">
          <div class="hint">لو تُرك فارغًا يصبح البنر غير قابل للنقر.</div>
        </div>

        <div class="input">
          <label>الترتيب</label>
          <input type="number" name="sort_order" value="<?= (int)$row['sort_order'] ?>" step="1">
        </div>

        <div class="input">
          <label>الحالة</label>
          <select name="is_active">
            <option value="1"<?= ((int)$row['is_active']===1)?' selected':''; ?>>مفعل</option>
            <option value="0"<?= ((int)$row['is_active']===0)?' selected':''; ?>>معطّل</option>
          </select>
        </div>

        <div class="input">
          <label>يبدأ من (اختياري)</label>
          <input type="datetime-local" name="starts_at"
                 value="<?= $row['starts_at'] ? e(str_replace(' ', 'T', substr((string)$row['starts_at'],0,16))) : '' ?>">
          <div class="hint">اتركه فارغًا ليظهر فورًا.</div>
        </div>

        <div class="input">
          <label>ينتهي في (اختياري)</label>
          <input type="datetime-local" name="ends_at"
                 value="<?= $row['ends_at'] ? e(str_replace(' ', 'T', substr((string)$row['ends_at'],0,16))) : '' ?>">
          <div class="hint">اتركه فارغًا ليبقى ظاهرًا دائمًا.</div>
        </div>
      </div>

      <?php if(!empty($row['image_url'])): ?>
        <div style="margin-top:8px;display:flex;align-items:center;gap:10px;">
          <img class="thumb" src="<?= e((string)$row['image_url']) ?>" alt="">
          <span class="hint">معاينة الصورة الحالية</span>
          <?php if(!empty($row['page_url'])): ?>
            <span class="hint">— عند النقر سيفتح: <code><?= e((string)$row['page_url']) ?></code></span>
          <?php else: ?>
            <span class="hint">— هذا البنر غير قابل للنقر.</span>
          <?php endif; ?>
        </div>
      <?php endif; ?>

      <div style="display:flex;gap:8px;margin-top:12px;">
        <button class="btn" type="submit"><?= $row['id']?'تحديث':'إضافة' ?></button>
        <a class="btn secondary" href="banners.php">رجوع للقائمة</a>
      </div>
    </form>
  </div>
</div>

<?php require __DIR__ . '/inc/footer.php'; ?>
