<?php
// api/user_get.php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/../db.php'; // ملف الاتصال بقاعدة البيانات (PDO)

$userid = isset($_GET['userid']) ? trim($_GET['userid']) : '';
$uid    = isset($_GET['uid'])    ? trim($_GET['uid'])    : '';

if ($userid === '' && $uid === '') {
  http_response_code(400);
  echo json_encode(['error' => 'missing userid or uid']); exit;
}

$sql = $userid !== ''
  ? "SELECT uid, userid, username, avatar_url, country_code, gender, coins, cover_url, bio 
     FROM users WHERE userid = :v LIMIT 1"
  : "SELECT uid, userid, username, avatar_url, country_code, gender, coins, cover_url, bio 
     FROM users WHERE uid = :v LIMIT 1";

$stmt = $pdo->prepare($sql);
$stmt->execute([':v' => $userid !== '' ? $userid : $uid]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) { echo json_encode([]); exit; }
echo json_encode(['user' => $user], JSON_UNESCAPED_UNICODE);
