<?php
// backend/api/user_cover_upload.php
declare(strict_types=1);
require __DIR__ . '/config.php';

// لو مركّب composer بالمجلد الحالي أو الأعلى
$autoload1 = __DIR__ . '/vendor/autoload.php';
$autoload2 = dirname(__DIR__) . '/vendor/autoload.php';
if (file_exists($autoload1)) require_once $autoload1;
elseif (file_exists($autoload2)) require_once $autoload2;

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Authorization, Content-Type');
header('Access-Control-Allow-Methods: POST, OPTIONS');
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }

function json_fail($e,$c=400){ http_response_code($c); echo json_encode(['ok'=>false,'error'=>$e], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }
function json_ok($d=[]){ echo json_encode(['ok'=>true] + $d, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

/** التقاط Bearer من عدّة أماكن */
function bearer(): ?string {
  $h = $_SERVER['HTTP_AUTHORIZATION'] ?? $_SERVER['Authorization'] ?? $_SERVER['REDIRECT_HTTP_AUTHORIZATION'] ?? '';
  if (!$h && function_exists('getallheaders')) {
    foreach (getallheaders() as $k => $v) {
      if (strcasecmp($k, 'Authorization') === 0) { $h = $v; break; }
    }
  }
  return stripos($h, 'Bearer ') === 0 ? trim(substr($h, 7)) : null;
}

/** أصل الموقع (https + host) */
function site_origin(): string {
  $proto = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  if (!empty($_SERVER['HTTP_X_FORWARDED_PROTO'])) $proto = $_SERVER['HTTP_X_FORWARDED_PROTO'];
  $host  = $_SERVER['HTTP_X_FORWARDED_HOST'] ?? ($_SERVER['HTTP_HOST'] ?? 'localhost');
  // إجبار https في الرابط العام
  $proto = 'https';
  return $proto . '://' . $host;
}

/**
 * مسار التطبيق الجذري:
 * مثال: SCRIPT_NAME = /voicechat/api/user_cover_upload.php
 * → dirname = /voicechat/api → ننزع /api فيصبح /voicechat
 */
function app_base_path(): string {
  $p = rtrim(dirname($_SERVER['SCRIPT_NAME'] ?? ''), '/'); // /voicechat/api
  if (preg_match('#/api$#', $p)) $p = substr($p, 0, -4);   // → /voicechat
  return $p ?: '';
}

/** هل الجدول يحتوي على عمود؟ */
function table_has_col(PDO $pdo, string $table, string $col): bool {
  try {
    $st = $pdo->prepare("SHOW COLUMNS FROM `$table` LIKE ?");
    $st->execute([$col]);
    return (bool)$st->fetchColumn();
  } catch (Throwable $e) { return false; }
}

/* ================= المصادقة ================= */
$jwt = bearer() ?: ($_POST['token'] ?? '');
if (!$jwt) json_fail('missing_token', 401);

try {
  global $JWT_SECRET;
  $payload = JWT::decode($jwt, new Key($JWT_SECRET, 'HS256'));
} catch (Throwable $e) {
  json_fail('invalid_token: '.$e->getMessage(), 401);
}

// أغلب حالاتك: uid في التوكن يمثل users.id
$dbId    = (int)($payload->uid ?? $payload->id ?? 0);
$uidText = (string)($payload->firebase_uid ?? $payload->uid_text ?? ($_POST['uid'] ?? ''));

/* ============== قراءة الملف المرفوع ============== */
$up = null;
foreach (['cover','file','image'] as $f) {
  if (isset($_FILES[$f]) && is_array($_FILES[$f]) && ($_FILES[$f]['error'] ?? UPLOAD_ERR_NO_FILE) === UPLOAD_ERR_OK) {
    $up = $_FILES[$f];
    break;
  }
}
if (!$up) json_fail('no_file', 400);

// السماح بأنواع الصور الشائعة
$mime = mime_content_type($up['tmp_name']);
$allowed = ['image/jpeg'=>'jpg', 'image/png'=>'png', 'image/webp'=>'webp', 'image/gif'=>'gif'];
if (!isset($allowed[$mime])) json_fail('unsupported_type: '.$mime, 400);
$ext = $allowed[$mime];

/* ============== مسارات الحفظ ============== */
/*
  نحفظ فعليًا داخل:   <root>/voicechat/files/users/covers
  والرابط العام يكون: /voicechat/files/users/covers/<name>
*/
$absDir = dirname(__DIR__) . '/files/users/covers'; // 👈 خارج api
if (!is_dir($absDir) && !@mkdir($absDir, 0775, true)) json_fail('mkdir_failed', 500);

$fname = 'cover_' . ($dbId ?: 'u') . '_' . date('Ymd_His') . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
$abs   = $absDir . '/' . $fname;

// انقل الملف
if (!@move_uploaded_file($up['tmp_name'], $abs)) json_fail('move_failed', 500);

// ابنِ الرابط العام على /voicechat
$origin     = site_origin();
$basePath   = app_base_path();                            // /voicechat
$publicPath = $basePath . '/files/users/covers/' . $fname;
$coverUrl   = $origin . $publicPath;

/* ============== تحديث قاعدة البيانات ============== */
try {
  $pdo = db();
  // اسم العمود في جدول users حسب لقطة الشاشة: cover_url
  if ($dbId > 0) {
    $st = $pdo->prepare("UPDATE users SET cover_url = ? WHERE id = ? LIMIT 1");
    $st->execute([$coverUrl, $dbId]);
  } elseif ($uidText !== '' && table_has_col($pdo, 'users', 'uid')) {
    $st = $pdo->prepare("UPDATE users SET cover_url = ? WHERE uid = ? LIMIT 1");
    $st->execute([$coverUrl, $uidText]);
  } else {
    json_fail('missing_user_identifier', 401);
  }
} catch (Throwable $e) {
  json_fail('db_error: '.$e->getMessage(), 500);
}

/* ============== استجابة النجاح ============== */
json_ok(['cover_url' => $coverUrl]);
