<?php
declare(strict_types=1);

require __DIR__ . '/../config.php';
require_once __DIR__ . '/../vendor/autoload.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Authorization, Content-Type');
header('Access-Control-Allow-Methods: GET, OPTIONS');
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }

function json_fail($e,$c=400){ http_response_code($c); echo json_encode(['ok'=>false,'error'=>$e], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }
function json_ok($d=[]){ echo json_encode(['ok'=>true] + $d, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }
function bearer(): ?string {
  $h = $_SERVER['HTTP_AUTHORIZATION'] ?? $_SERVER['Authorization'] ?? $_SERVER['REDIRECT_HTTP_AUTHORIZATION'] ?? '';
  if (!$h && function_exists('getallheaders')) {
    foreach (getallheaders() as $k => $v) { if (strcasecmp($k,'Authorization')===0){ $h=$v; break; } }
  }
  return stripos($h, 'Bearer ') === 0 ? trim(substr($h, 7)) : null;
}
function auth_user_id(PDO $pdo, object $payload): int {
  $id = 0;
  foreach (['id','user_id','uid'] as $k) {
    if (isset($payload->$k) && is_numeric($payload->$k)) { $id = (int)$payload->$k; break; }
  }
  if ($id > 0) return $id;
  $fuid = (string)($payload->firebase_uid ?? '');
  if ($fuid !== '') {
    $st = $pdo->prepare("SELECT id FROM users WHERE uid = ? LIMIT 1");
    $st->execute([$fuid]);
    $id = (int)$st->fetchColumn();
  }
  return $id;
}

$jwt = bearer(); if (!$jwt) json_fail('missing authorization bearer token', 401);
try {
  $payload = JWT::decode($jwt, new Key($JWT_SECRET, 'HS256'));
} catch (Throwable $e) {
  json_fail('invalid token: '.$e->getMessage(), 401);
}

$pdo = db();
$uid = auth_user_id($pdo, $payload);
if ($uid <= 0) json_fail('user_not_found', 401);

$threadId = (int)($_GET['thread_id'] ?? 0);
if ($threadId <= 0) json_fail('missing thread_id');

$page = max(1, (int)($_GET['page'] ?? 1));
$pageSize = (int)($_GET['page_size'] ?? 30);
if ($pageSize <= 0) $pageSize = 30;
if ($pageSize > 200) $pageSize = 200;
$offset = ($page - 1) * $pageSize;

try {
  // تأكد من ملكية المستخدم للتذكرة
  $st = $pdo->prepare("SELECT * FROM support_threads WHERE id = ? AND user_id = ? LIMIT 1");
  $st->execute([$threadId, $uid]);
  $thread = $st->fetch(PDO::FETCH_ASSOC);
  if (!$thread) json_fail('thread_not_found', 404);

  // رسائل التذكرة (تصاعدي)
  $st2 = $pdo->prepare("
    SELECT id, thread_id, sender_type, user_id, staff_name, message_text, attachment_url, created_at, read_by_user, read_by_staff
    FROM support_messages
    WHERE thread_id = ?
    ORDER BY created_at ASC, id ASC
    LIMIT $offset, $pageSize
  ");
  $st2->execute([$threadId]);
  $messages = $st2->fetchAll(PDO::FETCH_ASSOC);

  // علّم رسائل الموظف كمقروءة من ناحية المستخدم
  $st3 = $pdo->prepare("
    UPDATE support_messages
    SET read_by_user = 1
    WHERE thread_id = ? AND sender_type = 'staff'
  ");
  $st3->execute([$threadId]);

  // إجمالي الرسائل
  $st4 = $pdo->prepare("SELECT COUNT(*) FROM support_messages WHERE thread_id = ?");
  $st4->execute([$threadId]);
  $total = (int)$st4->fetchColumn();
  $hasMore = ($offset + count($messages)) < $total;

  json_ok([
    'thread' => $thread,
    'messages' => $messages,
    'page' => $page,
    'page_size' => $pageSize,
    'total' => $total,
    'has_more' => $hasMore,
  ]);
} catch (Throwable $e) {
  json_fail('db_error: '.$e->getMessage(), 500);
}
