<?php
declare(strict_types=1);

require __DIR__ . '/../config.php';
require_once __DIR__ . '/../vendor/autoload.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Authorization, Content-Type');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }

function json_fail($e,$c=400){ http_response_code($c); echo json_encode(['ok'=>false,'error'=>$e], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }
function json_ok($d=[]){ echo json_encode(['ok'=>true] + $d, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }
function bearer(): ?string {
  $h = $_SERVER['HTTP_AUTHORIZATION'] ?? $_SERVER['Authorization'] ?? $_SERVER['REDIRECT_HTTP_AUTHORIZATION'] ?? '';
  if (!$h && function_exists('getallheaders')) {
    foreach (getallheaders() as $k => $v) { if (strcasecmp($k,'Authorization')===0){ $h=$v; break; } }
  }
  return stripos($h, 'Bearer ') === 0 ? trim(substr($h, 7)) : null;
}
function input_all(): array {
  $ct = $_SERVER['CONTENT_TYPE'] ?? $_SERVER['HTTP_CONTENT_TYPE'] ?? '';
  if (stripos($ct,'application/json')!==false) {
    $raw = file_get_contents('php://input') ?: '';
    $j = json_decode($raw, true);
    if (is_array($j)) return $j + $_POST + $_GET;
  }
  return $_POST + $_GET;
}
function auth_user_id(PDO $pdo, object $payload): int {
  $id = 0;
  foreach (['id','user_id','uid'] as $k) {
    if (isset($payload->$k) && is_numeric($payload->$k)) { $id = (int)$payload->$k; break; }
  }
  if ($id > 0) return $id;
  $fuid = (string)($payload->firebase_uid ?? '');
  if ($fuid !== '') {
    $st = $pdo->prepare("SELECT id FROM users WHERE uid = ? LIMIT 1");
    $st->execute([$fuid]);
    $id = (int)$st->fetchColumn();
  }
  return $id;
}

$jwt = bearer(); if (!$jwt) json_fail('missing authorization bearer token', 401);
try {
  $payload = JWT::decode($jwt, new Key($JWT_SECRET, 'HS256'));
} catch (Throwable $e) {
  json_fail('invalid token: '.$e->getMessage(), 401);
}

$pdo = db();
$uid = auth_user_id($pdo, $payload);
if ($uid <= 0) json_fail('user_not_found', 401);

$in = input_all();
$subject = trim((string)($in['subject'] ?? ''));

// ✅ أولاً: حاول إعادة استخدام محادثة سابقة للمستخدم
$st = $pdo->prepare("SELECT id, subject, status, updated_at FROM support_threads WHERE user_id=? ORDER BY updated_at DESC, id DESC LIMIT 1");
$st->execute([$uid]);
$thread = $st->fetch(PDO::FETCH_ASSOC);

if ($thread) {
  json_ok([
    'thread_id' => (int)$thread['id'],
    'thread' => [
      'id'      => (int)$thread['id'],
      'subject' => (string)($thread['subject'] ?? 'محادثة دعم'),
      'status'  => (string)($thread['status'] ?? 'open'),
      'updated_at' => (string)($thread['updated_at'] ?? ''),
    ],
  ]);
}

// لم توجد محادثة — أنشئ واحدة جديدة بعنوان افتراضي
if ($subject === '') $subject = 'محادثة دعم';
if (mb_strlen($subject) > 200) $subject = mb_substr($subject, 0, 200);
if (mb_strlen($subject) < 3) $subject = 'محادثة دعم';

$st2 = $pdo->prepare("
  INSERT INTO support_threads (user_id, subject, status, created_at, updated_at)
  VALUES (?, ?, 'open', NOW(), NOW())
");
$st2->execute([$uid, $subject]);
$tid = (int)$pdo->lastInsertId();

json_ok([
  'thread_id' => $tid,
  'thread' => ['id'=>$tid, 'subject'=>$subject, 'status'=>'open']
]);
