<?php
// voicechat/api/store/my_items.php
require_once __DIR__ . '/../config.php';
header('Content-Type: application/json; charset=utf-8');

$pdo = db();
$me  = require_user();
$category = trim($_GET['category'] ?? $_POST['category'] ?? 'frame');

$q = $pdo->prepare("SELECT si.id, si.category, si.name, si.image_url, usi.expires_at
  FROM user_store_items usi
  JOIN store_items si ON si.id=usi.item_id
  WHERE usi.user_id=? AND si.is_active=1 AND si.category=?
  ORDER BY si.sort_order DESC, si.id DESC");
$q->execute([$me, $category]);

$now = time(); $items = [];
foreach ($q as $r) {
  $remain = null;
  if ($r['expires_at']) {
    $t = strtotime($r['expires_at']);
    if ($t <= $now) continue; // منتهٍ
    $remain = ceil(($t - $now)/86400);
  }
  $items[] = [
    'id' => (int)$r['id'],
    'category' => $r['category'],
    'name' => $r['name'],
    'image_url' => $r['image_url'],
    'remaining_days' => $remain
  ];
}

echo json_encode(['ok'=>1, 'items'=>$items], JSON_UNESCAPED_UNICODE);
