<?php
// voicechat/api/store/items_owned.php
require_once __DIR__ . '/../config.php';
header('Content-Type: application/json; charset=utf-8');

try { $pdo = db(); } catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>0,'error'=>'db_connect_failed']); exit;
}

// يتطلب توثيق
$me = user_id(); // أو user() عندك
if (!$me) { http_response_code(401); echo json_encode(['ok'=>0,'error'=>'unauthorized']); exit; }

$category = trim($_GET['category'] ?? $_POST['category'] ?? '');
$params = [$me];
$where = '';
if ($category !== '') { $where = ' AND si.category = ? '; $params[] = $category; }

$sql = "SELECT si.id, si.category, si.slug, si.name, si.image_url,
               si.price, si.days, si.rating,
               ui.expires_at
        FROM user_store_items ui
        JOIN store_items si ON si.id = ui.item_id
        WHERE ui.user_id = ? $where
        ORDER BY si.category, si.sort_order DESC, si.id DESC";

try {
  $st = $pdo->prepare($sql);
  $st->execute($params);
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>0,'error'=>'owned_table_missing_or_sql_error']); exit;
}

$now = time(); $out = [];
foreach ($rows as $it) {
  $remain = null;
  if (!is_null($it['expires_at'])) {
    $t = strtotime($it['expires_at']);
    if ($t > $now) $remain = (int)ceil(($t - $now)/86400);
    else continue; // منتهي الصلاحية
  }
  $out[] = [
    'id' => (int)$it['id'],
    'category' => $it['category'],
    'slug' => $it['slug'],
    'name' => $it['name'],
    'image_url' => $it['image_url'],
    'price' => (int)$it['price'],
    'days'  => $it['days'] !== null ? (int)$it['days'] : null,
    'rating'=> $it['rating'] !== null ? (int)$it['rating'] : null,
    'remaining_days' => $remain, // null = دائم
  ];
}

echo json_encode(['ok'=>1,'items'=>$out], JSON_UNESCAPED_UNICODE);
