<?php
// voicechat/api/store/buy.php
require_once __DIR__ . '/../config.php';
header('Content-Type: application/json; charset=utf-8');

function get_item(PDO $pdo, int $id, string $cat) {
  $q = $pdo->prepare("SELECT * FROM store_items WHERE id=? AND category=? AND is_active=1");
  $q->execute([$id, $cat]);
  return $q->fetch(PDO::FETCH_ASSOC);
}

$pdo = db();
$me  = require_user();

$item_id = (int)($_POST['item_id'] ?? $_GET['item_id'] ?? 0);
$category = trim($_POST['category'] ?? $_GET['category'] ?? 'frame');
if ($item_id<=0) json_out(['ok'=>0, 'error'=>'item_id_required']);

$pdo->beginTransaction();
try {
  // قفل المستخدم
  $u = $pdo->prepare("SELECT id, coins FROM users WHERE id=? FOR UPDATE");
  $u->execute([$me]);
  $user = $u->fetch(PDO::FETCH_ASSOC);
  if (!$user) throw new Exception('user_not_found');

  // جلب العنصر
  $item = get_item($pdo, $item_id, $category);
  if (!$item) throw new Exception('item_not_found');

  $price = (int)$item['price'];
  if ((int)$user['coins'] < $price) throw new Exception('not_enough_coins');

  // خصم الكوينز
  $newCoins = (int)$user['coins'] - $price;
  $pdo->prepare("UPDATE users SET coins=? WHERE id=?")->execute([$newCoins, $me]);

  // امتلاك/تجديد
  $days = $item['days'] !== null ? (int)$item['days'] : null;
  $sel = $pdo->prepare("SELECT id, expires_at FROM user_store_items WHERE user_id=? AND item_id=?");
  $sel->execute([$me, $item_id]);

  if ($row = $sel->fetch(PDO::FETCH_ASSOC)) {
    if ($days === null) {
      $pdo->prepare("UPDATE user_store_items SET expires_at=NULL, source='buy' WHERE id=?")
          ->execute([$row['id']]);
    } else {
      $base = $row['expires_at'] && strtotime($row['expires_at']) > time()
            ? strtotime($row['expires_at']) : time();
      $newExp = date('Y-m-d H:i:s', $base + $days*86400);
      $pdo->prepare("UPDATE user_store_items SET expires_at=?, source='buy' WHERE id=?")
          ->execute([$newExp, $row['id']]);
    }
  } else {
    $expires_at = $days === null ? null : date('Y-m-d H:i:s', time() + $days*86400);
    $pdo->prepare("INSERT INTO user_store_items (user_id, item_id, expires_at, source)
                   VALUES (?,?,?, 'buy')")->execute([$me, $item_id, $expires_at]);
  }

  // سجل العملية
  $pdo->prepare("INSERT INTO store_orders (user_id, item_id, price, action) VALUES (?,?,?, 'buy')")
      ->execute([$me, $item_id, $price]);

  $pdo->commit();
  echo json_encode(['ok'=>1, 'coins'=>$newCoins], JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
  $pdo->rollBack();
  echo json_encode(['ok'=>0, 'error'=>$e->getMessage()], JSON_UNESCAPED_UNICODE);
}
